<?php
ob_start();
session_start();
require_once "config/db.php";

if(!isset($_SESSION['admin'])){
    header("Location: login.php");
    exit;
}

$error = '';
$success = '';

// Handle delete
if(isset($_GET['delete']) && is_numeric($_GET['delete'])){
    $id = intval($_GET['delete']);
    $stmt = $conn->prepare("DELETE FROM subcategories WHERE id = ?");
    $stmt->bind_param("i", $id);

    if($stmt->execute()){
        $success = "Subcategory deleted successfully!";
    } else {
        $error = "Error deleting subcategory: " . $conn->error;
    }
    $stmt->close();
}

// Fetch subcategories with parent category
$subcategories = $conn->query("
    SELECT s.id, s.name AS sub_name, c.name AS cat_name, s.created_at 
    FROM subcategories s 
    JOIN categories c ON s.category_id = c.id 
    ORDER BY s.id DESC
");
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Axle_Services</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
<link rel="stylesheet" href="css/style.css">
<link rel="stylesheet" href="css/header.css">
<link rel="stylesheet" href="css/sidebar.css">

<style>
.page-header {
    background-color: #3182ce;
    color: #fff;
    padding: 15px;
    text-align: center;
    margin-bottom: 20px;
    border-radius: 8px;
}
.table-container {
    background: #fff;
    padding: 15px;
    border-radius: 10px;
    box-shadow: 0 6px 15px rgba(0,0,0,0.1);
    overflow-x: auto; /* responsive horizontal scroll */
}
.main-content {
    margin-top: 70px;       /* below header */
    margin-left: 250px;     /* space for sidebar */
    padding: 20px;
    transition: all 0.3s ease;
}
@media(max-width: 768px){
    .main-content { margin-left: 0; }
    .table td, .table th { font-size: 14px; padding: 6px; white-space: nowrap; }
    .btn-sm { font-size: 12px; padding: 4px 6px; }
}
</style>
</head>
<body>

<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>

<div class="main-content">
    <div class="page-header">
        <h1>Subcategory List</h1>
    </div>

    <div class="table-container">
        <?php if($error): ?>
            <div class="alert alert-danger text-center"><?= $error ?></div>
        <?php endif; ?>
        <?php if($success): ?>
            <div class="alert alert-success text-center"><?= $success ?></div>
        <?php endif; ?>

        <table class="table table-bordered table-striped table-hover align-middle">
            <thead class="table-primary">
                <tr>
                    <th>#</th>
                    <th>Subcategory Name</th>
                    <th>Category</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php if($subcategories->num_rows > 0): ?>
                    <?php $i=1; while($row = $subcategories->fetch_assoc()): ?>
                        <tr>
                            <td><?= $i++; ?></td>
                            <td><?= htmlspecialchars($row['sub_name']); ?></td>
                            <td><?= htmlspecialchars($row['cat_name']); ?></td>
                            <td>
                                <a href="?delete=<?= $row['id']; ?>" 
                                   onclick="return confirm('Are you sure you want to delete this subcategory?');"
                                   class="btn btn-danger btn-sm">
                                   <i class="bi bi-trash"></i> Delete
                                </a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr><td colspan="5" class="text-center">No subcategories found.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<script src="/js/script.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php ob_end_flush(); ?>