<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

ob_start();
session_start();

require_once "config/db.php";

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

if (!isset($_GET['id'])) {
    die("Form ID not provided.");
}

$form_id = intval($_GET['id']);


$sql = "SELECT f.*, c.name AS company_name, c.address AS company_address 
        FROM stability_date_forms f 
        LEFT JOIN companies c ON f.company_id = c.id
        WHERE f.id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $form_id);
$stmt->execute();

$meta = $stmt->result_metadata();
$fields = [];
$row = [];
while ($field = $meta->fetch_field()) {
    $fields[] = &$row[$field->name];
}
call_user_func_array([$stmt, 'bind_result'], $fields);

$form = null;
if ($stmt->fetch()) {
    foreach ($row as $key => $val) {
        $form[$key] = $val;
    }
}
$stmt->close();

function safe_date($dateStr)
{
    return (!empty($dateStr) && strtotime($dateStr) !== false)
        ? date('d-m-Y', strtotime($dateStr))
        : '';
}
if (!$form) {
    die("Form not found.");
}

$reminder_sql = "SELECT reminder_date, expiry_date 
                 FROM company_reminders 
                 WHERE company_id = ? AND subcategory_name = 'Stability Date' 
                 ORDER BY id DESC 
                 LIMIT 1";
$reminder_stmt = $conn->prepare($reminder_sql);
$reminder_stmt->bind_param("i", $form['company_id']);
$reminder_stmt->execute();

$meta2 = $reminder_stmt->result_metadata();
$fields2 = [];
$row2 = [];
while ($field2 = $meta2->fetch_field()) {
    $fields2[] = &$row2[$field2->name];
}
call_user_func_array([$reminder_stmt, 'bind_result'], $fields2);

$reminder = null;
if ($reminder_stmt->fetch()) {
    foreach ($row2 as $key => $val) {
        $reminder[$key] = $val;
    }
}
$reminder_stmt->close();

$reminder_date = $reminder['reminder_date'] ?? '';
$expiry_date   = $reminder['expiry_date'] ?? '';
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Axle_Services</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <link rel="stylesheet" href="css/style.css">

    <style>
        /* -------------------------
           General styles
        ------------------------- */
        body {
            color: #000;
            background: #fff;

        }


        .main-content {
            font-family: "Times New Roman", Times, serif;

            margin-top: 90px;
            margin-left: 250px;
            padding: 30px 40px;
            transition: all 0.3s ease;
            min-height: calc(100vh - 70px);
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 8px 24px rgb(0 0 0 / 0.05);
            font-size: 17px;
        }

        @media (max-width: 991.98px) {
            .main-content {
                margin-left: 0;
                padding: 20px;
                border-radius: 0;
                box-shadow: none;
            }
        }

        h3 {
            text-align: center;
            margin-bottom: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        table,
        th,
        td {
            border: none !important;
        }

        th,
        td {
            padding: 2px;
            vertical-align: top;
            text-align: left;
        }

        .footer-declaration {
            margin-top: 20px;
        }

        p,
        .form-control {
            padding: 0px;
            margin-bottom: 0px;
            font-size: 16px;
        }

        .engineer-info {
            font-size: 12px;
            margin-bottom: 18px;
            line-height: 1.2;
        }

        td:first-child {
            width: 30px;
        }

        /* Dark blue color for td text */
        td,
        b,
        strong {
            color: #003366 !important;
            font-weight: 600;
        }

        /* Highlighted sentence style */
        .highlight-blue {
            color: #003366 !important;
            font-weight: bold;
        }

        .page-border {
            position: fixed;
            top: 0;
            left: 0;
            height: 100%;
            width: 100%;
            border: 4px solid #003366;
            z-index: 9999;
            box-sizing: border-box;
            pointer-events: none;

        }

        /* Fixed header info shown on every printed page (and visible on screen for preview) */
        .page-header-info {
            position: fixed;
            top: 8px;
            left: 0;
            right: 0;
            width: 100%;
            padding: 0 18px;
            font-size: 13px;
            font-weight: bold;
            color: #003366;
            display: flex;
            justify-content: space-between;
            align-items: center;
            z-index: 9999;
            pointer-events: none;
        }

        .page-header-info .left,
        .page-header-info .right {
            background: rgba(255, 255, 255, 0.0);
            padding: 2px 6px;
        }

        /* Print configuration */
        @page {
            size: A4;
            margin: 10px;
        }

        @media print {
            body {
                margin: 0;
                padding: 0;
                visibility: visible;

            }


            * {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }

            .first-page-header {

                padding: 0 20px;
                display: flex;
                justify-content: space-between;
                font-weight: bold;
                font-size: 14px;
                color: #003366;
                z-index: 9999;
                margin-bottom: 10px;

            }

            /* ensure border and header are visible even though we hide other elements */
            .page-border,
            .page-header-info,
            .main-content,
            .first-page-header {
                visibility: visible !important;
            }

            .main-content {
                margin-top: 10px;
            }

            /* hide everything except main content and header/footer/border during print */
            body * {
                visibility: hidden;
            }

            b {
                color: #003366;
            }

            .page-border,
            .page-header-info,
            .main-content,
            .main-content * {
                visibility: visible;
            }

            /* ensure header and border sit above content properly */
            .page-border {
                z-index: 9999;
                position: fixed;
            }

            .page-header-info {
                position: fixed;
                top: 5px;
                left: 0;
                right: 0;
                z-index: 10;
            }

            .main-content {
                position: absolute;
                left: 0;
                top: 0px;
                width: 100%;
                box-shadow: none;
                border-radius: 0;
            }

            .page-break-after {
                page-break-after: always;
            }

            .form-second-header-wrapper {
                display: block;
                margin-top: 5mm !important;
            }



            #printBtn,
            #footerbtn,
            #checkfooter {
                display: none;
            }

            .engineer-info {
                page-break-after: avoid;
            }

            .page1-bottom {
                margin-top: 60mm;
            }

            body.printing-page-2 .first-page-header {
                display: none !important;
            }
        }

        /* Page break */
        .page-break {
            page-break-before: always;
        }

        .second-page-header {
            display: none;
            font-weight: bold;
            font-size: 14px;
            color: #003366;
            margin-top: 10px;

            padding: 0 20px;
            width: 100%;
            display: flex;
            justify-content: space-between;
        }

        .footer {
            width: 80%;
            border: none;
            margin-top: 20px;
            text-align: center;
            font-size: 14px;
            background-color: #03b8ed;
            color: #fff;
            padding: 10px;
        }

        @media print {
            .second-page-header {
                display: flex !important;
                margin-top: 15mm !important;
            }

            .footer {
                position: fixed;
                bottom: 0;
                left: 50%;
                transform: translateX(-50%);
                width: 95%;
                background-color: #03b8ed;
                color: #fff;
                text-align: center;
                font-size: 14px;
                padding: 10px 0;
                border-radius: 5px;
            }

        }
    </style>
</head>

<body>
    <?php include 'header.php'; ?>
    <?php include 'sidebar.php'; ?>


    <div class="page-border"></div>



    <div class="main-content">

        <div class="d-flex justify-content-end mb-3">
            <button class="btn btn-primary w-25" id="printBtn" onclick="window.print()">Print</button>
        </div>
        <?php if (!empty($success_message)): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?= htmlspecialchars($success_message) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>




        <!-- <table class="orm-second-header-wrapper" style="width:100%; border: none; margin-bottom: 20px;">
            <tr style="background-color: #03b8ed; color: #fff;">
                <td style="text-align:center; font-size: 1.5rem; padding: 12px;">CERTIFICATE OF STABILITY</td>
            </tr>
        </table> -->



        <!-- FIRST PAGE COVER -->
        <div class=" first-page no-footer">
            <h1 style="text-align:center; font-size: 2rem; margin-bottom: 30px;">CERTIFICATE OF STABILITY</h1>
            <h4 style="text-align:center; margin-bottom: 30px;">Rule 3-A Of The Maharashtra Factories Rules,1963.</h4>

            <div style="text-align:center; margin-bottom: 50px;">
                <h2 style="text-transform: uppercase;"><strong><?php echo htmlspecialchars($form['company_name'] ?? ''); ?></strong></h2>
                <br>
                <h5><b> Address:</b> <?php echo htmlspecialchars($form['factory_address'] ?? ''); ?></h5>
            </div>


            <div style="text-align:center; margin-bottom: 20px;">
                <!-- <img src="images/image1.jpg"
                    alt="Factory Image"
                    style="max-width:600px; width:100%; height:auto; display:block; margin:0 auto;"> -->
                <?php if ($form['photo1']) { ?>
                    <img src="uploads/<?= htmlspecialchars($form['photo1']) ?>" alt="Photo 1" style="max-width:800px; width:100%">
                <?php } ?>

            </div>


            <div style="text-align:center; margin-top: 70px;"><br>
                <h3 style="margin-bottom: 10px;"><strong>By</strong></h3><br>
                <h1 style="margin-bottom: 10px;">AXLE CONSULTANCY SERVICES</h1><br>
                <h5> Silver Plaza II, 2nd Floor, Subhash Road, B Ward, Kolhapur -416012</h5>
            </div>
        </div>




        <div class="page-break-after"></div>


        <div class="second-page-header">
            <div class="left mt-4">CERTIFICATE NO: <?= $form['id'] ?></div>
            <div class="right mt-4">DATE: <?= date("d-m-Y") ?></div>
        </div>
        <div class="form-second-header-wrapper ">
            <table style="width:100%; border: none; margin-bottom: 20px;">
                <tr style="background-color: #03b8ed; color: #eaeff0ff;">
                    <td style="text-align:center; font-size: 1.5rem; padding: 12px;">CERTIFICATE OF STABILITY</td>
                </tr>
            </table>
        </div>

        <h6 style="text-align:center; font-weight:bold; margin-top:-10px; margin-bottom:20px;">
            FORM NO. I A (RULE 3A)
        </h6>

        <table>
            <tbody>
                <tr>
                    <td>1.</td>
                    <th style="width:45%"> Name of Factory</th>
                    <td>:</td>
                    <td><?= htmlspecialchars($form['company_name']) ?></td>
                </tr>
                <tr>
                    <td>2.</td>
                    <th>Address of Factory</th>
                    <td>:</td>
                    <td><?= htmlspecialchars($form['factory_address'] ?: $form['company_address']) ?></td>
                </tr>
                <tr>
                    <td>3.</td>
                    <th>Village</th>
                    <td>:</td>
                    <td><?= htmlspecialchars($form['village']) ?></td>
                </tr>
                <tr>
                    <td></td>
                    <th>Town</th>
                    <td>:</td>
                    <td><?= htmlspecialchars($form['town']) ?></td>
                </tr>
                <tr>
                    <td></td>
                    <th>District</th>
                    <td>:</td>
                    <td><?= htmlspecialchars($form['district']) ?></td>
                </tr>
                <tr>
                    <td>4.</td>
                    <th>Name of the occupier of the factory</th>
                    <td>:</td>
                    <td><?= htmlspecialchars($form['factory_occupier_name']) ?></td>
                </tr>
                <tr>
                    <td>5.</td>
                    <th>Nature of Manufacturing Process</th>
                    <td>:</td>
                    <td><?= htmlspecialchars($form['manufacturing_process']) ?></td>
                </tr>
                <tr>
                    <td>6.</td>
                    <th>Number of Floors on which worker will be employed</th>
                    <td>:</td>
                    <td><?= htmlspecialchars($form['number_of_floors']) ?></td>
                </tr>
            </tbody>
        </table>

        <div class="footer-declaration">
            <p>
                I certify that I have inspected the premises, the plan of which has been approved by the Chief Inspector
                in his letter
                <b class="highlighted-value"><?= !empty($form['ref_number_1']) ? 'Ref: ' . htmlspecialchars($form['ref_number_1']) : '' ?></b>
                Dated <b><?= !empty($form['date1']) ? safe_date($form['date1']) : '' ?></b>.

                And examined the various parts including the foundations with special reference to the machinery, plant etc, that have been installed.
                I am of the opinion that all works of engineering constructions in the premises are structurally sound and that their stability will not be
                endangered by their use of a factory for
                <b><?= !empty($form['manufacturing_process']) ? htmlspecialchars($form['manufacturing_process']) : '' ?></b>,
                for which the machinery, plant etc. installed are intended.
            </p>
        </div>
        <div class="page1-bottom engineer-info text-left">
            <p class="text-center mb-2"><strong>SHRIKANT YADAV</strong></p><br>
            <p><strong>Qualification:</strong> B.E. (Civil) A.M.I.E.C.E. Chartered Engineer (India)</p><br>
            <p> <strong>Address:</strong> Silver Plaza II, 2nd Floor, Subhash Road, Mangalwar Peth, Kolhapur</p><br>
            <p>
                <strong>Date:</strong> 02/05/2025
                <span style="display:inline-block; width:30%;"></span>
                <strong>Mobile:</strong> 9405553405
            </p>
        </div>

        <!-- PAGE BREAK AFTER CERTIFICATION PARAGRAPH -->
        <div class="page-break-after"></div>


        <h6 style="text-align:center; margin-top:10px; text-transform: uppercase;">
            <b><?= htmlspecialchars($form['company_name']) ?></b>
        </h6>
        <div class="form-second-header-wrapper">
            <table style="width:100%; border: none; margin-bottom: 20px;">
                <tr style="background-color: #03b8ed; color: #eaeff0ff;">
                    <td style="text-align:center; font-size: 1.5rem; padding: 12px;">CERTIFICATE OF STABILITY</td>
                </tr>
            </table>
        </div>

        <table>
            <tbody>
                <h5 class="text-center">
                    REPORT OF STRUCTURAL STABILITY OF INDUSTRIAL BUILDING ON <br>
                    <b>
                        <?= strtoupper(htmlspecialchars($form['factory_address'])) ?>,<br>

                        FOR <br>
                        <?= strtoupper(htmlspecialchars($form['company_name'])) ?><br>
                        <?= strtoupper(htmlspecialchars($form['district'])) ?>.
                    </b>
                </h5>

                <tr class="mt-4">
                    <td>0.0</td>
                    <th style="width: 45%;">COMPETENCE OF STRUCTURAL ENGINEER<br> He should be a member of Institution of Engineers.</th>
                    <td>:</td>
                    <td><?= nl2br(htmlspecialchars($form['competence_structural_eng'])) ?></td>
                </tr>
                <tr>
                    <td>0.1</td>
                    <th>Name of Structural Engineer Inspecting the building.</th>
                    <td>:</td>
                    <td><?= htmlspecialchars($form['structural_eng_name']) ?></td>
                </tr>
                <tr>
                    <td>0.2</td>
                    <th>Date of Inspection</th>
                    <td>:</td>
                    <td><?= safe_date($form['inspection_date']) ?></td>
                </tr>
                <tr>
                    <td>0.3</td>
                    <th>Name of person issuing stability certificate</th>
                    <td>:</td>
                    <td><?= htmlspecialchars($form['issue_stability_person']) ?></td>
                </tr>

                <tr>
                    <td>1.0</td>
                    <th> DESCRIPTION OF THE BUILDING</th>
                    <td>:</td>
                    <td>&nbsp;</td>
                </tr>
                <tr>
                    <td>1.1</td>
                    <th>Set of Architectural and Structural Drawings Viz. plans, elevations sections details of M/c layout etc. copies to be studied by the Structural Engineer</th>
                    <td>:</td>
                    <td><?= htmlspecialchars($form['drawings']) ?></td>
                </tr>
                <tr>
                    <td>1.2</td>
                    <th>General description of the building mentioning number of buildings, number of stories, year of construction (if known) otherwise as per the judgment, type of structural such as load bearing, framed, composite etc. and materials of construction paintings coatings, type of joints etc.,</th>
                    <td>:</td>
                    <td><?= htmlspecialchars($form['building_mentioning_no_disc']) ?></td>
                </tr>
                <tr>
                    <td>1.3</td>
                    <th>General condition of the building and signs of weakness of functional interruptions, vibrations, cracks deflections, joints yielding etc., leakages correction, clarify the buildings overall condition as excellent good satisfactory, unsatisfactory</th>
                    <td>:</td>
                    <td><?= htmlspecialchars($form['general_condition']) ?></td>
                </tr>

                <tr class="page-break-after"></tr>
            </tbody>
        </table>


        <h6 style="text-align:center; margin-top:10mm; margin-bottom:10mm; text-transform: uppercase;">
            <b><?= htmlspecialchars($form['company_name']) ?></b>
        </h6>
        <!-- <div class="form-second-header-wrapper">
            <table style="width:100%; border: none; margin-bottom: 20px;">
                <tr style="background-color: #03b8ed; color: #eaeff0ff;">
                    <td style="text-align:center; font-size: 1.5rem; padding: 12px;">CERTIFICATE OF STABILITY</td>
                </tr>
            </table>
        </div> -->

        <table>
            <tbody>
                <tr>
                    <td>1.4</td>
                    <th style="width: 45%;">History on Maintenance of the buildings covering details on internal and external painting, replastering, grouting, gunniting, strengthening, additions, alternations, water proofing modifications to Air-conditioning piping, false ceiling, partions etc., Any welding to the reinforcement of RCC members by exposing it for the purpose of providing anchorage, mezzanine floors etc.</th>
                    <td>:</td>
                    <td><?= htmlspecialchars($form['building_maintainance_history']) ?></td>
                </tr>

                <tr>
                    <td>2.0</td>
                    <th>AGEING AND OVER LOADING :</th>
                    <td>:</td>
                </tr>
                <tr>
                    <td>2.1</td>
                    <th>Usage</th>
                    <td>:</td>
                    <td><?= htmlspecialchars($form['loading_usage']) ?></td>
                </tr>
                <tr>
                    <td>2.2</td>
                    <th>Original purpose: Changes if any to be fully checked for adequacy in strength of supporting structural system from the point of stable loading as well as vibration levels if any</th>
                    <td>:</td>
                    <td><?= htmlspecialchars($form['original_purpose']) ?></td>
                </tr>
                <tr>
                    <td>2.3</td>
                    <th>Phase wise construction and installation details</th>
                    <td>:</td>
                    <td><?= htmlspecialchars($form['phase_wise_details']) ?></td>
                </tr>
                <tr>
                    <td>2.4</td>
                    <th>Logbook of Building Inspection</th>
                    <td>:</td>
                </tr>
                <tr>
                    <td>a.</td>
                    <th>To show Accidents due to failing of plaster, buckling, bending etc., of structural members, giving away of joints fire accidents.</th>
                    <td>:</td>
                    <td><?= htmlspecialchars($form['structural_member_accidents']) ?></td>
                </tr>
                <tr>
                    <td>2.5</td>
                    <th>Additions/Alteration Upto date additions/Alterations to be incorporated in the drawings each addition to be fully checked for adequacy in strength after providing the allowances to loss of strength due to corrosion, erosion etc.,</th>
                    <td>:</td>
                    <td><?= htmlspecialchars($form['addition_alteration']) ?></td>
                </tr>
                <tr>
                    <td>2.6</td>
                    <th>Environmental detriments Corrosion of structural steel members</th>
                    <td>:</td>
                    <td><?= htmlspecialchars($form['env_detriments']) ?></td>
                </tr>
                <tr class="page-break-after"></tr>
            </tbody>
        </table>


        <h6 style="text-align:center; margin-top:10px; text-transform: uppercase;">
            <b><?= htmlspecialchars($form['company_name']) ?></b>
        </h6>
        <div class="form-second-header-wrapper">
            <table style="width:100%; border: none; margin-bottom: 20px;">
                <tr style="background-color: #03b8ed; color: #eaeff0ff;">
                    <td style="text-align:center; font-size: 1.5rem; padding: 12px;">CERTIFICATE OF STABILITY</td>
                </tr>
            </table>
        </div>

        <table>
            <tbody>
                <tr>
                    <td>3.0</td>
                    <th style="width: 45%;"> SAFETY RECOMMENDATIONS :</th>
                    <td>:</td>
                </tr>
                <tr>
                    <td>3.1</td>
                    <th>Date of Next Inspection Recommended </th>
                    <td>:</td>
                    <td><?= htmlspecialchars($form['next_inspection']) ?></td>
                </tr>
                <tr>
                    <td>3.2</td>
                    <th>Recommendations in Long-term strengthening measures whichshould be incorporated within six months</th>
                    <td>:</td>
                    <td><?= nl2br(htmlspecialchars($form['long_term_strength'])) ?></td>
                </tr>
                <tr>
                    <td></td>
                    <th>Photo 1</th>
                    <td>:</td>
                    <td><?php if ($form['photo1']) { ?><img src="uploads/<?= htmlspecialchars($form['photo1']) ?>" alt="Photo 1" style="max-width:200px;"><?php } ?></td>
                </tr>
                <tr>
                    <td></td>
                    <th>Photo 2</th>
                    <td>:</td>
                    <td><?php if ($form['photo2']) { ?><img src="uploads/<?= htmlspecialchars($form['photo2']) ?>" alt="Photo 2" style="max-width:200px;"><?php } ?></td>
                </tr>
                <tr>
                    <td></td>
                    <th>Photo 3</th>
                    <td>:</td>
                    <td><?php if ($form['photo3']) { ?><img src="uploads/<?= htmlspecialchars($form['photo3']) ?>" alt="Photo 3" style="max-width:200px;"><?php } ?></td>
                </tr>
                <tr>
                    <td></td>
                    <th>Photo 4</th>
                    <td>:</td>
                    <td><?php if ($form['photo4']) { ?><img src="uploads/<?= htmlspecialchars($form['photo4']) ?>" alt="Photo 4" style="max-width:200px;"><?php } ?></td>
                </tr>
            </tbody>
        </table>

        <div class="footer-declaration">

            <p><strong>Signature of Competent Person:</strong></p><br>
            <table>
                <tbody>
                    <tr>
                        <td>1</td>
                        <th style="width: 45%;">Name of Competent Person</th>
                        <td>:</td>
                        <td><?= htmlspecialchars($form['competent_name'] ?? '') ?></td>
                    </tr>
                    <tr>
                        <td>2</td>
                        <th>Qualification</th>
                        <td>:</td>
                        <td><?= htmlspecialchars($form['competent_qualification'] ?? '') ?></td>
                    </tr>
                    <tr>
                        <td>3</td>
                        <th>Address</th>
                        <td>:</td>
                        <td><?= nl2br(htmlspecialchars($form['competent_address'] ?? '')) ?></td>
                    </tr>
                    <tr>
                        <td>4</td>
                        <th>Date</th>
                        <td>:</td>
                        <td><?= !empty($reminder_date) ? date('d-m-Y', strtotime($reminder_date)) : '' ?></td>
                    </tr>
                    <tr>
                        <td>5</td>
                        <th>Next Due Date</th>
                        <td>:</td>
                        <td><?= !empty($expiry_date) ? date('d-m-Y', strtotime($expiry_date)) : '' ?></td>
                    </tr>
                </tbody>
            </table>

        </div>
        <table class="footer" style=" border: none; margin-top: 20px;">
            <tr style="background-color: #03b8ed; color: #fff;">
                <td style="text-align:center; font-size: 14px; padding: 10px;">
                    CERTIFICATE OF STABILITY<br>

                </td>
            </tr>
        </table>



        <script src="/js/script.js"></script>
</body>

</html>
<?php ob_end_flush(); ?>