<?php
ob_start();
session_start();
require_once "config/db.php";

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

// Handle delete request
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $conn->query("DELETE FROM shot_blasting_forms WHERE id = $id");
    header("Location: shot_blasting_list.php?msg=deleted");
    exit;
}

// Fetch Shot Blasting entries with company name
$sql = "SELECT f.*, c.name AS company_name 
        FROM shot_blasting_forms f
        LEFT JOIN companies c ON f.company_id = c.id
        ORDER BY f.id DESC";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Axle_Services</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="css/header.css">
<link rel="stylesheet" href="css/sidebar.css">
<style>
body {
    background: #f8f9fa;
}
.main-content {
    margin-top: 70px;
    margin-left: 250px;
    padding: 20px;
    transition: all 0.3s ease;
}
.table-container {
    background: #fff;
    padding: 15px;
    border-radius: 10px;
    box-shadow: 0 6px 15px rgba(0,0,0,0.1);
    overflow-x: auto;
}
.page-header {
    background-color: #0d6efd;
    color: #fff;
    padding: 15px;
    text-align: center;
    margin-bottom: 20px;
    border-radius: 8px;
    text-transform: uppercase;
}
.table th, .table td {
    vertical-align: middle;
    white-space: nowrap;
}
@media (max-width: 768px) {
    .main-content { margin-left: 0; }
}
</style>
</head>
<body>

<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>

<div class="main-content">
    <div class="page-header">Shot Blasting Form Entries</div>

    <div class="table-container">
        <?php if (isset($_GET['msg']) && $_GET['msg'] == 'deleted'): ?>
            <div class="alert alert-success">Shot Blasting entry deleted successfully!</div>
        <?php endif; ?>

        <table class="table table-bordered table-striped table-hover align-middle">
            <thead class="table-primary">
                <tr>
                    <th>ID</th>
                    <th>Company Name</th>
                    <th>Factory Address</th>
                    <th>Equipment Name</th>
                    <th>Distinguishing Number</th>
                    <th>Blasting Chamber Condition</th>
                    <th>Dust Escape Chamber</th>
                    <th>Separation Effective</th>
                    <th>Continuous Operation</th>
                    <th>Effective Extraction</th>
                    <th>Filtration Device</th>
                    <th>Dust in Workroom</th>
                    <th>Leakage in Ducting</th>
                    <th>Remarks</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php if ($result->num_rows > 0): ?>
                <?php while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= $row['id'] ?></td>
                        <td><?= htmlspecialchars($row['company_name']) ?></td>
                        <td><?= htmlspecialchars($row['factory_address']) ?></td>
                        <td><?= htmlspecialchars($row['equipment_name']) ?></td>
                        <td><?= htmlspecialchars($row['distinguishing_number']) ?></td>
                        <td><?= htmlspecialchars($row['blasting_chamber_condition']) ?></td>
                        <td><?= htmlspecialchars($row['dust_escape_chamber']) ?></td>
                        <td><?= htmlspecialchars($row['separation_apparatus_effective']) ?></td>
                        <td><?= htmlspecialchars($row['separation_continuous_operation']) ?></td>
                        <td><?= htmlspecialchars($row['separation_effective_extraction']) ?></td>
                        <td><?= htmlspecialchars($row['separation_filtration_device']) ?></td>
                        <td><?= htmlspecialchars($row['separation_dust_in_workroom']) ?></td>
                        <td><?= htmlspecialchars($row['separation_leakage_ducting']) ?></td>
                        <td><?= htmlspecialchars($row['remarks']) ?></td>
                        <td>
                            <a href="shot_blasting_print.php?id=<?= $row['id'] ?>" target="_blank" class="btn btn-primary btn-sm">Print</a>
                            <a href="edit_shot_blasting.php?id=<?= $row['id'] ?>" class="btn btn-warning btn-sm">Edit</a>
                            <a href="shot_blasting_list.php?delete=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Delete this entry?');">Delete</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr><td colspan="15" class="text-center">No entries found</td></tr>
            <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<script src="/js/script.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php ob_end_flush(); ?>
