<?php
ob_start();
session_start();
require_once "config/db.php";

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}


$companies = $conn->query("SELECT id, name, address FROM companies");
$success_message = '';
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Collect inputs
    $company_id = !empty($_POST['company_id']) ? (int)$_POST['company_id'] : null;
    $factory_address = trim($_POST['factory_address'] ?? '');
    $equipment_name = trim($_POST['equipment_name'] ?? '');
    $distinguishing_number = trim($_POST['distinguishing_number'] ?? '');

    $blasting_chamber_condition = trim($_POST['blasting_chamber_condition'] ?? '');
    $dust_escape_chamber = $_POST['dust_escape_chamber'] ?? 'No';

    $separation_apparatus_effective = $_POST['separation_apparatus_effective'] ?? 'No';
    $separation_continuous_operation = $_POST['separation_continuous_operation'] ?? 'No';
    $separation_effective_extraction = $_POST['separation_effective_extraction'] ?? 'No';
    $separation_filtration_device = $_POST['separation_filtration_device'] ?? 'No';
    $separation_dust_in_workroom = $_POST['separation_dust_in_workroom'] ?? 'No';
    $separation_leakage_ducting = $_POST['separation_leakage_ducting'] ?? 'No';

    $remarks = trim($_POST['remarks'] ?? '');
    $competent_name = trim($_POST['competent_name'] ?? '');
  $competent_qualification = trim($_POST['competent_qualification'] ?? '');
  $competent_address = trim($_POST['competent_address'] ?? '');

    // SQL insert
    $sql = "INSERT INTO shot_blasting_forms (
        company_id, factory_address, equipment_name, distinguishing_number,
        blasting_chamber_condition, dust_escape_chamber,
        separation_apparatus_effective, separation_continuous_operation, separation_effective_extraction,
        separation_filtration_device, separation_dust_in_workroom, separation_leakage_ducting,
        remarks,competent_name, competent_qualification, competent_address
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?)";

    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        die("Prepare failed: " . $conn->error);
    }

    // Bind parameters
    $stmt->bind_param(
        "isssssssssssssss",
        $company_id,
        $factory_address,
        $equipment_name,
        $distinguishing_number,
        $blasting_chamber_condition,
        $dust_escape_chamber,
        $separation_apparatus_effective,
        $separation_continuous_operation,
        $separation_effective_extraction,
        $separation_filtration_device,
        $separation_dust_in_workroom,
        $separation_leakage_ducting,
        $remarks,
        $competent_name,
  $competent_qualification,
  $competent_address
    );

   if ($stmt->execute()) {

    // Insert reminder if date is selected
    $reminder_date = !empty($_POST['reminder_date']) ? $_POST['reminder_date'] : null;

    if ($reminder_date && $company_id) {
        //  category and subcategory names
        $category_name = 'DISH';
        $subcategory_name = 'Shot-Blasting';

        // Hvalidity: 12 months
        $validity_months = 12;

        // Calculate expiry date based on validity months
        $expiry_date = date('Y-m-d', strtotime("+$validity_months months", strtotime($reminder_date)));

        // Insert into company_reminders (using names instead of IDs)
        $reminder_sql = "INSERT INTO company_reminders 
            (company_id, category_name, subcategory_name, reminder_date, expiry_date, status, created_at) 
            VALUES (?, ?, ?, ?, ?, 'pending', NOW())";
        $reminder_stmt = $conn->prepare($reminder_sql);
        $reminder_stmt->bind_param("issss", $company_id, $category_name, $subcategory_name, $reminder_date, $expiry_date);

        if (!$reminder_stmt->execute()) {
            die("Reminder insert failed: " . $reminder_stmt->error);
        }
        $reminder_stmt->close();
    }

    $_SESSION['success_message'] = "Shot Blasting form submitted successfully!";
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;


    } else {
        $error_message = "Error: " . $stmt->error;
    }

    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Axle_Services</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
<link rel="stylesheet" href="css/style.css" />
<link rel="stylesheet" href="css/header.css" />
<link rel="stylesheet" href="css/sidebar.css" />
<style>
  body {
    background: #f9fafb;
    
    color: #333;
    min-height: 100vh;
  }

  .main-content {
    margin-top: 70px;
    margin-left: 250px;
    padding: 30px 40px;
    transition: all 0.3s ease;
    min-height: calc(100vh - 70px);
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 8px 24px rgb(0 0 0 / 0.05);
  }

  @media (max-width: 991.98px) {
    .main-content {
      margin-left: 0;
      padding: 20px;
      border-radius: 0;
      box-shadow: none;
    }
  }

  .page-header {
    background-color: #0d6efd;
    color: #fff;
    padding: 20px 25px;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgb(13 110 253 / 0.3);
    margin-bottom: 30px;
    text-align: center;
    font-weight: 600;
    font-size: 1.8rem;
    letter-spacing: 0.03em;
  }

  form {
    max-width: 900px;
    margin: 0 auto;
  }

  label.form-label {
    font-weight: 600;
    color: #495057;
  }

  input.form-control,
  select.form-select,
  textarea.form-control {
    border-radius: 8px;
    border: 1.5px solid #ced4da;
    padding: 10px 14px;
    font-size: 1rem;
    transition: border-color 0.3s ease, box-shadow 0.3s ease;
  }

  input.form-control:focus,
  select.form-select:focus,
  textarea.form-control:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 8px rgb(13 110 253 / 0.25);
    outline: none;
  }

  textarea.form-control {
    min-height: 80px;
    resize: vertical;
  }

  h6 {
    font-weight: 400;
    color: #0d6efd;
    margin-top: 40px;
    margin-bottom: 20px;
    border-bottom: 2px solid #0d6efd;
    padding-bottom: 6px;
  }

  .btn-success {
    background-color: #198754;
    border-color: #198754;
    font-weight: 600;
    font-size: 1.1rem;
    padding: 12px 40px;
    border-radius: 50px;
    transition: background-color 0.3s ease, box-shadow 0.3s ease;
  }

  .btn-success:hover {
    background-color: #157347;
    box-shadow: 0 6px 15px rgb(21 115 71 / 0.4);
  }

  .alert {
    max-width: 900px;
    margin: 0 auto 30px auto;
    border-radius: 10px;
    font-weight: 600;
    font-size: 1rem;
  }

  @media (max-width: 575.98px) {
    form .col-md-6,
    form .col-md-4,
    form .col-12 {
      flex: 0 0 100% !important;
      max-width: 100% !important;
    }
  }
</style>
</head>
<body>
<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>

<div class="main-content">
  <div class="page-header">Shot Blasting Form</div>

  <?php if ($error_message): ?>
    <div class="alert alert-danger shadow-sm"><?= htmlspecialchars($error_message) ?></div>
  <?php endif; ?>
  <?php if (isset($_SESSION['success_message'])): ?>
    <div class="alert alert-success shadow-sm"><?= htmlspecialchars($_SESSION['success_message']) ?></div>
    <?php unset($_SESSION['success_message']); ?>
  <?php endif; ?>

  <form method="POST" class="row g-4" novalidate>
    <!-- Company -->
   <div class="row align-items-center mb-3 mt-3">
  <div class="col-md-4">
    <label class="form-label" for="companySelect">1. Name of occupier of factory</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="company_name" id="companySearch" placeholder="Type company name..." autocomplete="off">
    <input type="hidden" name="company_id" id="companyId">
    <div id="companyList" class="list-group position-absolute bg-light" style="z-index:1000;"></div>
  </div>
</div>


    <!-- Factory Address -->
    <div class="row align-items-center mb-3">
      <div class="col-md-4">
        <label class="form-label" for="factoryAddress">2. Address of factory</label>
      </div>
      <div class="col-md-8">
        <input type="text" class="form-control" name="factory_address" id="factoryAddress" readonly />
      </div>
    </div>

    <!-- Equipment Name -->
    <div class="row align-items-center mb-3">
      <div class="col-md-4">
        <label class="form-label" for="equipmentName">Name of Equipment</label>
      </div>
      <div class="col-md-8">
        <input type="text" class="form-control" name="equipment_name" id="equipmentName" />
      </div>
    </div>

    <!-- Distinguishing Number -->
    <div class="row align-items-center mb-3">
      <div class="col-md-4">
        <label class="form-label" for="distinguishingNumber">3. Distinguishing number of mark and description sufficient to identify the Blasting Machine</label>
      </div>
      <div class="col-md-8">
        <textarea class="form-control" name="distinguishing_number" id="distinguishingNumber"></textarea>
      </div>
    </div>
<div class="row align-items-center mb-3">
      <div class="col-md-4">
      <label class="form-label" for="blastingChamberCondition">4. Blasting chamber condition</label>
      </div>
      <div class="col-md-8">
      <input type="text" class="form-control" name="blasting_chamber_condition" id="blastingChamberCondition">
      </div>
    </div>
    
   <div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label mb-0">5. Is dust escaping through chamber?</label>
  </div>
  <div class="col-md-6 d-flex">
    <div class="form-check me-3">
      <input class="form-check-input" type="radio" name="dust_escape_chamber" value="Yes" id="dustYes">
      <label class="form-check-label" for="dustYes">Yes</label>
    </div>
    <div class="form-check">
      <input class="form-check-input" type="radio" name="dust_escape_chamber" value="No" id="dustNo" checked>
      <label class="form-check-label" for="dustNo">No</label>
    </div>
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label mb-0">6. Separation Apparatus. Is separation of dust from abrasive effective?</label>
  </div>
  <div class="col-md-6 d-flex">
    <div class="form-check me-3">
      <input class="form-check-input" type="radio" name="separation_apparatus_effective" value="Yes" id="separationYes">
      <label class="form-check-label" for="separationYes">Yes</label>
    </div>
    <div class="form-check">
      <input class="form-check-input" type="radio" name="separation_apparatus_effective" value="No" id="separationNo" checked>
      <label class="form-check-label" for="separationNo">No</label>
    </div>
  </div>
</div>
 <div class="col-12">
      <h6>7. Ventilation Plant</h6>
    </div>

    <!-- a) Is this kept in operation continuously during working? -->
<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label mb-0">a) Is this kept in operation continuously during working ?</label>
  </div>
  <div class="col-md-6 d-flex">
    <div class="form-check me-3">
      <input class="form-check-input" type="radio" name="separation_continuous_operation" value="Yes" id="sepContinuousYes">
      <label class="form-check-label" for="sepContinuousYes">Yes</label>
    </div>
    <div class="form-check">
      <input class="form-check-input" type="radio" name="separation_continuous_operation" value="No" id="sepContinuousNo" checked>
      <label class="form-check-label" for="sepContinuousNo">No</label>
    </div>
  </div>
</div>

<!-- b) Is it effective in extracting? -->
<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label mb-0">b) Is it effective in extracting?</label>
  </div>
  <div class="col-md-6 d-flex">
    <div class="form-check me-3">
      <input class="form-check-input" type="radio" name="separation_effective_extraction" value="Yes" id="sepExtractYes">
      <label class="form-check-label" for="sepExtractYes">Yes</label>
    </div>
    <div class="form-check">
      <input class="form-check-input" type="radio" name="separation_effective_extraction" value="No" id="sepExtractNo" checked>
      <label class="form-check-label" for="sepExtractNo">No</label>
    </div>
  </div>
</div>

<!-- c) Is a filtrating/settling device working satisfactorily? -->
<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label mb-0">c) Is a filtrating/settling device working satisfactorily?</label>
  </div>
  <div class="col-md-6 d-flex">
    <div class="form-check me-3">
      <input class="form-check-input" type="radio" name="separation_filtration_device" value="Yes" id="sepFilterYes">
      <label class="form-check-label" for="sepFilterYes">Yes</label>
    </div>
    <div class="form-check">
      <input class="form-check-input" type="radio" name="separation_filtration_device" value="No" id="sepFilterNo" checked>
      <label class="form-check-label" for="sepFilterNo">No</label>
    </div>
  </div>
</div>

<!-- d) Is dust escaping in the workroom? -->
<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label mb-0">d) Is dust escaping in the workroom?</label>
  </div>
  <div class="col-md-6 d-flex">
    <div class="form-check me-3">
      <input class="form-check-input" type="radio" name="separation_dust_in_workroom" value="Yes" id="sepWorkroomYes">
      <label class="form-check-label" for="sepWorkroomYes">Yes</label>
    </div>
    <div class="form-check">
      <input class="form-check-input" type="radio" name="separation_dust_in_workroom" value="No" id="sepWorkroomNo" checked>
      <label class="form-check-label" for="sepWorkroomNo">No</label>
    </div>
  </div>
</div>

<!-- e) Is there any leakage of dust from ducting? -->
<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label mb-0">e) Is there any leakage of dust from ducting?</label>
  </div>
  <div class="col-md-6 d-flex">
    <div class="form-check me-3">
      <input class="form-check-input" type="radio" name="separation_leakage_ducting" value="Yes" id="sepLeakageYes">
      <label class="form-check-label" for="sepLeakageYes">Yes</label>
    </div>
    <div class="form-check">
      <input class="form-check-input" type="radio" name="separation_leakage_ducting" value="No" id="sepLeakageNo" checked>
      <label class="form-check-label" for="sepLeakageNo">No</label>
    </div>
  </div>
</div>

    <!-- Remarks -->
    <div class="row align-items-center mb-3">
  <div class="col-md-3">
    <label class="form-label mb-0" for="remarks">8. Remarks</label>
  </div>
  <div class="col-md-9">
    <input tyoe="text" class="form-control" name="remarks" id="remarks" rows="3" placeholder="Enter remarks here...">
  </div>
</div>
<div class="col-12 mt-4">
  <h6> Add Footer(Competent Person Details) </h6>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="competent_name">Name of Competent Person</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="competent_name" id="competent_name" placeholder="Enter competent person name">
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="competent_qualification">Qualification of Competent Person</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="competent_qualification" id="competent_qualification" placeholder="Enter qualification">
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="competent_address">Address of Competent Person</label>
  </div>
  <div class="col-md-8">
    <textarea class="form-control" name="competent_address" id="competent_address" placeholder="Enter address"></textarea>
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="reminderDate">9. Reminder Date</label>
  </div>
  <div class="col-md-4">
    <input type="date" class="form-control" name="reminder_date" id="reminderDate" />
  </div>
</div>

    <!-- Submit -->
    <div class="col-12 text-center mt-4">
      <button type="submit" class="btn btn-success px-5">Submit Form</button>
    </div>
  </form>
</div>


<script src="/js/script.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php ob_end_flush(); ?>