<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

ob_start();
session_start();
if (isset($_SESSION['success_message'])) {
    $success_message = $_SESSION['success_message'];
    unset($_SESSION['success_message']); 
}

require_once "config/db.php";

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

if (!isset($_GET['id'])) {
    die("Form ID not provided.");
}

$form_id = intval($_GET['id']);


// Fetch safety audit form data
$sql = "SELECT f.*, c.name AS company_name, c.address AS company_address 
        FROM safety_audit_forms f 
        LEFT JOIN companies c ON f.company_id = c.id
        WHERE f.id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $form_id);
$stmt->execute();

// ---- safe fetch without get_result() ----
$meta = $stmt->result_metadata();
$fields = [];
$row = [];
while ($field = $meta->fetch_field()) {
    $fields[] = &$row[$field->name];
}
call_user_func_array([$stmt, 'bind_result'], $fields);

$form = null;
if ($stmt->fetch()) {
    foreach ($row as $key => $val) {
        $form[$key] = $val;
    }
}
$stmt->close();

if (!$form) {
    die("Form not found.");
}

// Fetch reminder
$reminder_sql = "SELECT reminder_date, expiry_date 
                 FROM company_reminders 
                 WHERE company_id = ? AND subcategory_name = 'Safety Audit' 
                 ORDER BY id DESC 
                 LIMIT 1";
$reminder_stmt = $conn->prepare($reminder_sql);
$reminder_stmt->bind_param("i", $form['company_id']);
$reminder_stmt->execute();

$meta2 = $reminder_stmt->result_metadata();
$fields2 = [];
$row2 = [];
while ($field2 = $meta2->fetch_field()) {
    $fields2[] = &$row2[$field2->name];
}
call_user_func_array([$reminder_stmt, 'bind_result'], $fields2);

$reminder = null;
if ($reminder_stmt->fetch()) {
    foreach ($row2 as $key => $val) {
        $reminder[$key] = $val;
    }
}
$reminder_stmt->close();

$reminder_date = $reminder['reminder_date'] ?? '';
$expiry_date   = $reminder['expiry_date'] ?? '';
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Axle_Services - Safety Audit Print</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="css/header.css">
<link rel="stylesheet" href="css/sidebar.css">
<link rel="stylesheet" href="css/style.css">
<style>
body {
    font-family: Arial, sans-serif;
    color: #000;
    background: #fff;
}

.main-content {
    margin-top: 70px;
    margin-left: 250px;
    padding: 30px 40px;
    transition: all 0.3s ease;
    min-height: calc(100vh - 70px);
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 8px 24px rgb(0 0 0 / 0.05);
    font-size: 11px;
    overflow-x: hidden; /* prevent layout expansion */
}

@media (max-width: 991.98px) {
    .main-content {
        margin-left: 0;
        padding: 20px;
        border-radius: 0;
        box-shadow: none;
    }
}

h3 {
    text-align: center;
    margin-bottom: 20px;
}

table {
    width: 100%;
    border-collapse: collapse;
    margin-bottom: 20px;
    table-layout: fixed; /* prevent auto-expansion */
    word-wrap: break-word;
    page-break-inside: auto;
}

table, th, td {
    border: 1px solid #000;
}

th, td {
    padding: 6px;
    vertical-align: top;
    text-align: left;
}

th {
    background-color: #ffff0070;
}

.form-control {
    padding: 2px 4px;
    margin-bottom: 0;
    font-size: 11px;
    width: 100%;
    box-sizing: border-box;
}

.footer-declaration {
    margin-top: 15px;
}





/* Print settings */
@page {
    size: A4;
    margin: 10px;
}

@media print {
    body {
        margin: 0;
        padding: 0;
    }

    * {
        -webkit-print-color-adjust: exact;
        print-color-adjust: exact;
    }

    body * {
        visibility: hidden;
    }

    .main-content,
    .main-content * {
        visibility: visible;
    }

    .main-content {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
        margin-top: 0;
    }

    #footer {
        position: fixed;
        bottom: 0;
        left: 0;
        width: 100%;
    }

    #printBtn,
    #footerbtn,
    #checkfooter {
        display: none !important;
    }
}
</style>

</head>
<body>
<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>

<div class="main-content">

<div class="d-flex justify-content-end mb-3">
    <button class="btn btn-primary w-25" id="printBtn" onclick="window.print()">Print</button>
</div>
<?php if (!empty($success_message)): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?= htmlspecialchars($success_message) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<table  style="width:100%; border: none; margin-bottom: 20px;">
    <tr style="background-color: #03b8ed; color: #fff;">
        <td style="text-align:center; font-size: 1.5rem; padding: 12px;">SAFETY AUDIT FORM</td>
    </tr>
</table>

<table>
    <tbody>
        <tr>
            <td class="label-cell">1</td>
            <th style="width:45%"> Name of Factory</th>
            <td class="label-cell">:</td>
            <td><?= htmlspecialchars($form['company_name']) ?></td>
        </tr>
        <tr>
            <td class="label-cell">2</td>
            <th>Address of Factory</th>
            <td class="label-cell">:</td>
            <td><?= htmlspecialchars($form['factory_address'] ?: $form['company_address']) ?></td>
        </tr>
        <tr>
            <td class="label-cell">3</td>
            <th> Permanent Serial Number (PSN)</th>
            <td class="label-cell">:</td>
            <td><?= htmlspecialchars($form['psn']) ?></td>
        </tr>
        <tr>
            <td class="label-cell">4</td>
            <th>Type of Factory</th>
            <td class="label-cell">:</td>
            <td><?= htmlspecialchars($form['factory_type']) ?></td>
        </tr>
        <tr>
            <td class="label-cell">5</td>
            <th> Number of Workers</th>
            <td class="label-cell">:</td>
            <td><?= htmlspecialchars($form['workers_count']) ?></td>
        </tr>
        <tr>
            <td class="label-cell">6</td>
            <th> Factory Email</th>
            <td class="label-cell">:</td>
            <td><?= htmlspecialchars($form['factory_email']) ?></td>
        </tr>
        <tr>
            <td class="label-cell">7</td>
            <th>District</th>
            <td class="label-cell">:</td>
            <td><?= htmlspecialchars($form['district']) ?></td>
        </tr>
        <tr>
            <td class="label-cell">8</td>
            <th>Taluka</th>
            <td class="label-cell">:</td>
            <td><?= htmlspecialchars($form['taluka']) ?></td>
        </tr>
        <tr>
            <td class="label-cell">9</td>
            <th>Pincode</th>
            <td class="label-cell">:</td>
            <td><?= htmlspecialchars($form['pincode']) ?></td>
        </tr>
        <tr>
            <td class="label-cell">10</td>
            <th> Name of Occupier</th>
            <td class="label-cell">:</td>
            <td><?= htmlspecialchars($form['occupier_name']) ?></td>
        </tr>
        <tr>
            <td class="label-cell">11</td>
            <th>Occupier Mobile</th>
            <td class="label-cell">:</td>
            <td><?= htmlspecialchars($form['occupier_mobile']) ?></td>
        </tr>
        <tr>
            <td class="label-cell">12</td>
            <th>Factory Manager Name</th>
            <td class="label-cell">:</td>
            <td><?= htmlspecialchars($form['manager_name']) ?></td>
        </tr>
        <tr>
            <td class="label-cell">13</td>
            <th>Factory Manager Mobile</th>
            <td class="label-cell">:</td>
            <td><?= htmlspecialchars($form['manager_mobile']) ?></td>
        </tr>
    </tbody>
</table>


<div class="footer-declaration" >  
    <p>
        I/We hereby certify that on <b><?= !empty($reminder_date) ? date('d-m-Y', strtotime($reminder_date)) : '' ?></b>,
        I/We thoroughly examined the above mentioned factory for Safety Audit 
        and the details of examination/tests carried out are enclosed herewith.<br>
        The above is a correct report of the result.
    </p>

    <p><strong>Signature of Competent Person:</strong></p><br>
  <table>
        <tbody>
            <tr>
                <td class="label-cell">1</td>
                <th style="width: 45%;">Name of Competent Person</th>
                <td class="label-cell">:</td>
                <td><?= htmlspecialchars($form['competent_name'] ?? '') ?></td>
            </tr>
            <tr>
                <td class="label-cell">2</td>
                <th>Qualification</th>
                <td class="label-cell">:</td>
                <td><?= htmlspecialchars($form['competent_qualification'] ?? '') ?></td>
            </tr>
            <tr>
                <td class="label-cell">3</td>
                <th>Address</th>
                <td class="label-cell">:</td>
                <td><?= nl2br(htmlspecialchars($form['competent_address'] ?? '')) ?></td>
            </tr>
            <tr>
                <td class="label-cell">4</td>
                <th>Date</th>
                <td class="label-cell">:</td>
                <td><?= !empty($reminder_date) ? date('d-m-Y', strtotime($reminder_date)) : '' ?></td>
            </tr>
            <tr>
                <td class="label-cell">5</td>
                <th>Next Due Date</th>
                <td class="label-cell">:</td>
                <td><?= !empty($expiry_date) ? date('d-m-Y', strtotime($expiry_date)) : '' ?></td>
            </tr>
        </tbody>
    </table>


     
</div>
<table id="footer" style="width:100%; border: none; margin-top: 20px;">
    <tr style="background-color: #03b8ed; color: #fff;">
        <td style="text-align:center; font-size: 14px; padding: 10px;">
            Safety Audit Form<br>
            
        </td>
    </tr>
</table>
</div>


<script src="/js/script.js"></script>
</body>
</html>
<?php ob_end_flush(); ?>
