<?php
ob_start();
session_start();
require_once "config/db.php";

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

$companies = $conn->query("SELECT id, name, address FROM companies");
$success_message = '';
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Collect inputs
    $company_id = !empty($_POST['company_id']) ? (int)$_POST['company_id'] : null;
    $factory_address = trim($_POST['factory_address'] ?? '');
    $psn = trim($_POST['psn'] ?? '');
    $factory_type = trim($_POST['factory_type'] ?? '');

    $workers_count = trim($_POST['workers_count'] ?? '');
    $factory_email = trim($_POST['factory_email'] ?? '');
    $district = trim($_POST['district'] ?? '');
    $taluka = trim($_POST['taluka'] ?? '');
    $pincode = trim($_POST['pincode'] ?? '');
    $occupier_name = trim($_POST['occupier_name'] ?? '');
    $occupier_mobile = trim($_POST['occupier_mobile'] ?? '');
    $manager_name = trim($_POST['manager_name'] ?? '');
    $manager_mobile = trim($_POST['manager_mobile'] ?? '');
    $competent_name = trim($_POST['competent_name'] ?? '');
  $competent_qualification = trim($_POST['competent_qualification'] ?? '');
  $competent_address = trim($_POST['competent_address'] ?? '');


    //  Check if PSN already exists
    $check_sql = "SELECT id FROM safety_audit_forms WHERE psn = ?";
    $check_stmt = $conn->prepare($check_sql);
    $check_stmt->bind_param("s", $psn);
    $check_stmt->execute();
    $check_stmt->store_result();

    if ($check_stmt->num_rows > 0) {
        $error_message = "Error: This PSN number already exists!";
    } else {
        // SQL insert
        $sql = "INSERT INTO safety_audit_forms (
            company_id, factory_address, psn, factory_type,
            workers_count, factory_email,
            district, taluka, pincode,
            occupier_name, occupier_mobile, manager_name,
            manager_mobile, competent_name, competent_qualification, competent_address
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?)";

        $stmt = $conn->prepare($sql);
        if (!$stmt) {
            die("Prepare failed: " . $conn->error);
        }

        // Bind parameters (13 placeholders → 1 int + 12 strings)
        $stmt->bind_param(
            "isssssssssssssss",
            $company_id,
            $factory_address,
            $psn,
            $factory_type,
            $workers_count,
            $factory_email,
            $district,
            $taluka,
            $pincode,
            $occupier_name,
            $occupier_mobile,
            $manager_name,
            $manager_mobile,
            $competent_name,
            $competent_qualification,
            $competent_address
        );

        if ($stmt->execute()) {
            // Insert reminder if date is selected
            $reminder_date = !empty($_POST['reminder_date']) ? $_POST['reminder_date'] : null;

            if ($reminder_date && $company_id) {
                // category and subcategory names
                $category_name = 'DISH';
                $subcategory_name = 'Safety Audit';

                // Validity: 24 months
                $validity_months = 24;

                // Calculate expiry date
                $expiry_date = date('Y-m-d', strtotime("+$validity_months months", strtotime($reminder_date)));

                // Insert into company_reminders
                $reminder_sql = "INSERT INTO company_reminders 
                    (company_id, category_name, subcategory_name, reminder_date, expiry_date, status, created_at) 
                    VALUES (?, ?, ?, ?, ?, 'pending', NOW())";

                $reminder_stmt = $conn->prepare($reminder_sql);
                $reminder_stmt->bind_param("issss", $company_id, $category_name, $subcategory_name, $reminder_date, $expiry_date);

                if (!$reminder_stmt->execute()) {
                    die("Reminder insert failed: " . $reminder_stmt->error);
                }
                $reminder_stmt->close();
            }

            $_SESSION['success_message'] = "Safety Audit form submitted successfully!";
            header("Location: " . $_SERVER['PHP_SELF']);
            exit;
        } else {
            $error_message = "Error: " . $stmt->error;
        }

        $stmt->close();
    }

    $check_stmt->close();
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Axle_Services</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
<link rel="stylesheet" href="css/style.css" />
<link rel="stylesheet" href="css/header.css" />
<link rel="stylesheet" href="css/sidebar.css" />
<style>
  body {
    background: #f9fafb;
    
    color: #333;
    min-height: 100vh;
  }

  .main-content {
    margin-top: 70px;
    margin-left: 250px;
    padding: 30px 40px;
    transition: all 0.3s ease;
    min-height: calc(100vh - 70px);
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 8px 24px rgb(0 0 0 / 0.05);
  }

  @media (max-width: 991.98px) {
    .main-content {
      margin-left: 0;
      padding: 20px;
      border-radius: 0;
      box-shadow: none;
    }
  }

  .page-header {
    background-color: #0d6efd;
    color: #fff;
    padding: 20px 25px;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgb(13 110 253 / 0.3);
    margin-bottom: 30px;
    text-align: center;
    font-weight: 600;
    font-size: 1.8rem;
    letter-spacing: 0.03em;
  }

  form {
    max-width: 900px;
    margin: 0 auto;
  }

  label.form-label {
    font-weight: 600;
    color: #495057;
  }

  input.form-control,
  select.form-select,
  textarea.form-control {
    border-radius: 8px;
    border: 1.5px solid #ced4da;
    padding: 10px 14px;
    font-size: 1rem;
    transition: border-color 0.3s ease, box-shadow 0.3s ease;
  }

  input.form-control:focus,
  select.form-select:focus,
  textarea.form-control:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 8px rgb(13 110 253 / 0.25);
    outline: none;
  }

  textarea.form-control {
    min-height: 80px;
    resize: vertical;
  }

  h6 {
    font-weight: 400;
    color: #0d6efd;
    margin-top: 40px;
    margin-bottom: 20px;
    border-bottom: 2px solid #0d6efd;
    padding-bottom: 6px;
  }

  .btn-success {
    background-color: #198754;
    border-color: #198754;
    font-weight: 600;
    font-size: 1.1rem;
    padding: 12px 40px;
    border-radius: 50px;
    transition: background-color 0.3s ease, box-shadow 0.3s ease;
  }

  .btn-success:hover {
    background-color: #157347;
    box-shadow: 0 6px 15px rgb(21 115 71 / 0.4);
  }

  .alert {
    max-width: 900px;
    margin: 0 auto 30px auto;
    border-radius: 10px;
    font-weight: 600;
    font-size: 1rem;
  }

  @media (max-width: 575.98px) {
    form .col-md-6,
    form .col-md-4,
    form .col-12 {
      flex: 0 0 100% !important;
      max-width: 100% !important;
    }
  }
</style>
</head>
<body>
<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>

<div class="main-content">
  <div class="page-header">Safety Audit Form</div>

  <?php if ($error_message): ?>
    <div class="alert alert-danger shadow-sm"><?= htmlspecialchars($error_message) ?></div>
  <?php endif; ?>
  <?php if (isset($_SESSION['success_message'])): ?>
    <div class="alert alert-success shadow-sm"><?= htmlspecialchars($_SESSION['success_message']) ?></div>
    <?php unset($_SESSION['success_message']); ?>
  <?php endif; ?>

  <form method="POST" class="row g-4" novalidate>
    <!-- Company -->
   <div class="row align-items-center mb-3 mt-3">
  <div class="col-md-4">
    <label class="form-label" for="companySelect">1. Name of factory</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="company_name" id="companySearch" placeholder="Type company name..." autocomplete="off">
    <input type="hidden" name="company_id" id="companyId">
    <div id="companyList" class="list-group position-absolute bg-light" style="z-index:1000;"></div>
  </div>
</div>


    <!-- Factory Address -->
    <div class="row align-items-center mb-3">
      <div class="col-md-4">
        <label class="form-label" for="factoryAddress">2. Address of factory</label>
      </div>
      <div class="col-md-8">
        <input type="text" class="form-control" name="factory_address" id="factoryAddress" readonly />
      </div>
    </div>

    <div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="psn">Permanent Serial Number (PSN) of Factory (To be obtained from Factory)</label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="psn" id="psn" />
  </div>
</div>

 <!-- factory type -->
<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="factorytype">Type Of Factory</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="factory_type" id="factorytype" />
  </div>
</div>
    <!-- Workers Count -->
<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="workersCount">Number of Workers</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="workers_count" id="workersCount" />
  </div>
</div>

<!-- Factory Email -->
<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="factoryEmail">Factory Email</label>
  </div>
  <div class="col-md-8">
    <input type="email" class="form-control" name="factory_email" id="factoryEmail" placeholder="factory@example.com" />
  </div>
</div>

<!-- District -->
<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="district">District</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="district" id="district" />
  </div>
</div>

<!-- Taluka -->
<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="taluka">Taluka / Sub-location</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="taluka" id="taluka" />
  </div>
</div>

<!-- Pincode -->
<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="pincode">Pincode</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="pincode" id="pincode" maxlength="10" />
  </div>
</div>

<!-- Occupier Name -->
<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="occupierName">Name of Occupier</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="occupier_name" id="occupierName" />
  </div>
</div>

<!-- Occupier Mobile -->
<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="occupierMobile">Occupier Mobile No.</label>
  </div>
  <div class="col-md-8">
    <input type="number" class="form-control" name="occupier_mobile" id="occupierMobile" maxlength="20" />
  </div>
</div>

<!-- Factory Manager Name -->
<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="managerName">Factory Manager Name</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="manager_name" id="managerName" />
  </div>
</div>

<!-- Factory Manager Mobile -->
<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="managerMobile">Factory Manager Mobile No.</label>
  </div>
  <div class="col-md-8">
    <input type="number" class="form-control" name="manager_mobile" id="managerMobile" maxlength="20" />
  </div>
</div>
<div class="col-12 mt-4">
  <h6> Add Footer(Competent Person Details) </h6>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="competent_name">Name of Competent Person</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="competent_name" id="competent_name" placeholder="Enter competent person name">
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="competent_qualification">Qualification of Competent Person</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="competent_qualification" id="competent_qualification" placeholder="Enter qualification">
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="competent_address">Address of Competent Person</label>
  </div>
  <div class="col-md-8">
    <textarea class="form-control" name="competent_address" id="competent_address" placeholder="Enter address"></textarea>
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="reminderDate">9. Reminder Date</label>
  </div>
  <div class="col-md-4">
    <input type="date" class="form-control" name="reminder_date" id="reminderDate" />
  </div>
</div>

    <!-- Submit -->
    <div class="col-12 text-center mt-4">
      <button type="submit" class="btn btn-success px-5">Submit Form</button>
    </div>
  </form>
</div>
<script src="/js/script.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php ob_end_flush(); ?>