<?php 
ob_start();
session_start();
require_once "config/db.php";

if(!isset($_SESSION['admin'])){
    header("Location: login.php");
    exit;
}

// Handle delete request
if(isset($_GET['delete'])){
    $id = intval($_GET['delete']);
    $conn->query("DELETE FROM company_reminders WHERE id = $id");
    header("Location: reminder_list.php?msg=deleted");
    exit;
}

// Filters
$searchCompany = isset($_GET['company']) ? trim($_GET['company']) : "";
$searchDate = isset($_GET['date']) ? trim($_GET['date']) : "";

// Base query
$query = "
    SELECT r.*, 
           c.name AS company_name, 
           r.category_name AS category_name, 
           r.subcategory_name AS subcategory_name
    FROM company_reminders r
    JOIN companies c ON r.company_id = c.id
";

// Add filters
$conditions = [];

if ($searchCompany != "") {
    $safeCompany = $conn->real_escape_string($searchCompany);
    $conditions[] = "c.name = '$safeCompany'";
}

if ($searchDate != "") {
    $safeDate = $conn->real_escape_string($searchDate);
    $conditions[] = "DATE(r.expiry_date) = '$safeDate'";
}

if (!empty($conditions)) {
    $query .= " WHERE " . implode(" AND ", $conditions);
}

$query .= " ORDER BY r.id DESC";
$result = $conn->query($query);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Axle_Services</title>

<!-- Bootstrap CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap">

<!-- Custom Styles -->
<link rel="stylesheet" href="css/header.css">
<link rel="stylesheet" href="css/sidebar.css">

<style>
body { background: #f8f9fa; font-family: 'Poppins', sans-serif; }
.page-header {
    background-color: #3182ce;
    color: #fff;
    padding: 15px;
    text-align: center;
    margin-bottom: 20px;
    border-radius: 8px;
    text-transform: uppercase;
}
.table-container {
    background: #fff;
    padding: 15px;
    border-radius: 10px;
    box-shadow: 0 6px 15px rgba(0,0,0,0.1);
    overflow-x: auto;
}
.main-content {
    margin-top: 70px;
    margin-left: 250px;
    padding: 20px;
    transition: all 0.3s ease;
}
.table td, .table th { white-space: nowrap; vertical-align: middle; }
.due-soon { background-color: #f8d7da !important; }
#calendar { cursor: pointer; }
@media (max-width: 768px) { .main-content { margin-left: 0; } }
</style>
</head>
<body>

<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>

<div class="main-content">
    <div class="page-header"><h1>Services List</h1></div>

    <!-- 🔹 Filters -->
    <div class="row mb-3">
        <div class="col-md-6 position-relative">
            <label for="companySearch" class="form-label fw-bold">Search Company</label>
            <input type="text" id="companySearch" class="form-control" placeholder="Type company name...">
            <div id="companySuggestions" class="list-group position-absolute w-50"></div>
        </div>

        <div class="col-md-4">
            <form method="get" id="filterForm">
                <label for="calendar" class="form-label fw-bold">Select Expiry Date</label>
                <input type="date" id="calendar" name="date" class="form-control"
                       value="<?= isset($_GET['date']) ? htmlspecialchars($_GET['date']) : '' ?>"
                       onchange="document.getElementById('filterForm').submit();">
            </form>
        </div>
    </div>

    <div class="table-container">
        <?php if(isset($_GET['msg']) && $_GET['msg']=='deleted'): ?>
            <div class="alert alert-success">Reminder deleted successfully!</div>
        <?php endif; ?>

        <?php if($result->num_rows > 0): ?>
            <div class="mb-3 fw-bold text-end text-primary">
                Total Reminders: <?= $result->num_rows; ?>
            </div>

            <table class="table table-bordered table-striped table-hover align-middle">
                <thead class="table-primary">
                    <tr>
                        <th>Sr. No</th>
                        <th>Company Name</th>
                        <th>Category</th>
                        <th>Subcategory</th>
                        <th>Expiry Date</th>
                        <th>Snooze Until</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $sr=1; while($row = $result->fetch_assoc()): ?>
                        <?php
                        // Highlight if reminder is within 7 days of expiry
                        $highlight = false;
                        if(isset($row['expiry_date'])){
                            $expiry = strtotime($row['expiry_date']);
                            $today = strtotime(date('Y-m-d'));
                            $diff = ($expiry - $today)/(60*60*24);
                            if($diff <= 7 && $diff >= 0){
                                $highlight = true;
                            }
                        }
                        ?>
                        <tr class="<?= $highlight ? 'due-soon' : ''; ?>">
                            <td><?= $sr++; ?></td>
                            <td><?= htmlspecialchars($row['company_name']); ?></td>
                            <td><?= htmlspecialchars($row['category_name']); ?></td>
                            <td><?= htmlspecialchars($row['subcategory_name']); ?></td>
                            <td><?= htmlspecialchars($row['expiry_date'] ?? '-'); ?></td>
                            <td><?= $row['snooze_until'] ? htmlspecialchars($row['snooze_until']) : '-'; ?></td>
                            <td>
                                <a href="reminder_list.php?delete=<?= $row['id']; ?>" 
                                   class="btn btn-sm btn-danger" 
                                   onclick="return confirm('Delete this reminder?');">Delete</a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="alert alert-info text-center">No reminders found</div>
        <?php endif; ?>
    </div>
</div>

<!-- JS -->
<script src="/js/script.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.addEventListener("DOMContentLoaded", function(){
    const searchBox = document.getElementById("companySearch");
    const suggestionBox = document.getElementById("companySuggestions");

    searchBox.addEventListener("input", function(){
        let query = this.value.trim();
        if(query.length < 1){
            suggestionBox.innerHTML = "";
            return;
        }

        fetch("search_company.php?term=" + encodeURIComponent(query))
            .then(res => res.json())
            .then(data => {
                suggestionBox.innerHTML = "";
                if(data.length > 0){
                    data.forEach(name => {
                        let item = document.createElement("button");
                        item.classList.add("list-group-item", "list-group-item-action");
                        item.textContent = name;
                        item.onclick = function(){
                            window.location.href = "reminder_list.php?company=" + encodeURIComponent(name);
                        };
                        suggestionBox.appendChild(item);
                    });
                }
            });
    });
});
</script>

</body>
</html>
<?php ob_end_flush(); ?>
