<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
require_once "config/db.php";

// Check admin login
if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

// Get parameters safely
$id     = isset($_GET['id']) ? intval($_GET['id']) : 0;
$action = isset($_GET['action']) ? $_GET['action'] : '';
$days   = isset($_GET['days']) ? intval($_GET['days']) : 0;

// Fetch reminder subcategory
$sql = "SELECT subcategory_name FROM company_reminders WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();
$stmt->bind_result($subcategory_name);
$stmt->fetch();
$stmt->close();

if (!$subcategory_name) {
    header("Location: dashboard.php");
    exit;
}

$subcategory = strtolower($subcategory_name);

// Handle actions
if ($action === 'done') {
    $expiry_date = null;

    // Special rule for Form 11
    if ($subcategory === 'form 11') {
        $expiry_date = date('Y') . "-12-31";
    }

    if ($expiry_date) {
        $sql = "UPDATE company_reminders 
                   SET status='done', expiry_date=? 
                 WHERE id=?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("si", $expiry_date, $id);
    } else {
        $sql = "UPDATE company_reminders 
                   SET status='done' 
                 WHERE id=?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $id);
    }

    $stmt->execute();
    $stmt->close();

} elseif ($action === 'snooze' && $days > 0) {
    $sql = "UPDATE company_reminders 
               SET snooze_until = DATE_ADD(CURDATE(), INTERVAL ? DAY) 
             WHERE id=?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $days, $id);
    $stmt->execute();
    $stmt->close();
}

// Redirect back to dashboard
header("Location: dashboard.php");
exit;
