

document.addEventListener("DOMContentLoaded", function() {
    const toggleButton = document.querySelector(".menu-toggle");
    const sidebar = document.querySelector(".sidebar");

    // Sidebar toggle for mobile
    toggleButton.addEventListener("click", function() {
        sidebar.classList.toggle("active");
    });

    // Submenu toggle
    const submenuToggles = document.querySelectorAll('.submenu-toggle');
    submenuToggles.forEach(toggle => {
        toggle.addEventListener('click', function() {
            this.classList.toggle('active');
            const submenu = document.querySelector(this.getAttribute('href'));
            if(submenu.style.display === "flex") {
                submenu.style.display = "none";
            } else {
                submenu.style.display = "flex";
            }
        });
    });
});

//for company list show

document.getElementById("companySearch").addEventListener("keyup", function() {
  let query = this.value;
  if (query.length < 1) {
    document.getElementById("companyList").innerHTML = "";
    return;
  }
  fetch("get_companies.php?query=" + encodeURIComponent(query))
    .then(response => response.json())
    .then(data => {
      let list = "";
      data.forEach(company => {
        list += `<button type="button" class="list-group-item list-group-item-action company-option"
                          data-id="${company.id}" data-name="${company.name}" data-address="${company.address}">
                    ${company.name}
                 </button>`;
      });
      document.getElementById("companyList").innerHTML = list;
      document.querySelectorAll(".company-option").forEach(btn => {
        btn.addEventListener("click", function() {
          selectCompany(this.dataset.id, this.dataset.name, this.dataset.address);
        });
      });
    });
});

function selectCompany(id, name, address) {
  document.getElementById("companySearch").value = name;
  document.getElementById("companyId").value = id;
  document.getElementById("factoryAddress").value = address;
  document.getElementById("companyList").innerHTML = "";
}


