<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

ob_start();
session_start();

if (isset($_SESSION['success_message'])) {
    $success_message = $_SESSION['success_message'];
    unset($_SESSION['success_message']);
}
require_once "config/db.php";

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

if (!isset($_GET['id'])) {
    die("Form ID not provided.");
}

$form_id = intval($_GET['id']);

function safe_date($dateStr)
{
    return (!empty($dateStr) && strtotime($dateStr) !== false)
        ? date('d-m-Y', strtotime($dateStr))
        : '';
}


// Fetch form data
$sql = "SELECT f.*, c.name AS company_name, c.address AS company_address 
        FROM form13 f 
        LEFT JOIN companies c ON f.company_id = c.id
        WHERE f.id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $form_id);
$stmt->execute();

// ---- safe fetch without get_result() ----
$meta = $stmt->result_metadata();
$fields = [];
$row = [];
while ($field = $meta->fetch_field()) {
    $fields[] = &$row[$field->name];
}
call_user_func_array([$stmt, 'bind_result'], $fields);

$form = null;
if ($stmt->fetch()) {
    foreach ($row as $key => $val) {
        $form[$key] = $val;
    }
}
$stmt->close();

if (!$form) {
    die("Form not found.");
}

// Fetch reminder
$reminder_sql = "SELECT reminder_date, expiry_date 
                 FROM company_reminders 
                 WHERE company_id = ? AND subcategory_name = 'Form 13' 
                 ORDER BY id DESC 
                 LIMIT 1";
$reminder_stmt = $conn->prepare($reminder_sql);
$reminder_stmt->bind_param("i", $form['company_id']);
$reminder_stmt->execute();

// ---- safe fetch without get_result() ----
$meta2 = $reminder_stmt->result_metadata();
$fields2 = [];
$row2 = [];
while ($field2 = $meta2->fetch_field()) {
    $fields2[] = &$row2[$field2->name];
}
call_user_func_array([$reminder_stmt, 'bind_result'], $fields2);

$reminder = null;
if ($reminder_stmt->fetch()) {
    foreach ($row2 as $key => $val) {
        $reminder[$key] = $val;
    }
}
$reminder_stmt->close();

// Defaults
$reminder_date = $reminder['reminder_date'] ?? '';
$expiry_date   = $reminder['expiry_date'] ?? '';
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Axle_Services</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <link rel="stylesheet" href="css/style.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            color: #000;
            background: #fff;

        }

        .main-content {
            margin-top: 70px;
            margin-left: 250px;
            padding: 30px 40px;
            transition: all 0.3s ease;
            min-height: calc(100vh - 70px);
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 8px 24px rgb(0 0 0 / 0.05);
            font-size: 11px;
        }

        p {
            font-size: 11.5px;
        }

        @media (max-width: 991.98px) {
            .main-content {
                margin-left: 0;
                padding: 20px;
                border-radius: 0;
                box-shadow: none;
            }
        }

        h3 {
            text-align: center;
            margin-bottom: 20px;
            background-color: orange;
            padding: 10px;
            color: #fff;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            page-break-inside: auto;
        }

        table,
        th,
        td {
            border: 1px solid #000;
        }

        th {
            background-color: #ffff0070;
        }

        th,
        td {
            padding: 2px;
            vertical-align: top;
            text-align: left;
        }

        .footer-declaration {
            margin-top: 20px;
        }

        .form-control {
            padding: 0px;
            margin-bottom: 0px;
            font-size: 11px;
        }

        @page {
            size: A4;
            margin: 5px;
        }

      @media print {
    /* --- Reset margins and padding for print --- */
    body {
        margin: 0;
        padding: 0;
    }

    /* --- Ensure all table colors and borders print correctly --- */
    th, td {
        -webkit-print-color-adjust: exact;
        print-color-adjust: exact;
    }

    /* --- Page break handling --- */
    .page-break-after {
        page-break-after: always;
    }

    /* --- Make only printable area visible --- */
    body * {
        visibility: hidden;
    }

    /* --- Footer fixed at bottom of every printed page --- */
    #form13footer {
        position: fixed;
        bottom: 0;
        left: 0;
        width: 100%;
    }

    /* --- Allow main content and its children to be printed --- */
    .main-content,
    .main-content * {
        visibility: visible;
    }

    /* --- Layout fixes for print --- */
    .main-content {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
        margin-top: 0;
    }

    /* --- Footer declaration margin reset (if you use it) --- */
    .footer-declaration {
        margin-top: 0;
    }

    .form13-second-header-wrapper {
        display: block;
        margin-top: 10mm !important; 
    }

    #printBtn,
    #footerbtn,
    #checkfooter {
        display: none !important;
    }
}

    </style>
</head>

<body>
    <?php include 'header.php'; ?>
    <?php include 'sidebar.php'; ?>

    <div class="main-content">

        <div class="d-flex justify-content-end mb-3">
            <button class="btn btn-primary w-25" id="printBtn" onclick="window.print()">Print</button>
        </div>
        <?php if (!empty($success_message)): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?= htmlspecialchars($success_message) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>
        <table style="width:100%; border:none; margin-bottom:10px;">
            <tr style="background-color:#03b8ed; color: #fff;">
                <td colspan="4" style="text-align:center; font-size:12px; padding:5px;">
                    <strong>FORM 13</strong><br>
                    <span style="font-weight: normal; font-size: 12px;">
                        (See Rules 65 and 73A)
                    </span><br>
                    <span style="font-weight: normal; font-size: 12px;">
                        REPORT OF EXAMINATION OF PRESSURE PLANT/VESSEL/GAS HOLDER
                    </span>
                </td>
            </tr>
        </table>

        <table>
            <tbody>
                <tr>
                    <td class="label-cell">1.</td>
                    <th style="width: 45%;">Name & Address of the Factory</th>
                    <td class="label-cell">:</td>
                    <td>
                        <?php
                        if (!empty($form['company_name'])) {
                            echo '<strong>' . htmlspecialchars($form['company_name']) . '</strong>';
                            echo '<hr style="margin:5px 0;">'; // separator line
                        }

                        echo nl2br(htmlspecialchars($form['factory_address'] ?: $form['company_address']));
                        ?>
                    </td>
                </tr>
                <tr>
                    <td class="label-cell"></td>
                    <th>Name of Equipment</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['equipment_name']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">2.</td>
                    <th>2.Name, description and distinctive number of the pressure plant/vessel</th>
                    <td class="label-cell">:</td>
                    <td><?= nl2br(htmlspecialchars($form['pressure_plant_name'])) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">3.</td>
                    <th>Name and address of maker</th>
                    <td class="label-cell">:</td>
                    <td><?= nl2br(htmlspecialchars($form['maker_name'])) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">4.</td>
                    <th>Nature of process in which it is used</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['nature_of_process']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">5.</td>
                    <th> Particulars of plant/Vessel</th>
                    <td class="label-cell">:</td>
                </tr>
                <tr>
                    <td class="label-cell">5.a)</td>
                    <th>Date of Construction</th>
                    <td class="label-cell">:</td>
                    <td><?= safe_date($form['date_of_construction']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">5.b)</td>
                    <th>Thickness of Walls</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['thickness_of_wall']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">5.c)</td>
                    <th>Date on which it was first taken into use</th>
                    <td class="label-cell">:</td>
                    <td><?= safe_date($form['date_first_use']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">5.d)</td>
                    <th>Safe working pressure recommended by maker</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['safe_working_pressure']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">5.A)</td>
                    <th>Particulars of Plant/Vessel/Gas holder</th>
                    <td class="label-cell">:</td>
                </tr>
                <tr>
                    <td class="label-cell">a)</td>
                    <th>Parts of the gas-holders examined by electronics or other accurate devices or by cutting sample discs and results thereof</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['part_of_gas_holdes']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">b)</td>
                    <th>Particulars of Plant/Vessel/Gas holder</th>
                    <td class="label-cell">:</td>
                </tr>
                <tr>
                    <td class="label-cell">i)</td>
                    <th>Crown</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['crown']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">ii)</td>
                    <th>Side sheeting including grips and cups</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['side_sheeting']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">iii)</td>
                    <th>Guiding mechanism (roler carriages, roller, pins, guide, ropes, etc.)</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['guiding_mechanism']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">iv)</td>
                    <th>Tank</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['tank']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">v)</td>
                    <th>Other structure, if any, columns (faming and braking).</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['other_structure']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">c)</td>
                    <th>Particulars as to the position of the lift at the time of examination.</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['lift_position']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">d)</td>
                    <th> Particulars as to whether the tank and lifts were found sufficiently level for safe working.</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['tank_lift_perticulars']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">6.</td>
                    <th>Date of</th>
                    <td class="label-cell">:</td>
                </tr>
                <tr>
                    <td class="label-cell">i)</td>
                    <th>Last external examination</th>
                    <td class="label-cell">:</td>
                    <td><?= safe_date($form['date_of_external_exam']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">ii)</td>
                    <th>Last internal examination</th>
                    <td class="label-cell">:</td>
                    <td><?= safe_date($form['date_of_internal_exam']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">iii)</td>
                    <th>Last hydraulic examination</th>
                    <td class="label-cell">:</td>
                    <td><?= safe_date($form['date_of_hydraulic_exam']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">iv)</td>
                    <th>Last ultrasonic test</th>
                    <td class="label-cell">:</td>
                    <td><?= safe_date($form['ultrasonic_test_date']) ?></td>
                </tr>

                <tr>
                    <td class="label-cell">6.(A)</td>
                    <th>By whom it is carried out?</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['by_whom']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">7.</td>
                    <th>Whether lagging was removed for purposes of examination</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['removed_login']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">8.</td>
                    <th>Description of examinations carried out and finding.</th>
                    <td class="label-cell">:</td>
                </tr>
                <tr>
                    <td class="label-cell">i)</td>
                    <th>External examination (give reasons if it is not carried out six monthly)</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['external_examination']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">ii)</td>
                    <th>Internal examination (give reason if it is not carried out annually)</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['internal_examination']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">iii)</td>
                    <th>iii) Hydraulic test (Give reason if this is not carried out at interval of 2 years or 4 years)</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['hydraulic_test']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">iv)</td>
                    <th>Ultrasonic test (please quote number and date of the certificate issued by Chief Inspector permitting ultrasonic test in lieu of internal examination and hydraulic test ).</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['altrasonic_test']) ?></td>
                </tr>
                <tr class="page-break-after"></tr>
            </tbody>
        </table>
        <table id="form13footer" style="width:100%; border: none; margin-bottom:0px;">
            <tr style="background-color: #03b8ed; color: #fff;">
                <td style="text-align:center; font-size: 14px; padding: 5px;">
                    FORM-13<br>

                </td>
            </tr>
        </table>



        <div class="form13-second-header-wrapper">
        <table id="form13header" style="width:100%; border:none; margin-top:5px;">
            <tr style="background-color: #03b8ed; color: #fff;">
                <td colspan="4" style="text-align:center; font-size:12px; padding:5px;">
                    <strong>FORM 13</strong><br>
                    <span style="font-weight: normal; font-size: 12px;">
                        (See Rules 65 and 73A)
                    </span><br>
                    <span style="font-weight: normal; font-size: 12px;">
                        REPORT OF EXAMINATION OF PRESSURE PLANT/VESSEL/GAS HOLDER
                    </span>
                </td>
            </tr>
        </table>
        </div>
        <table>
            <tbody>
                <tr>
                    <td class="label-cell">9.</td>
                    <th style="width: 45%;">Safe working pressure calculated as per methods given in the rule 5 (c)(ii) for sizing Cylinder.</th>
                    <td class="label-cell">:</td>
                </tr>
                <tr>
                    <td class="label-cell">1.</td>
                    <th>Safe Working Pressure Calculations 1</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['safe_working_pressure1']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">2.</td>
                    <th>Safe Working Pressure Calculations 2</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['safe_working_pressure2']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">3.</td>
                    <th>Safe Working Pressure Calculations 3</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['safe_working_pressure3']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">10.</td>
                    <th>Conditions of pressure plant.</th>
                    <td class="label-cell">:</td>
                </tr>
                <tr>
                    <td class="label-cell">a).</td>
                    <th>Vessel</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['vessel']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">b)</td>
                    <th>Piping</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['piping']) ?></td>
                </tr>
                <div class="page-break"></div>
                <tr>
                    <td class="label-cell">11.</td>
                    <th>Condition of fitting and appliances</th>
                    <td class="label-cell">:</td>
                </tr>
                <tr>
                    <td class="label-cell">i)</td>
                    <th>Pressure Gauges</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['pressure_gauges']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">ii)</td>
                    <th>Safety Valve</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['safety_valve']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">iii)</td>
                    <th>Stop Valve</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['stop_valve']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">iv)</td>
                    <th>Reducing valve (give reason if not necessary)</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['reducing_valve']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">v)</td>
                    <th>Additional safety valve (required in case reducing valve is necessary)</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['additional_safety_valve']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">vi)</td>
                    <th>Other devices (please specify particularly in case of jacketed vessels)</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['other_devices']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">viii)</td>
                    <th>Are all fittings and applications properly maintained and in good condition, repairs if any required and period within which they should be executed.</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['maintenance_status']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">12.</td>
                    <th>Safe working pressure recommended after examination (specify the allowances made for conditions of working such as heat, corrosion etc.)</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['working_pressure_after_examination']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">13.</td>
                    <th>Specify repairs if any and period within which they should be executed.</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['repairs']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">14.</td>
                    <th>Specify reduced working pressure pending repairs.</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['working_pressure_repairs']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">15.</td>
                    <th>Other observation/conditions subject to which the plant is to be operated.</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['observation']) ?></td>
                </tr>
            </tbody>
        </table>
       

            <div class="footer-declaration">
                <p>
                    I/We clarify that on <b>
                        <?=
                        !empty($form['competent_date'])
                            ? date('d-m-Y', strtotime($form['competent_date']))
                            : (!empty($reminder_date) ? date('d-m-Y', strtotime($reminder_date)) : '')
                        ?>
                    </b>
                    the pressure plant/vessel described above was thoroughly cleaned and (so far as its construction permits)
                    made accessible for through examination and for such tests as were necessary for through examination and that on the said date. I throughly examined this pressure vessel/Plant including its fitting and that the above is true report of my examination.
                </p>

                <p><strong>Signature of Competent Person:</strong></p>
              <table>
        <tbody>
            <tr>
                <td class="label-cell">1</td>
                <th style="width: 45%;">Name of Competent Person</th>
                <td class="label-cell">:</td>
                <td><?= htmlspecialchars($form['competent_name'] ?? '') ?></td>
            </tr>
            <tr>
                <td class="label-cell">2</td>
                <th>Qualification</th>
                <td class="label-cell">:</td>
                <td><?= htmlspecialchars($form['competent_qualification'] ?? '') ?></td>
            </tr>
            <tr>
                <td class="label-cell">3</td>
                <th>Address</th>
                <td class="label-cell">:</td>
                <td><?= nl2br(htmlspecialchars($form['competent_address'] ?? '')) ?></td>
            </tr>
            <tr>
                <td class="label-cell">4</td>
                <th>Date</th>
                <td class="label-cell">:</td>
                <td><?= !empty($reminder_date) ? date('d-m-Y', strtotime($reminder_date)) : '' ?></td>
            </tr>
            <tr>
                <td class="label-cell">5</td>
                <th>Next Due Date</th>
                <td class="label-cell">:</td>
                <td><?= !empty($expiry_date) ? date('d-m-Y', strtotime($expiry_date)) : '' ?></td>
            </tr>
        </tbody>
    </table>

                
            </div>
        <table id="form13footer" style="width:100%; border: none; margin-bottom:  0px;">
            <tr style="background-color: #03b8ed; color: #fff;">
                <td style="text-align:center; font-size: 14px; padding: 10px;">
                    FORM-13<br>

                </td>
            </tr>
        </table>


    </div>

    
    <script src="/js/script.js"></script>
</body>

</html>
<?php ob_end_flush(); ?>