<?php
ob_start();
session_start();
require_once "config/db.php";

if(!isset($_SESSION['admin'])){
    header("Location: login.php");
    exit;
}

// Handle delete request
if(isset($_GET['delete'])){
    $id = intval($_GET['delete']);
    $conn->query("DELETE FROM form13 WHERE id = $id");
    header("Location: form_13_list.php?msg=deleted");
    exit;
}

// Fetch Form 13 entries with company name
$sql = "SELECT f.*, c.name AS company_name 
        FROM form13 f
        LEFT JOIN companies c ON f.company_id = c.id
        ORDER BY f.id DESC";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Axle_Services</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="css/header.css">
<link rel="stylesheet" href="css/sidebar.css">
<style>
body {
    background: #f8f9fa;
}
.main-content {
    margin-top: 70px;
    margin-left: 250px;
    padding: 20px;
    transition: all 0.3s ease;
}
.table-container {
    background: #fff;
    padding: 15px;
    border-radius: 10px;
    box-shadow: 0 6px 15px rgba(0,0,0,0.1);
    overflow-x: auto;
}
.page-header {
    background-color: #0d6efd;
    color: #fff;
    padding: 15px;
    text-align: center;
    margin-bottom: 20px;
    border-radius: 8px;
    text-transform: uppercase;
}
.table th, .table td {
    vertical-align: middle;
    white-space: nowrap;
}
@media (max-width: 768px) {
    .main-content { margin-left: 0; }
}
</style>
</head>
<body>

<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>

<div class="main-content">
    <div class="page-header">Form 13 Entries</div>

    <div class="table-container">
        <?php if(isset($_GET['msg']) && $_GET['msg']=='deleted'): ?>
            <div class="alert alert-success">Form 13 entry deleted successfully!</div>
        <?php endif; ?>

        <table class="table table-bordered table-striped table-hover align-middle">
            <thead class="table-primary">
                <tr>
                    <th>ID</th>
                    <th>Company Name</th>
                    <th>Factory Address</th>
                    <th>Equipment Name</th>
                    <th>Pressure Plant Name</th>
                    <th>Maker Name</th>
                    <th>Nature of Process</th>
                    <th>Date of Construction</th>
                    <th>Date First Use</th>
                    <th>Safe Working Pressure</th>
                    <th>Date of External Exam</th>
                    <th>Date of Internal Exam</th>
                    <th>Date of Hydraulic Exam</th>
                    <th>Ultrasonic Test Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php if($result->num_rows > 0): ?>
                <?php while($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= $row['id'] ?></td>
                        <td><?= htmlspecialchars($row['company_name']) ?></td>
                        <td><?= htmlspecialchars($row['factory_address']) ?></td>
                        <td><?= htmlspecialchars($row['equipment_name']) ?></td>
                        <td><?= htmlspecialchars($row['pressure_plant_name']) ?></td>
                        <td><?= htmlspecialchars($row['maker_name']) ?></td>
                        <td><?= htmlspecialchars($row['nature_of_process']) ?></td>
                        <td><?= htmlspecialchars($row['date_of_construction']) ?></td>
                        <td><?= htmlspecialchars($row['date_first_use']) ?></td>
                        <td><?= htmlspecialchars($row['safe_working_pressure']) ?></td>
                        <td><?= htmlspecialchars($row['date_of_external_exam']) ?></td>
                        <td><?= htmlspecialchars($row['date_of_internal_exam']) ?></td>
                        <td><?= htmlspecialchars($row['date_of_hydraulic_exam']) ?></td>
                        <td><?= htmlspecialchars($row['ultrasonic_test_date']) ?></td>
                        
                        <td>
                            <a href="form_13_print.php?id=<?= $row['id'] ?>" target="_blank" class="btn btn-primary btn-sm">Print</a>
                            <a href="edit_form_13.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                            <a href="form_13_list.php?delete=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this entry?');">Delete</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr><td colspan="15" class="text-center">No entries found</td></tr>
            <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<script src="/js/script.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php ob_end_flush(); ?>
