<?php
ob_start();
session_start();
require_once "config/db.php";

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}


$companies = $conn->query("SELECT id, name, address FROM companies");
$success_message = '';
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Collect and sanitize inputs
    $company_id = !empty($_POST['company_id']) ? (int)$_POST['company_id'] : null;
    $factory_address = trim($_POST['factory_address'] ?? '');
    $equipment_name = trim($_POST['equipment_name'] ?? '');
    $pressure_plant_name = trim($_POST['pressure_plant_name'] ?? '');
    $maker_name = trim($_POST['maker_name'] ?? '');
    $nature_of_process = trim($_POST['nature_of_process'] ?? '');
    $date_of_construction = nullIfEmpty($_POST['date_of_construction'] ?? '');
    $thickness_of_wall = trim($_POST['thickness_of_wall'] ?? '');
    $date_first_use = nullIfEmpty($_POST['date_first_use'] ?? '');
    $safe_working_pressure = trim($_POST['safe_working_pressure'] ?? '');
    $part_of_gas_holdes = trim($_POST['part_of_gas_holdes'] ?? '');
    $crown = trim($_POST['crown'] ?? '');
    $side_sheeting = trim($_POST['side_sheeting'] ?? '');
    $guiding_mechanism = trim($_POST['guiding_mechanism'] ?? '');
    $tank = trim($_POST['tank'] ?? '');
    $other_structure = trim($_POST['other_structure'] ?? '');
    $lift_position = trim($_POST['lift_position'] ?? '');
    $tank_lift_perticulars = trim($_POST['tank_lift_perticulars'] ?? '');
    $date_of_external_exam = nullIfEmpty($_POST['date_of_external_exam'] ?? '');
    $date_of_internal_exam = nullIfEmpty($_POST['date_of_internal_exam'] ?? '');
    $date_of_hydraulic_exam = nullIfEmpty($_POST['date_of_hydraulic_exam'] ?? '');
    $ultrasonic_test_date = nullIfEmpty($_POST['ultrasonic_test_date'] ?? '');
    $by_whom = trim($_POST['by_whom'] ?? '');
    $removed_login = trim($_POST['removed_login'] ?? '');
    $external_examination = trim($_POST['external_examination'] ?? '');
    $internal_examination = trim($_POST['internal_examination'] ?? '');
    $hydraulic_test = trim($_POST['hydraulic_test'] ?? '');
    $altrasonic_test = trim($_POST['altrasonic_test'] ?? '');
    $safe_working_pressure1 = trim($_POST['safe_working_pressure1'] ?? '');
    $safe_working_pressure2 = trim($_POST['safe_working_pressure2'] ?? '');
    $safe_working_pressure3 = trim($_POST['safe_working_pressure3'] ?? '');
    $vessel = trim($_POST['vessel'] ?? '');
    $piping = trim($_POST['piping'] ?? '');
    $pressure_gauges = trim($_POST['pressure_gauges'] ?? '');
    $safety_valve = trim($_POST['safety_valve'] ?? '');
    $stop_valve = trim($_POST['stop_valve'] ?? '');
    $reducing_valve = trim($_POST['reducing_valve'] ?? '');
    $additional_safety_valve = trim($_POST['additional_safety_valve'] ?? '');
    $other_devices = trim($_POST['other_devices'] ?? '');
    $maintenance_status = trim($_POST['maintenance_status'] ?? '');
    $working_pressure_after_examination = trim($_POST['working_pressure_after_examination'] ?? '');
    $repairs = trim($_POST['repairs'] ?? '');
    $working_pressure_repairs = trim($_POST['working_pressure_repairs'] ?? '');
    $observation = trim($_POST['observation'] ?? '');
    $competent_name = trim($_POST['competent_name'] ?? '');
$competent_qualification = trim($_POST['competent_qualification'] ?? '');
$competent_address = trim($_POST['competent_address'] ?? '');

    $submitted_at = date('Y-m-d H:i:s');

    // Prepare INSERT SQL
   $sql = "INSERT INTO form13 (
    company_id, factory_address, equipment_name, pressure_plant_name, maker_name, nature_of_process,
    date_of_construction, thickness_of_wall, date_first_use, safe_working_pressure, part_of_gas_holdes,
    crown, side_sheeting, guiding_mechanism, tank, other_structure, lift_position, tank_lift_perticulars,
    date_of_external_exam, date_of_internal_exam, date_of_hydraulic_exam, ultrasonic_test_date,
    by_whom, removed_login, external_examination, internal_examination, hydraulic_test, altrasonic_test,
    safe_working_pressure1, safe_working_pressure2, safe_working_pressure3,
    vessel, piping, pressure_gauges, safety_valve, stop_valve, reducing_valve,
    additional_safety_valve, other_devices, maintenance_status, working_pressure_after_examination,
    repairs, working_pressure_repairs, observation, competent_name, competent_qualification, competent_address,submitted_at
) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";



$stmt = $conn->prepare($sql);

$stmt->bind_param(
    "isssssssssssssssssssssssssssssssssssssssssssssss",

    $company_id,
    $factory_address,
    $equipment_name,
    $pressure_plant_name,
    $maker_name,
    $nature_of_process,
    $date_of_construction,
    $thickness_of_wall,
    $date_first_use,
    $safe_working_pressure,
    $part_of_gas_holdes,
    $crown,
    $side_sheeting,
    $guiding_mechanism,
    $tank,
    $other_structure,
    $lift_position,
    $tank_lift_perticulars,
    $date_of_external_exam,
    $date_of_internal_exam,
    $date_of_hydraulic_exam,
    $ultrasonic_test_date,
    $by_whom,
    $removed_login,
    $external_examination,
    $internal_examination,
    $hydraulic_test,
    $altrasonic_test,
    $safe_working_pressure1,
    $safe_working_pressure2,
    $safe_working_pressure3,
    $vessel,
    $piping,
    $pressure_gauges,
    $safety_valve,
    $stop_valve,
    $reducing_valve,
    $additional_safety_valve,
    $other_devices,
    $maintenance_status,
    $working_pressure_after_examination,  
    $repairs,
    $working_pressure_repairs,
    $observation,         
     $competent_name,
  $competent_qualification,
  $competent_address,               
    $submitted_at
);


if ($stmt->execute()) {
    // Insert reminder if date is selected
    $reminder_date = !empty($_POST['reminder_date']) ? $_POST['reminder_date'] : null;

    if ($reminder_date && $company_id) {
        // Hardcoded category and subcategory names
        $category_name = 'DISH';
        $subcategory_name = 'Form 13';

        // Hardcoded validity months for Form 13 (e.g., 12 months)
        $validity_months = 6; 

        // Calculate expiry date based on validity months
        $expiry_date = date('Y-m-d', strtotime("+$validity_months months", strtotime($reminder_date)));

        // Insert into company_reminders
        $reminder_sql = "INSERT INTO company_reminders 
            (company_id, category_name, subcategory_name, reminder_date, expiry_date, status, created_at) 
            VALUES (?, ?, ?, ?, ?, 'pending', NOW())";
        $reminder_stmt = $conn->prepare($reminder_sql);
        $reminder_stmt->bind_param("issss", $company_id, $category_name, $subcategory_name, $reminder_date, $expiry_date);

        if (!$reminder_stmt->execute()) {
            die("Reminder insert failed: " . $reminder_stmt->error);
        }
        $reminder_stmt->close();
    }

    $_SESSION['success_message'] = "Form 13 submitted and reminder set!";
    header("Location: form_13.php");
    exit;



} else {
    $error_message = "Error: " . $stmt->error;
}

$stmt->close();

}


function nullIfEmpty($value) {
    return (!empty($value) && $value !== '') ? $value : null;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Axle_Services</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Select2 CSS & JS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<link rel="stylesheet" href="css/style.css" />
<link rel="stylesheet" href="css/header.css" />
<link rel="stylesheet" href="css/sidebar.css" />
<style>
  body {
    background: #f9fafb;
    
    color: #333;
    min-height: 100vh;
  }

  .main-content {
    margin-top: 70px;
    margin-left: 250px;
    padding: 30px 40px;
    transition: all 0.3s ease;
    min-height: calc(100vh - 70px);
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 8px 24px rgb(0 0 0 / 0.05);
  }

  @media (max-width: 991.98px) {
    .main-content {
      margin-left: 0;
      padding: 20px;
      border-radius: 0;
      box-shadow: none;
    }
  }

  .page-header {
    background-color: #0d6efd;
    color: #fff;
    padding: 20px 25px;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgb(13 110 253 / 0.3);
    margin-bottom: 30px;
    text-align: center;
    font-weight: 600;
    font-size: 1.8rem;
    letter-spacing: 0.03em;
  }

  form {
    max-width: 900px;
    margin: 0 auto;
  }

  label.form-label {
    font-weight: 600;
    color: #495057;
  }

  input.form-control,
  select.form-select,
  textarea.form-control {
    border-radius: 8px;
    border: 1.5px solid #ced4da;
    padding: 10px 14px;
    font-size: 1rem;
    transition: border-color 0.3s ease, box-shadow 0.3s ease;
  }

  input.form-control:focus,
  select.form-select:focus,
  textarea.form-control:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 8px rgb(13 110 253 / 0.25);
    outline: none;
  }

  textarea.form-control {
    min-height: 80px;
    resize: vertical;
  }

  h6 {
    font-weight: 400;
    color: #0d6efd;
    margin-top: 40px;
    margin-bottom: 20px;
    border-bottom: 2px solid #0d6efd;
    padding-bottom: 6px;
  }

  .btn-success {
    background-color: #198754;
    border-color: #198754;
    font-weight: 600;
    font-size: 1.1rem;
    padding: 12px 40px;
    border-radius: 50px;
    transition: background-color 0.3s ease, box-shadow 0.3s ease;
  }

  .btn-success:hover {
    background-color: #157347;
    box-shadow: 0 6px 15px rgb(21 115 71 / 0.4);
  }

  .alert {
    max-width: 900px;
    margin: 0 auto 30px auto;
    border-radius: 10px;
    font-weight: 600;
    font-size: 1rem;
  }

  @media (max-width: 575.98px) {
    form .col-md-6,
    form .col-md-4,
    form .col-12 {
      flex: 0 0 100% !important;
      max-width: 100% !important;
    }
  }
</style>
</head>
<body>
<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>

<div class="main-content">
  <div class="page-header">Form No.13</div>

  <?php if ($error_message): ?>
    <div class="alert alert-danger shadow-sm"><?= htmlspecialchars($error_message) ?></div>
  <?php endif; ?>
  <?php if (isset($_SESSION['success_message'])): ?>
    <div class="alert alert-success shadow-sm"><?= htmlspecialchars($_SESSION['success_message']) ?></div>
    <?php unset($_SESSION['success_message']); ?>
  <?php endif; ?>

  <form method="POST" class="row g-4" novalidate>
    <!-- <div class="row align-items-center mb-3 mt-3">
  <div class="col-md-4">
    <label class="form-label" for="companySelect">1. Name of the Occupier</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="company_name" id="companySearch" placeholder="Type company name..." autocomplete="off">
    <input type="hidden" name="company_id" id="companyId">
    <div id="companyList" class="list-group position-absolute bg-light" style="z-index:1000;"></div>
  </div>
</div> -->
   <div class="row align-items-center mb-3 mt-3">
  <div class="col-md-4">
    <label class="form-label" for="companySearch">Name & Address of the Factory</label>
  </div>

  <div class="col-md-8 position-relative">
    <input type="text" 
           class="form-control mb-2" 
           name="company_name" 
           id="companySearch" 
           placeholder="Type company name..." 
           autocomplete="off">

    <input type="hidden" name="company_id" id="companyId">

    <div id="companyList" 
         class="list-group position-absolute bg-light w-100" 
         style="z-index:1000;">
    </div>

    <input type="text" 
           class="form-control mt-2" 
           name="factory_address" 
           id="factoryAddress" 
           placeholder="Factory address will appear here..." 
           readonly>
  </div>
</div>


   <div class="row align-items-center mb-3">
  <div class="col-md-4">
      <label class="form-label" for="equipmentName">Name of Equipment</label>
       </div>
  <div class="col-md-8">
      <input type="text" class="form-control" name="equipment_name" id="equipmentName" />
    </div>
   </div>

   <div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="pressurePlantName">2.Name, description and distinctive number of the pressure plant/vessel</label>
  </div>
  <div class="col-md-6">
    <textarea class="form-control" name="pressure_plant_name" id="pressurePlantName"></textarea>
  </div>
</div>
   <div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="makerName">3.Name and address of maker</label>
  </div>
  <div class="col-md-8">
    <textarea class="form-control" name="maker_name" id="makerName"></textarea>
  </div>
</div>
   
   <div class="row align-items-center mb-3">
  <div class="col-md-5">
    <label class="form-label" for="natureOfProcess">4. Nature of process in which it is used</label>
  </div>
  <div class="col-md-7">
    <input type="text" class="form-control" name="nature_of_process" id="natureOfProcess" />
  </div>
</div>

    <div class="col-12"><h6>5. Particulars of plant/Vessel</h6></div>
<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="dateOfConstruction">a) Date of Construction</label>
  </div>
  <div class="col-md-4">
    <input type="date" class="form-control" name="date_of_construction" id="dateOfConstruction" />
  </div>
</div>
<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="thicknessOfWall">b) Thickness of Walls</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="thickness_of_wall" id="thicknessOfWall" />
  </div>
</div>
<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="dateFirstUse">c) Date on which it was first taken into use</label>
  </div>
  <div class="col-md-4">
    <input type="date" class="form-control" name="date_first_use" id="dateFirstUse" />
  </div>
</div>
<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="safeworking">d) Safe working pressure recommended by maker</label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="safe_working_pressure" id="safeworking" />
  </div>
</div>
    <div class="col-12"><h6>5. (A)Particulars of Plant/Vessel/Gas holder</h6></div>
<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="partOfGasHolders">a) Parts of the gas-holders examined by electronics or other accurate devices or by cutting sample discs and results thereof</label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="part_of_gas_holdes" id="partOfGasHolders" />
  </div>
</div>
<div class="row align-items-center mb-3">
  <div class="col-12">
    <label class="form-label">b) Particulars as to the condition of</label>
  </div>
  
</div>
<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="crown">i) Crown</label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="crown" id="crown" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="sideSheeting">ii) Side sheeting including grips and cups</label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="side_sheeting" id="sideSheeting" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="guidingMechanism">iii) Guiding mechanism (roler carriages, roller, pins, guide, ropes, etc.)</label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="guiding_mechanism" id="guidingMechanism" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="tank">iv) Tank</label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="tank" id="tank" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="otherStructure">v) Other structure, if any, columns (faming and braking).</label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="other_structure" id="otherStructure" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="liftPosition">c) Particulars as to the position of the lift at the time of examination.</label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="lift_position" id="liftPosition" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="tankLiftParticulars">d) Particulars as to whether the tank and lifts were found sufficiently level for safe working</label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="tank_lift_perticulars" id="tankLiftParticulars" />
  </div>
</div>
    <div class="col-12"><h6>6. Date of</h6></div>
<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="dateOfExternalExam">i) Last external examination</label>
  </div>
  <div class="col-md-4">
    <input type="date" class="form-control" name="date_of_external_exam" id="dateOfExternalExam" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="dateOfInternalExam">ii) Last internal examination</label>
  </div>
  <div class="col-md-4">
    <input type="date" class="form-control" name="date_of_internal_exam" id="dateOfInternalExam" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="dateOfHydraulicExam">iii) Last hydraulic examination</label>
  </div>
  <div class="col-md-4">
    <input type="date" class="form-control" name="date_of_hydraulic_exam" id="dateOfHydraulicExam" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="ultrasonicTestDate">iv) Last ultrasonic test</label>
  </div>
  <div class="col-md-4">
    <input type="date" class="form-control" name="ultrasonic_test_date" id="ultrasonicTestDate" />
  </div>
</div>
<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="byWhom">6. (A) By whom it is carried out?</label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="by_whom" id="byWhom" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="removedLogin">7. Whether lagging was removed for purposes of examination</label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="removed_login" id="removedLogin" />
  </div>
</div>
    <div class="col-12"><h6>8. Description of examinations carried out and finding.</h6></div>
<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="externalExamination">i) External examination (give reasons if it is not carried out six monthly)</label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="external_examination" id="externalExamination" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="internalExamination">ii) Internal examination (give reason if it is not carried out annually)/label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="internal_examination" id="internalExamination" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="hydraulicTest">iii) Hydraulic test (Give reason if this is not carried out at interval of 2 years or 4 years)</label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="hydraulic_test" id="hydraulicTest" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="altrasonicTest">iv) Ultrasonic test (please quote number and date of the certificate issued by Chief Inspector permitting ultrasonic test in lieu of internal examination and hydraulic test ).</label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="altrasonic_test" id="altrasonicTest" />
  </div>
</div>

    <div class="col-12"><h6>9. Safe working pressure calculated as per methods given in the rule 5 (c)(ii) for sizing Cylinder.</h6></div>
<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="safeWorkingPressure1">1) </label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="safe_working_pressure1" id="safeWorkingPressure1" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="safeWorkingPressure2">2) </label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="safe_working_pressure2" id="safeWorkingPressure2" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="safeWorkingPressure3">3) </label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="safe_working_pressure3" id="safeWorkingPressure3" />
  </div>
</div>
    <div class="col-12"><h6>10. Conditions of pressure plant</h6></div>
<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="vessel">a) Vessel</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="vessel" id="vessel" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="piping">b) Piping</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="piping" id="piping" />
  </div>
</div>
    <div class="col-12"><h6>11. Condition of fitting and appliances</h6></div>
<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="pressureGauges">i) Pressure gauges</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="pressure_gauges" id="pressureGauges" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="safetyValve">ii) Safety valve</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="safety_valve" id="safetyValve" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="stopValve">iii) Stop valve</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="stop_valve" id="stopValve" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="reducingValve">iv) Reducing valve (give reason if not necessary)</label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="reducing_valve" id="reducingValve" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="additionalSafetyValve">v) Additional safety valve (required in case reducing valve is necessary)</label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="additional_safety_valve" id="additionalSafetyValve" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="otherDevices">vi) Other devices (please specify particularly in case of jacketed vessels)</label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="other_devices" id="otherDevices" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="maintenanceStatus">vii) Are all fittings and applications properly maintained and in good condition, repairs if any required and period within which they should be executed.</label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="maintenance_status" id="maintenanceStatus" />
  </div>
</div>
<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="workingPressureAfterExamination">12. Safe working pressure recommended after examination (specify the allowances made for conditions of working such as heat, corrosion etc.)</label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="working_pressure_after_examination" id="workingPressureAfterExamination" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="repairs">13. Specify repairs if any and period within which they should be executed.</label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="repairs" id="repairs" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="workingPressureRepairs">14. Specify reduced working pressure pending repairs.</label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="working_pressure_repairs" id="workingPressureRepairs" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="observation">15. Other observation/conditions subject to which the plant is to be operated.</label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="observation" id="observation" />
  </div>
</div>
<div class="col-12 mt-4">
  <h6> Add Footer(Competent Person Details) </h6>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="competent_name">Name of Competent Person</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="competent_name" id="competent_name" placeholder="Enter competent person name">
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="competent_qualification">Qualification of Competent Person</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="competent_qualification" id="competent_qualification" placeholder="Enter qualification">
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="competent_address">Address of Competent Person</label>
  </div>
  <div class="col-md-8">
    <textarea class="form-control" name="competent_address" id="competent_address" placeholder="Enter address"></textarea>
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="reminderDate">16. Reminder Date</label>
  </div>
  <div class="col-md-4">
    <input type="date" class="form-control" name="reminder_date" id="reminderDate" />
  </div>
</div>
<input type="hidden" name="category_id" value="<?= $category_id ?>">
<input type="hidden" name="subcategory_id" value="<?= $subcategory_id ?>">
    <div class="col-12 text-center mt-4">
      <button type="submit" class="btn btn-success px-5">Submit Form</button>
    </div>
  </form>
</div>
<script>
  document.getElementById('companySelect').addEventListener('change', function(){
    var address = this.options[this.selectedIndex].getAttribute('data-address');
    document.getElementById('factoryAddress').value = address || '';
  });
</script>
<script src="/js/script.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php ob_end_flush(); ?>