<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

ob_start();
session_start();

if (isset($_SESSION['success_message'])) {
    $success_message = $_SESSION['success_message'];
    unset($_SESSION['success_message']);
}
require_once "config/db.php";

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

if (!isset($_GET['id'])) {
    die("Form ID not provided.");
}

$form_id = intval($_GET['id']);

function safe_date($dateStr)
{
    return (!empty($dateStr) && strtotime($dateStr) !== false)
        ? date('d-m-Y', strtotime($dateStr))
        : '';
}




// Fetch form data
$sql = "SELECT f.*, c.name AS company_name, c.address AS company_address 
        FROM form11 f 
        LEFT JOIN companies c ON f.company_id = c.id
        WHERE f.id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $form_id);
$stmt->execute();

// ---- fetch without get_result() ----
$meta = $stmt->result_metadata();
$fields = [];
$row = [];
while ($field = $meta->fetch_field()) {
    $fields[] = &$row[$field->name];
}
call_user_func_array([$stmt, 'bind_result'], $fields);

$form = null;
if ($stmt->fetch()) {
    foreach ($row as $key => $val) {
        $form[$key] = $val;
    }
}
$stmt->close();

if (!$form) {
    die("Form not found.");
}

// Reminder fetch
$reminder_sql = "SELECT reminder_date, expiry_date 
                 FROM company_reminders 
                 WHERE company_id = ? AND subcategory_name = 'Form 11' 
                 ORDER BY id DESC 
                 LIMIT 1";
$reminder_stmt = $conn->prepare($reminder_sql);
$reminder_stmt->bind_param("i", $form['company_id']);
$reminder_stmt->execute();

// ---- fetch without get_result() ----
$meta2 = $reminder_stmt->result_metadata();
$fields2 = [];
$row2 = [];
while ($field2 = $meta2->fetch_field()) {
    $fields2[] = &$row2[$field2->name];
}
call_user_func_array([$reminder_stmt, 'bind_result'], $fields2);

$reminder = null;
if ($reminder_stmt->fetch()) {
    foreach ($row2 as $key => $val) {
        $reminder[$key] = $val;
    }
}
$reminder_stmt->close();

// Set default values
$reminder_date = $reminder['reminder_date'] ?? '';
$expiry_date   = $reminder['expiry_date'] ?? '';


?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Axle_Services</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="css/header.css">
    <link rel="stylesheet" href="css/sidebar.css">
    <link rel="stylesheet" href="css/style.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            color: #000;
            background: #fff;
        }

        .main-content {
            margin-top: 50px;
            margin-left: 250px;
            padding: 30px 40px;
            transition: all 0.3s ease;
            min-height: calc(100vh - 70px);
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 8px 24px rgb(0 0 0 / 0.05);
            font-size: 13.5px;
        }

        @media (max-width: 991.98px) {
            .main-content {
                margin-left: 0;
                padding: 20px;
                border-radius: 0;
                box-shadow: none;
            }
        }

        h3 {
            text-align: center;
            margin-bottom: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        th {
            background-color: #ffff0070;
        }

        table,
        th,
        td {
            border: 1px solid #000;
        }

        th,
        td {
            padding: 2px;
            vertical-align: top;
            text-align: left;
        }

        /* .footer-declaration {
            margin-top: 20px;
        } */

        .form-control {
            padding: 0px;
            margin-bottom: 0px;
            font-size: 12.5px;
        }

        @page {
            size: A4;
            margin: 5mm;
        }

      @media print {
    body {
        margin: 0;
        padding: 0;
    }

    #form11footer {
        position: fixed;
        bottom: 0;
        left: 0;
        width: 100%;
    }

    .page-break-after {
        page-break-after: always;
    }

    * {
        -webkit-print-color-adjust: exact;
        print-color-adjust: exact;
    }

    body * {
        visibility: hidden;
    }

    .main-content,
    .main-content * {
        visibility: visible;
    }

   .form11-second-header-wrapper {
        display: block;
        margin-top: 10mm !important; /* ✅ works on divs */
    }

    .main-content {
        width: 100%;
        margin-top: 0;
       
    }

    #printBtn,
    #footerbtn,
    #checkfooter {
        display: none !important;
    }
}

    </style>
</head>

<body>
    <?php include 'header.php'; ?>
    <?php include 'sidebar.php'; ?>


    <div class="main-content">

        <div class="d-flex justify-content-end mb-3">
            <button class="btn btn-primary w-25" id="printBtn" onclick="window.print()">Print</button>
        </div>
        <?php if (!empty($success_message)): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?= htmlspecialchars($success_message) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <table style="width:100%; border-collapse: collapse; margin-bottom: 20px;">
            <thead>
                <tr style="background-color: orange; color: #fff;">
                    <td style="text-align:center; font-size: 14px; padding: 10px;">
                        FORM 11<br>
                        <span style="font-weight: normal; font-size: 12px;">
                            REPORT OF EXAMINATION OF HOIST, LIFT, LIFTING MACHINE, CHAINS, ROPES AND LIFTING TACKLE
                        </span>
                    </td>
                </tr>
            </thead>
        </table>

        <h6 class="text-center">(See Rule 62 & 64)</h6>
        <table>
            <tbody>
                <tr>
                    <td class="label-cell">1</td>
                    <th style="width:45%">Name of the Occupier</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['occupier_name']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">2</td>
                    <th>Name & Address of Factory</th>
                    <td class="label-cell">:</td>
                    <td>
                        <?php
                        if (!empty($form['company_name'])) {
                            echo '<strong>' . htmlspecialchars($form['company_name']) . '</strong><br>';
                        }
                        echo nl2br(htmlspecialchars($form['factory_address'] ?: $form['company_address']));
                        ?>
                    </td>
                </tr>
                <tr>
                    <td class="label-cell">3</td>
                    <th> Name of Equipment</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['equipment_name']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">3.(a)</td>
                    <th> Type Identification number and description of hoist, lift, lifting machine, chains, ropes and lifting tackles.</th>
                    <td class="label-cell">:</td>
                    <td><?= nl2br(htmlspecialchars($form['type_identification'])) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">(b)</td>
                    <th>Date of construction or reconstruction and the date when the hoist, lift, lifting machine, chains, ropes and lifting tackles were first taken into use in the factory.</th>
                    <td class="label-cell">:</td>
                    <td><?= safe_date($form['date_of_construction']) ?></td>

                </tr>
                <tr>
                    <td class="label-cell">4</td>
                    <th>Date of last examinations made under section 2(1) (a) (ii) and 29(1)(iii) and by whom it was carried out.</th>
                    <td class="label-cell">:</td>
                    <td><?= safe_date($form['date_first_use']) ?></td>
                </tr>

                <tr>
                    <td class="label-cell">5.A)</td>
                    <th> Maintenance (List of parts, if any, which were inaccessible) Are the following parts of the hoist or lift properly maintained and in good working order? If not, state what defects have been found:</th>
                    <td class="label-cell">:</td>

                </tr>
                <tr>
                    <td class="label-cell">a)</td>
                    <th>Enclosure of hoist way or lift way.</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['maintenance_a']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">b)</td>
                    <th>Landing gates and cage gate(s)</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['maintenance_b']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">c)</td>
                    <th>Interlocks on the landing gates and cage gate(s).</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['maintenance_c']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">d)</td>
                    <th>Other gate fastenings</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['maintenance_d']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">e)</td>
                    <th>Cage and platform and fittings, cage guides, buffers, interiors of the hoist way or lift way.</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['maintenance_e']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">f)</td>
                    <th>Overrunning devices</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['maintenance_f']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">g)</td>
                    <th>Suspension ropes or chains and their attachments.</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['maintenance_g']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">h)</td>
                    <th>Safety gear, i.e., arrangements for preventing fall of platform or cage brakes.</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['maintenance_h']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">i)</td>
                    <th>Brakes</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['maintenance_i']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">j)</td>
                    <th>Work of spur gearing.</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['maintenance_j']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">k)</td>
                    <th>Other Electrical Equipment</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['maintenance_k']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">l)</td>
                    <th>Other Parts.</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['maintenance_l']) ?></td>
                </tr>
                <tr class="page-break-after"></tr>
                    </table>

                <table id="form11footer" style="width:100%; border: none; margin-top: 0px;">
            <tr style="background-color: orange; color: #fff;">
                <td style="text-align:center; font-size: 14px; padding: 10px;">
                    FORM-11<br>

                </td>
            </tr>
        </table>
       

        <div class="form11-second-header-wrapper">
    <table class="form11-second-header" style="width:100%; border-collapse: collapse; margin-bottom: 20px;">
        <thead>
            <tr style="background-color: orange; color: #fff;">
                <td style="text-align:center; font-size: 14px; padding: 10px;">
                    FORM 11<br>
                    <span style="font-weight: normal; font-size: 12px;">
                        REPORT OF EXAMINATION OF HOIST, LIFT, LIFTING MACHINE, CHAINS, ROPES AND LIFTING TACKLE
                    </span>
                </td>
            </tr>
        </thead>
    </table>
</div>


        <table>
                <tr>
                    <td class="label-cell">5.B)</td>
                    <th style="width: 45%;">Date and number of the certificate relating to any test and examination made under sub rule (1) of rule 64 together with the name of the person who issued the certificate.</th>
                    <td class="label-cell">:</td>
                    <td><?= safe_date($form['certificate_date']) ?></td>

                </tr>
                <tr>
                    <td class="label-cell">C) i)</td>
                    <th>Date of annealing or the heat treatment of the chain and lifting tackle carried out under sub-rule (5) of rule 64 and by whom it was carried out.</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['certificate_no']) ?></td>
                </tr>
                <tr>
                    <td class="label-cell">ii)</td>
                    <th>Particulars of any defect found at any such examination or after annealing and affecting the safe working load and of the steps taken to remedy such defect.</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['certificate_by']) ?></td>
                </tr>
                 <!-- <tr class="page-break-after"></tr> -->
            

        
        
                <tr>
                    <td class="label-cell">6</td>
                    <th>Repairs, renewals or alterations (if any) required and the period within which they should be executed and maximum safe working load subjected to repairs, renewals or alterations (if any).</th>
                    <td class="label-cell">:</td>
                    <td><?= htmlspecialchars($form['repairs']) ?></td>
                </tr>
            </tbody>
        </table>



           <!-- Footer Declaration (Always Visible) -->
<div class="footer-declaration mt-4">
    <p>
        I/We clarify that on 
        <b><?= !empty($reminder_date) ? date('d-m-Y', strtotime($reminder_date)) : '' ?></b>,
        I/We thoroughly examined the hoist or lift, lifting machine, ropes and lifting tackles
        and details of examination/tests carried out is enclosed herewith.
        The above is a correct report of the result.
    </p>

    <p><strong>Signature of Competent Person:</strong></p><br>
    <table>
        <tbody>
            <tr>
                <td class="label-cell">1</td>
                <th style="width: 45%;">Name of Competent Person</th>
                <td class="label-cell">:</td>
                <td><?= htmlspecialchars($form['competent_name'] ?? '') ?></td>
            </tr>
            <tr>
                <td class="label-cell">2</td>
                <th>Qualification</th>
                <td class="label-cell">:</td>
                <td><?= htmlspecialchars($form['competent_qualification'] ?? '') ?></td>
            </tr>
            <tr>
                <td class="label-cell">3</td>
                <th>Address</th>
                <td class="label-cell">:</td>
                <td><?= nl2br(htmlspecialchars($form['competent_address'] ?? '')) ?></td>
            </tr>
            <tr>
                <td class="label-cell">4</td>
                <th>Date</th>
                <td class="label-cell">:</td>
                <td><?= !empty($reminder_date) ? date('d-m-Y', strtotime($reminder_date)) : '' ?></td>
            </tr>
            <tr>
                <td class="label-cell">5</td>
                <th>Next Due Date</th>
                <td class="label-cell">:</td>
                <td><?= !empty($expiry_date) ? date('d-m-Y', strtotime($expiry_date)) : '' ?></td>
            </tr>
        </tbody>
    </table>
</div>


        <table id="form11footer" style="width:100%; border: none; margin-top: 0px;">
            <tr style="background-color: orange; color: #fff;">
                <td style="text-align:center; font-size: 14px; padding: 10px;">
                    FORM-11<br>

                </td>
            </tr>
        </table>
    </div>

    
    <script src="/js/script.js"></script>

</body>

</html>
<?php ob_end_flush(); ?>