<?php
ob_start();
session_start();
require_once "config/db.php";

if(!isset($_SESSION['admin'])){
    header("Location: login.php");
    exit;
}

if(isset($_GET['delete'])){
    $id = intval($_GET['delete']);

    $stmt = $conn->prepare("DELETE FROM form11 WHERE id = ?");
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        header("Location: form_11_list.php?msg=deleted");
        exit;
    } else {
        die("Error deleting record: " . $stmt->error);
    }
}


// Fetch Form 11 entries with company name
$sql = "SELECT f.*, c.name AS company_name 
        FROM form11 f
        LEFT JOIN companies c ON f.company_id = c.id
        ORDER BY f.id DESC";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Axle_Services</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap">

<link rel="stylesheet" href="css/header.css">
<link rel="stylesheet" href="css/sidebar.css">
<style>
body {
    background: #f8f9fa;
    
}
.main-content {
    margin-top: 70px;
    margin-left: 250px;
    padding: 20px;
    transition: all 0.3s ease;
}
.table-container {
    background: #fff;
    padding: 15px;
    border-radius: 10px;
    box-shadow: 0 6px 15px rgba(0,0,0,0.1);
    overflow-x: auto;
}
.page-header {
    background-color: #0d6efd;
    color: #fff;
    padding: 15px;
    text-align: center;
    margin-bottom: 20px;
    border-radius: 8px;
    text-transform: uppercase;
}
.table th, .table td {
    vertical-align: middle;
    white-space: nowrap;
}
@media (max-width: 768px) {
    .main-content { margin-left: 0; }
}
</style>
</head>
<body>

<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>

<div class="main-content">
    <div class="page-header">Form 11 Entries</div>

    <div class="table-container">
        <?php if(isset($_GET['msg']) && $_GET['msg']=='deleted'): ?>
            <div class="alert alert-success">Form 11 entry deleted successfully!</div>
        <?php endif; ?>

        <table class="table table-bordered table-striped table-hover align-middle">
            <thead class="table-primary">
                <tr>
                    <th>ID</th>
                    <th>Occupier Name</th>
                    <th>Company Name</th>
                    <th>Factory Address</th>
                    <th>Equipment Name</th>
                    <th>Type Identification</th>
                    <th>Date of Construction</th>
                    <th>Date First Use</th>
                    <th>Certificate Date</th>
                    <th>Certificate No</th>
                    <th>Certificate By</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php if($result->num_rows > 0): ?>
                <?php while($row = $result->fetch_assoc()): ?>
                    <tr>
                        
                        <td><?= $row['id'] ?></td>
                        <td><?= htmlspecialchars($row['occupier_name']) ?></td>
                        <td><?= htmlspecialchars($row['company_name']) ?></td>
                        <td><?= htmlspecialchars($row['factory_address']) ?></td>
                        <td><?= htmlspecialchars($row['equipment_name']) ?></td>
                        <td><?= htmlspecialchars($row['type_identification']) ?></td>
                       <td><?= date('d-m-Y', strtotime($row['date_of_construction'])) ?></td>
                       <td><?= date('d-m-Y', strtotime($row['date_first_use'])) ?></td>
                        <td><?= date('d-m-Y', strtotime($row['certificate_date'])) ?></td>
                        <td><?= htmlspecialchars($row['certificate_no']) ?></td>
                        <td><?= htmlspecialchars($row['certificate_by']) ?></td>
                       
                        <td>
                            <a href="form_11_print.php?id=<?= $row['id'] ?>" target="_blank" class="btn btn-primary btn-sm">Print</a>
                            <a href="edit_form_11.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                            <a href="form_11_list.php?delete=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this entry?');">Delete</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr><td colspan="13" class="text-center">No entries found</td></tr>
            <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<script src="/js/script.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php ob_end_flush(); ?>
