<?php
ob_start();
session_start();
require_once "config/db.php";

if (!isset($_SESSION['admin'])) {
  header("Location: login.php");
  exit;
}
$category_id   = isset($_GET['cat']) ? (int)$_GET['cat'] : 0;
$subcategory_id = isset($_GET['sub']) ? (int)$_GET['sub'] : 0;

$companies = $conn->query("SELECT id, name, address FROM companies");
$success_message = '';
$error_message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $occupier_name = trim($_POST['occupier_name'] ?? '');
  $company_id = !empty($_POST['company_id']) ? (int)$_POST['company_id'] : null;
  $factory_address = trim($_POST['factory_address'] ?? '');
  $equipment_name = trim($_POST['equipment_name'] ?? '');
  $type_identification = trim($_POST['type_identification'] ?? '');

  function nullIfEmpty($date)
  {
    return (!empty($date) && $date !== '') ? $date : null;
  }

  $date_of_construction = nullIfEmpty($_POST['date_of_construction'] ?? '');
  $date_first_use = nullIfEmpty($_POST['date_first_use'] ?? '');
  $maintenance_a = trim($_POST['maintenance_a'] ?? '');
  $maintenance_b = trim($_POST['maintenance_b'] ?? '');
  $maintenance_c = trim($_POST['maintenance_c'] ?? '');
  $maintenance_d = trim($_POST['maintenance_d'] ?? '');
  $maintenance_e = trim($_POST['maintenance_e'] ?? '');
  $maintenance_f = trim($_POST['maintenance_f'] ?? '');
  $maintenance_g = trim($_POST['maintenance_g'] ?? '');
  $maintenance_h = trim($_POST['maintenance_h'] ?? '');
  $maintenance_i = trim($_POST['maintenance_i'] ?? '');
  $maintenance_j = trim($_POST['maintenance_j'] ?? '');
  $maintenance_k = trim($_POST['maintenance_k'] ?? '');
  $maintenance_l = trim($_POST['maintenance_l'] ?? '');

  $certificate_date = nullIfEmpty($_POST['certificate_date'] ?? '');
  $cert_no = trim($_POST['certificate_no'] ?? '');
  $cert_by = trim($_POST['certificate_by'] ?? '');
  $repairs = trim($_POST['repairs'] ?? '');
  $competent_name = trim($_POST['competent_name'] ?? '');
  $competent_qualification = trim($_POST['competent_qualification'] ?? '');
  $competent_address = trim($_POST['competent_address'] ?? '');

  // Prepare SQL
  $sql = "INSERT INTO form11 (
    occupier_name,company_id, factory_address, equipment_name, type_identification,
    date_of_construction, date_first_use, maintenance_a, maintenance_b, maintenance_c,
    maintenance_d, maintenance_e, maintenance_f, maintenance_g, maintenance_h,maintenance_i,maintenance_j,maintenance_k,maintenance_l,
    certificate_date, certificate_no, certificate_by, repairs,competent_name, competent_qualification, competent_address
) VALUES (?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?)";

  $stmt = $conn->prepare($sql);
  if (!$stmt) {
    die("Prepare failed: " . $conn->error);
  }

  // Bind parameters
  $stmt->bind_param(
    "sissssssssssssssssssssssss",
    $occupier_name,
    $company_id,
    $factory_address,
    $equipment_name,
    $type_identification,
    $date_of_construction,
    $date_first_use,
    $maintenance_a,
    $maintenance_b,
    $maintenance_c,
    $maintenance_d,
    $maintenance_e,
    $maintenance_f,
    $maintenance_g,
    $maintenance_h,
    $maintenance_i,
    $maintenance_j,
    $maintenance_k,
    $maintenance_l,
    $certificate_date,
    $cert_no,
    $cert_by,
    $repairs,
     $competent_name,
  $competent_qualification,
  $competent_address

  );

  if ($stmt->execute()) {
    // Insert reminder if date is selected
    $reminder_date = nullIfEmpty($_POST['reminder_date'] ?? '');
    if ($reminder_date && $company_id) {
      // Hardcoded names
      $category_name = 'DISH';
      $subcategory_name = 'Form 11';

      // Set expiry date as Dec 31 of reminder year
      $year = date('Y', strtotime($reminder_date));
      $expiry_date = "$year-12-31";

      // Insert into company_reminders with names instead of IDs
      $reminder_sql = "INSERT INTO company_reminders 
            (company_id, category_name, subcategory_name, reminder_date, expiry_date, status, created_at) 
            VALUES (?, ?, ?, ?, ?, 'pending', NOW())";
      $reminder_stmt = $conn->prepare($reminder_sql);
      $reminder_stmt->bind_param("issss", $company_id, $category_name, $subcategory_name, $reminder_date, $expiry_date);
      $reminder_stmt->execute();
      $reminder_stmt->close();
    }

    $_SESSION['success_message'] = "Form successfully submitted and reminder set!";
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
  } else {
    $error_message = "Error: " . $stmt->error;
  }


  $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Axle_Services</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link rel="stylesheet" href="css/style.css" />
  <link rel="stylesheet" href="css/header.css" />
  <link rel="stylesheet" href="css/sidebar.css" />
  <style>
    body {
      background: #f9fafb;

      color: #333;
      min-height: 100vh;
    }

    .main-content {
      margin-top: 70px;
      margin-left: 250px;
      padding: 30px 40px;
      transition: all 0.3s ease;
      min-height: calc(100vh - 70px);
      background: #fff;
      border-radius: 12px;
      box-shadow: 0 8px 24px rgb(0 0 0 / 0.05);
    }

    @media (max-width: 991.98px) {
      .main-content {
        margin-left: 0;
        padding: 20px;
        border-radius: 0;
        box-shadow: none;
      }
    }

    .page-header {
      background-color: #0d6efd;
      color: #fff;
      padding: 20px 25px;
      border-radius: 12px;
      box-shadow: 0 4px 12px rgb(13 110 253 / 0.3);
      margin-bottom: 30px;
      text-align: center;
      font-weight: 600;
      font-size: 1.8rem;
      letter-spacing: 0.03em;
    }

    form {
      max-width: 900px;
      margin: 0 auto;
    }

    label.form-label {
      font-weight: 600;
      color: #495057;
    }

    input.form-control,
    select.form-select,
    textarea.form-control {
      border-radius: 8px;
      border: 1.5px solid #ced4da;
      padding: 10px 14px;
      font-size: 1rem;
      transition: border-color 0.3s ease, box-shadow 0.3s ease;
    }

    input.form-control:focus,
    select.form-select:focus,
    textarea.form-control:focus {
      border-color: #0d6efd;
      box-shadow: 0 0 8px rgb(13 110 253 / 0.25);
      outline: none;
    }

    textarea.form-control {
      min-height: 80px;
      resize: vertical;
    }

    h6 {
      font-weight: 400;
      color: #0d6efd;
      margin-top: 40px;
      margin-bottom: 20px;
      border-bottom: 2px solid #0d6efd;
      padding-bottom: 6px;
    }

    .btn-success {
      background-color: #198754;
      border-color: #198754;
      font-weight: 600;
      font-size: 1.1rem;
      padding: 12px 40px;
      border-radius: 50px;
      transition: background-color 0.3s ease, box-shadow 0.3s ease;
    }

    .btn-success:hover {
      background-color: #157347;
      box-shadow: 0 6px 15px rgb(21 115 71 / 0.4);
    }

    .alert {
      max-width: 900px;
      margin: 0 auto 30px auto;
      border-radius: 10px;
      font-weight: 600;
      font-size: 1rem;
    }

    @media (max-width: 575.98px) {

      form .col-md-6,
      form .col-md-4,
      form .col-12 {
        flex: 0 0 100% !important;
        max-width: 100% !important;
      }
    }
  </style>
</head>

<body>
  <?php include 'header.php'; ?>
  <?php include 'sidebar.php'; ?>

  <div class="main-content">
    <div class="page-header">Form No.11</div>

    <?php if ($error_message): ?>
      <div class="alert alert-danger shadow-sm"><?= htmlspecialchars($error_message) ?></div>
    <?php endif; ?>
    <?php if (isset($_SESSION['success_message'])): ?>
      <div class="alert alert-success shadow-sm"><?= htmlspecialchars($_SESSION['success_message']) ?></div>
      <?php unset($_SESSION['success_message']); ?>
    <?php endif; ?>
    <form method="POST" class="row g-4" novalidate>
      <div class="row align-items-center mb-3 mt-3">
        <div class="col-md-4">

          <label class="form-label" for="companySelect">1. Name of the Occupier</label>
        </div>
        <div class="col-md-8">
          <input type="text" class="form-control" name="occupier_name" id="occupierName" />
        </div>
        <!-- <div class="col-md-8">
          <input type="text" class="form-control" name="company_name" id="companySearch" placeholder="Type company name..." autocomplete="off">
          <input type="hidden" name="company_id" id="companyId">
          <div id="companyList" class="list-group position-absolute bg-light" style="z-index:1000;"></div>
        </div> -->
      </div>
     <div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="companySearch">2. Name & Address of the Factory</label>
  </div>
  <div class="col-md-8 position-relative">
    <!-- Company name search input -->
    <input type="text" 
           class="form-control mb-2" 
           name="company_name" 
           id="companySearch" 
           placeholder="Type company name..." 
           autocomplete="off">

    <!-- Hidden field for company ID -->
    <input type="hidden" name="company_id" id="companyId">

    <!-- Autocomplete dropdown -->
    <div id="companyList" class="list-group position-absolute bg-light w-100" style="z-index: 1000;"></div>

    <!-- Factory address field (readonly, auto-filled after selection) -->
    <input type="text" 
           class="form-control mt-2" 
           name="factory_address" 
           id="factoryAddress" 
           placeholder="Factory address will appear here..." 
           readonly>
  </div>
</div>

         
      <div class="row align-items-center mb-3">
        <div class="col-md-4">
          <label class="form-label" for="equipmentName">Name of Equipment</label>
        </div>
        <div class="col-md-8">
          <input type="text" class="form-control" name="equipment_name" id="equipmentName" />
        </div>
      </div>
      <div class="row align-items-center mb-3">
        <div class="col-md-8">
          <label class="form-label" for="typeIdentification">3. (a) Type Identification number and description of hoist, lift, lifting machine, chains, ropes and lifting tackles.</label>
        </div>
        <div class="col-md-4">
          <textarea class="form-control" name="type_identification" id="typeIdentification"></textarea>
        </div>
      </div>
      <div class="row align-items-center mb-3">
        <div class="col-md-8">
          <label class="form-label" for="dateConstruction"> (b) Date of construction or reconstruction and the date when the hoist, lift, lifting machine, chains, ropes and lifting tackles were first taken into use in the factory.</label>
        </div>
        <div class="col-md-4">
          <input type="date" class="form-control" name="date_of_construction" id="dateConstruction" />
        </div>
      </div>

      <div class="row align-items-center mb-3">
        <div class="col-md-8">
          <label class="form-label" for="dateFirstUse">4. Date of last examinations made under section 2(1) (a) (ii) and 29(1)(iii) and by whom it was carried out.</label>
        </div>
        <div class="col-md-4">
          <input type="date" class="form-control" name="date_first_use" id="dateFirstUse" />
        </div>
      </div>

      <!-- Section 5(A) Maintenance Parts -->
      <div class="col-12">
        <h6>5. A) Maintenance (List of parts, if any, which were inaccessible) Are the following parts of the hoist or lift properly maintained and in good working order? If not, state what defects have been found:</h6>
      </div>
      <?php
      $parts = [
        "a) Enclosure of hoist way or lift way.",
        "b) Landing gates and cage gate(s).",
        "c) Interlocks on the landing gates and cage gate(s).",
        "d) Other gate fastenings.",
        "e) Cage and platform and fittings, cage guides, buffers, interiors of the hoist way or lift way.",
        "f) Overrunning devices.",
        "g) Suspension ropes or chains and their attachments.",
        "h) Safety gear, i.e., arrangements for preventing fall of platform or cage brakes.",
        "i) Brakes",
        "j) Work of spur gearing",
        "k) Other electrical equipment",
        "l) Other Parts"

      ];
      $keys = ['maintenance_a', 'maintenance_b', 'maintenance_c', 'maintenance_d', 'maintenance_e', 'maintenance_f', 'maintenance_g', 'maintenance_h', 'maintenance_i', 'maintenance_j', 'maintenance_k', 'maintenance_l'];
      foreach ($parts as $i => $p): ?>
        <div class="col-md-6">
          <label class="form-label" for="<?= $keys[$i] ?>"><?= $p ?></label>
          <input type="text" class="form-control" name="<?= $keys[$i] ?>" id="<?= $keys[$i] ?>">
        </div>
      <?php endforeach; ?>

      <!-- Section 5(B) -->
      <div class="row align-items-center mb-3">
        <div class="col-md-8">
          <label class="form-label" for="certificateDate">5. B) Date and number of the certificate relating to any test and examination made under sub rule (1) of rule 64 together with the name of the person who issued the certificate.</label>
        </div>
        <div class="col-md-4">
          <input type="date" class="form-control" name="certificate_date" id="certificateDate" />
        </div>
      </div>
      <div class="row align-items-center mb-3">
        <div class="col-md-8">
          <label class="form-label" for="certificateNo">C) (i) Date of annealing or the heat treatment of the chain and lifting tackle carried out under sub-rule (5) of rule 64 and by whom it was carried out.</label>
        </div>
        <div class="col-md-4">
          <input type="text" class="form-control" name="certificate_no" id="certificateNo" />
        </div>
      </div>
      <div class="row align-items-center mb-3">
        <div class="col-md-8">
          <label class="form-label" for="certificateBy"> (ii) Particulars of any defect found at any such examination or after annealing and affecting the safe working load and of the steps taken to remedy such defect.</label>
        </div>
        <div class="col-md-4">

          <input type="text" class="form-control" name="certificate_by" id="certificateBy" />
        </div>
      </div>

      <div class="row align-items-center mb-3">
        <div class="col-md-8">
          <label class="form-label" for="certificateBy">6. Repairs, renewals or alterations (if any) required and the period within which they should be executed and maximum safe working load subjected to repairs, renewals or alterations (if any).</label>
        </div>
        <div class="col-md-4">

          <input type="text" class="form-control" name="repairs" id="repairs">
        </div>
      </div>
      <!-- Competent Person Details -->
<div class="col-12 mt-4">
  <h6> Add Footer(Competent Person Details) </h6>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="competent_name">Name of Competent Person</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="competent_name" id="competent_name" placeholder="Enter competent person name">
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="competent_qualification">Qualification of Competent Person</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="competent_qualification" id="competent_qualification" placeholder="Enter qualification">
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="competent_address">Address of Competent Person</label>
  </div>
  <div class="col-md-8">
    <textarea class="form-control" name="competent_address" id="competent_address" placeholder="Enter address"></textarea>
  </div>
</div>

      <div class="row align-items-center mb-3">
        <div class="col-md-8">
          <label class="form-label" for="reminderDate">7. Reminder Date</label>
        </div>
        <div class="col-md-4">
          <input type="date" class="form-control" name="reminder_date" id="reminderDate" />
        </div>
      </div>
      <input type="hidden" name="category_id" value="<?= $category_id ?>">
      <input type="hidden" name="subcategory_id" value="<?= $subcategory_id ?>">



      <!-- Submit Button -->
      <div class="col-12 text-center mt-4">
        <button type="submit" class="btn btn-success px-5">Submit Form</button>
      </div>

    </form>
  </div>
  <script>
    document.getElementById('companySelect').addEventListener('change', function() {
      var address = this.options[this.selectedIndex].getAttribute('data-address');
      document.getElementById('factoryAddress').value = address || '';
    });
  </script>
  <script src="/js/script.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
<?php ob_end_flush(); ?>