<?php
ob_start();
session_start();
require_once "config/db.php";


if (isset($_SESSION['success_message'])) {
    $success_message = $_SESSION['success_message'];
    unset($_SESSION['success_message']);
}
if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$error_message = '';
$success_message = '';
// Fetch existing record
$sql = "SELECT * FROM stability_date_forms WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();

// try get_result first
if (method_exists($stmt, 'get_result')) {
    $result = $stmt->get_result();
    $form = $result->fetch_assoc();
} else {
    // fallback if get_result not available
    $meta = $stmt->result_metadata();
    $params = [];
    $row = [];
    while ($field = $meta->fetch_field()) {
        $params[] = &$row[$field->name];
    }
    call_user_func_array([$stmt, 'bind_result'], $params);
    $stmt->fetch();
    $form = $row;
}

$stmt->close();

if (!$form) {
    die("Record not found.");
}

$success_message = '';
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $company_id = !empty($_POST['company_id']) ? (int)$_POST['company_id'] : null;
    $factory_address = trim($_POST['factory_address'] ?? '');
    $village = trim($_POST['village'] ?? '');
    $town = trim($_POST['town'] ?? '');
    $district = trim($_POST['district'] ?? '');
    $factory_occupier_name = trim($_POST['factory_occupier_name'] ?? '');

    $manufacturing_process = $_POST['manufacturing_process'] ?? '';
    $number_of_floors = $_POST['number_of_floors'] ?? '';
    $ref_number_1 = $_POST['ref_number_1'] ?? '';
    $date1 = $_POST['date1'] ?? '';
    $ref_number_2 = $_POST['ref_number_2'] ?? '';
    $date2 = !empty($_POST['date2']) ? $_POST['date2'] : NULL;
    $competence_structural_eng = $_POST['competence_structural_eng'] ?? '';
    $structural_eng_name = $_POST['structural_eng_name'] ?? '';
    $inspection_date = $_POST['inspection_date'] ?? '';
    $issue_stability_person = $_POST['issue_stability_person'] ?? '';
    $drawings = $_POST['drawings'] ?? '';
    $building_mentioning_no_disc = $_POST['building_mentioning_no_disc'] ?? '';
    $general_condition = $_POST['general_condition'] ?? '';
    $building_maintainance_history = $_POST['building_maintainance_history'] ?? '';
    $loading_usage = $_POST['loading_usage'] ?? '';
    $original_purpose = $_POST['original_purpose'] ?? '';
    $phase_wise_details = $_POST['phase_wise_details'] ?? '';
    $structural_member_accidents = $_POST['structural_member_accidents'] ?? '';
    $addition_alteration = $_POST['addition_alteration'] ?? '';
    $env_detriments = $_POST['env_detriments'] ?? '';
    $next_inspection = $_POST['next_inspection'] ?? '';
    $long_term_strength = $_POST['long_term_strength'] ?? '';

   // Upload setup
$upload_dir = "uploads/"; // make sure folder exists
if (!is_dir($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}

// Upload helper
function uploadPhoto($fileInputName, $upload_dir, $oldFile = null)
{
    if (!empty($_FILES[$fileInputName]['name'])) {
        $filename = time() . "_" . basename($_FILES[$fileInputName]['name']);
        $target = $upload_dir . $filename;

        if (move_uploaded_file($_FILES[$fileInputName]['tmp_name'], $target)) {
            // Optional: delete old file
            if ($oldFile && file_exists($upload_dir . $oldFile)) {
                unlink($upload_dir . $oldFile);
            }
            return $filename;
        } else {
            error_log("Upload failed for $fileInputName: " . $_FILES[$fileInputName]['error']);
        }
    }
    // No new upload, keep old file
    return $oldFile;
}

// Assuming you pass old file names from hidden inputs in the form
$photo1 = uploadPhoto('photo1', $upload_dir, $_POST['old_photo1'] ?? null);
$photo2 = uploadPhoto('photo2', $upload_dir, $_POST['old_photo2'] ?? null);
$photo3 = uploadPhoto('photo3', $upload_dir, $_POST['old_photo3'] ?? null);
$photo4 = uploadPhoto('photo4', $upload_dir, $_POST['old_photo4'] ?? null);



    $sql = "UPDATE stability_date_forms 
            SET company_id=?, factory_address=?, village=?, town=?,
                district=?, factory_occupier_name=?,
                manufacturing_process=?, number_of_floors=?,
        ref_number_1=?, date1=?, ref_number_2=?, date2=?,
        competence_structural_eng=?, structural_eng_name=?,
        inspection_date=?, issue_stability_person=?, drawings=?,
        building_mentioning_no_disc=?, general_condition=?,
        building_maintainance_history=?, loading_usage=?,
        original_purpose=?, phase_wise_details=?,
        structural_member_accidents=?, addition_alteration=?,
        env_detriments=?, next_inspection=?, long_term_strength=?,
        photo1=?, photo2=?, photo3=?, photo4=?
            WHERE id=?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param(
        "isssssssssssssssssssssssssssssssi",
    $company_id,
    $factory_address,
    $village,
    $town,
    $district,
    $factory_occupier_name,
    $manufacturing_process,
    $number_of_floors,
    $ref_number_1,
    $date1,
    $ref_number_2,
    $date2,
    $competence_structural_eng,
    $structural_eng_name,
    $inspection_date,
    $issue_stability_person,
    $drawings,
    $building_mentioning_no_disc,
    $general_condition,
    $building_maintainance_history,
    $loading_usage,
    $original_purpose,
    $phase_wise_details,
    $structural_member_accidents,
    $addition_alteration,
    $env_detriments,
    $next_inspection,
    $long_term_strength,
    $photo1,
    $photo2,
    $photo3,
    $photo4,
    $id
    );

    if ($stmt->execute()) {
        $_SESSION['success_message'] = "Stability Date form updated successfully!";
        header("Location: stability_date_list.php");
        exit;
    } else {
        $error_message = "Error: " . $stmt->error;
    }
    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Axle_Services</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
<!-- <link rel="stylesheet" href="css/style.css" /> -->
<link rel="stylesheet" href="css/header.css" />
<link rel="stylesheet" href="css/sidebar.css" />
<style>
  body {
    background: #f9fafb;
    
    color: #333;
    min-height: 100vh;
  }

  .main-content {
    margin-top: 70px;
    margin-left: 250px;
    padding: 30px 40px;
    transition: all 0.3s ease;
    min-height: calc(100vh - 70px);
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 8px 24px rgb(0 0 0 / 0.05);
  }

  @media (max-width: 991.98px) {
    .main-content {
      margin-left: 0;
      padding: 20px;
      border-radius: 0;
      box-shadow: none;
    }
  }

  .page-header {
    background-color: #0d6efd;
    color: #fff;
    padding: 20px 25px;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgb(13 110 253 / 0.3);
    margin-bottom: 30px;
    text-align: center;
    font-weight: 600;
    font-size: 1.8rem;
    letter-spacing: 0.03em;
  }

  form {
    max-width: 900px;
    margin: 0 auto;
  }

  label.form-label {
    font-weight: 600;
    color: #495057;
  }

  input.form-control,
  select.form-select,
  textarea.form-control {
    border-radius: 8px;
    border: 1.5px solid #ced4da;
    padding: 10px 14px;
    font-size: 1rem;
    transition: border-color 0.3s ease, box-shadow 0.3s ease;
  }

  input.form-control:focus,
  select.form-select:focus,
  textarea.form-control:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 8px rgb(13 110 253 / 0.25);
    outline: none;
  }

  textarea.form-control {
    min-height: 80px;
    resize: vertical;
  }

  h6 {
    font-weight: 400;
    color: #0d6efd;
    margin-top: 40px;
    margin-bottom: 20px;
    border-bottom: 2px solid #0d6efd;
    padding-bottom: 6px;
  }

  .btn-success {
    background-color: #198754;
    border-color: #198754;
    font-weight: 600;
    font-size: 1.1rem;
    padding: 12px 40px;
    border-radius: 50px;
    transition: background-color 0.3s ease, box-shadow 0.3s ease;
  }

  .btn-success:hover {
    background-color: #157347;
    box-shadow: 0 6px 15px rgb(21 115 71 / 0.4);
  }

  .alert {
    max-width: 900px;
    margin: 0 auto 30px auto;
    border-radius: 10px;
    font-weight: 600;
    font-size: 1rem;
  }

    .form-step {
      display: none;
    }

    .form-step.active {
      display: block;
    }
  @media (max-width: 575.98px) {
    form .col-md-6,
    form .col-md-4,
    form .col-12 {
      flex: 0 0 100% !important;
      max-width: 100% !important;
    }
  }
</style>
</head>
<body>
<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>

<div class="main-content">
  <div class="page-header">Edit Stability Date Form</div>

  <?php if ($error_message): ?>
    <div class="alert alert-danger"><?= htmlspecialchars($error_message) ?></div>
  <?php endif; ?>
  <?php if (isset($_SESSION['success_message'])): ?>
    <div class="alert alert-success"><?= htmlspecialchars($_SESSION['success_message']) ?></div>
    <?php unset($_SESSION['success_message']); ?>
  <?php endif; ?>

  <form method="POST" enctype="multipart/form-data" class="row g-4 ">
    <div class="form-step active">
<div class="row align-items-center mb-3">
          <div class="col-md-6">
            <label class="form-label mb-0">Refference Number </label>
          </div>
          <div class="col-md-6">
            <div class="form-check me-3">
              <input type="text" class="form-control" name="ref_number_1" value="<?= htmlspecialchars($form['ref_number_1']) ?>" readonly>
            </div>
          </div>
        </div>
    <!-- Company -->
    <div class="row mb-3 mt-3">
      <div class="col-md-4"><label class="form-label">1. Name of factory</label></div>
      <div class="col-md-8">
        <?php
          $companyName = $conn->query("SELECT name FROM companies WHERE id=".(int)$form['company_id'])->fetch_assoc();
        ?>
        <input type="text" class="form-control" value="<?= htmlspecialchars($companyName['name'] ?? '') ?>" readonly>
        <input type="hidden" name="company_id" value="<?= htmlspecialchars($form['company_id']) ?>">
      </div>
    </div>

    <!-- Factory Address -->
    <div class="row mb-3">
      <div class="col-md-4"><label class="form-label">2. Address of factory</label></div>
      <div class="col-md-8">
        <input type="text" class="form-control" name="factory_address" value="<?= htmlspecialchars($form['factory_address']) ?>">
      </div>
    </div>

    <!-- Equipment Name -->
    <div class="row mb-3">
      <div class="col-md-4"><label class="form-label">3.Village</label></div>
      <div class="col-md-8">
        <input type="text" class="form-control" name="village" value="<?= htmlspecialchars($form['village']) ?>">
      </div>
    </div>

    <div class="row mb-3">
      <div class="col-md-4"><label class="form-label">Town</label></div>
      <div class="col-md-8">
        <textarea class="form-control" name="town"><?= htmlspecialchars($form['town']) ?></textarea>
      </div>
    </div>

    <div class="row mb-3">
      <div class="col-md-4"><label class="form-label">District</label></div>
      <div class="col-md-8">
        <input type="text" class="form-control" name="district" value="<?= htmlspecialchars($form['district']) ?>">
      </div>
    </div>

    <div class="row mb-3">
      <div class="col-md-3"><label class="form-label">4.Name of the occupier of the factory</label></div>
      <div class="col-md-9">
        <input type="text" class="form-control" name="factory_occupier_name" value="<?= htmlspecialchars($form['factory_occupier_name']) ?>">
      </div>
    </div>
  <div class="row mb-3">
      <div class="col-md-3"><label class="form-label">5.Nature of Manufacturing Process to be carried out in the factory</label></div>
      <div class="col-md-9">
        <input type="text" class="form-control" name="manufacturing_process" value="<?= htmlspecialchars($form['manufacturing_process']) ?>">
      </div>
    </div>
     <div class="row mb-3">
      <div class="col-md-3"><label class="form-label">6.Number of Floors on which worker will be employed</label></div>
      <div class="col-md-9">
        <input type="text" class="form-control" name="number_of_floors" value="<?= htmlspecialchars($form['number_of_floors']) ?>">
      </div>
    </div>
    
         <div class="row align-items-center mb-3">
          <div class="col-md-6">
            <label class="form-label mb-0">Date </label>
          </div>
          <div class="col-md-4">
            <div class="form-check me-3">
              <input type="date" class="form-control" name="date1" id="date1" value="<?= htmlspecialchars($form['date1']) ?>">
            </div>
          </div>
        </div>
         <!-- <div class="row align-items-center mb-3">
          <div class="col-md-6">
            <label class="form-label mb-0">7. Refference No. 2</label>
          </div>
          <div class="col-md-6">
            <div class="form-check me-3">
              <input type="text" class="form-control" name="ref_number_2" value="<?= htmlspecialchars($form['ref_number_2']) ?>">
            </div>
          </div>
        </div> -->
         <!-- <div class="row align-items-center mb-3">
          <div class="col-md-6">
            <label class="form-label mb-0">Date</label>
          </div>
          <div class="col-md-4">
            <div class="form-check me-3">
              <input type="date" class="form-control" name="date2" value="<?= htmlspecialchars($form['date2']); ?>">
            </div>
          </div>
        </div> -->

        <div class="col-12 text-center mt-4">
          <button type="button" class="btn btn-primary px-5 next-step">Next</button>
        </div>
      </div>
    <!-- STEP 2 -->
      <div class="form-step">

        <div class="row align-items-center mb-3">
          <div class="col-md-6">
            <label class="form-label" >COMPETENCE OF STRUCTURAL ENGINEER<br> He should be a member of Institution of Engineers.
            </label>
          </div>
          <div class="col-md-6">
            <textarea class="form-control" name="competence_structural_eng"><?=htmlspecialchars($form['competence_structural_eng']) ?></textarea>
          </div>
        </div>
        <div class="row align-items-center mb-3">
          <div class="col-md-6">
            <label class="form-label" for="structural_eng_name">0.1 .Name of Structural Engineer Inspecting the building. </label>
          </div>
          <div class="col-md-6">
               <textarea class="form-control" name="structural_eng_name"><?= htmlspecialchars($form['structural_eng_name']) ?></textarea>
          </div>
        </div>
        <div class="row align-items-center mb-3">
          <div class="col-md-6">
            <label class="form-label" for="inspection_date">0.2 Date of Inspection
            </label>
          </div>
          <div class="col-md-4">
            <input type="date" class="form-control" name="inspection_date" value="<?=htmlspecialchars($form['inspection_date']) ?>" />
          </div>
        </div>
        <div class="row align-items-center mb-3">
          <div class="col-md-6">
            <label class="form-label" for="issue_stability_person">0.3 Name of person issuing stability certificate
            </label>
          </div>
          <div class="col-md-6">
            <textarea class="form-control" name="issue_stability_person"><?=htmlspecialchars($form['issue_stability_person']) ?></textarea>
          </div>
        </div>
        <div class="col-12">
          <h6>1.0 DESCRIPTION OF THE BUILDING</h6>
        </div>
        <div class="row align-items-center mb-3">
          <div class="col-md-6">
            <label class="form-label" for="drawings">1.1 Set of Architectural and Structural Drawings Viz. plans, elevations sections details of M/c layout etc. copies to be studied by the Structural Engineer
            </label>
          </div>
          <div class="col-md-6">
            <textarea class="form-control" name="drawings"><?=htmlspecialchars($form['drawings']) ?></textarea>
          </div>
        </div>

        <div class="row align-items-center mb-3">
          <div class="col-md-6">
            <label class="form-label" for="building_mentioning_no_disc">1.2 General description of the building mentioning number of buildings, number of stories, year of construction (if known) otherwise as per the judgment, type of structural such as load bearing, framed, composite etc. and materials of construction paintings coatings, type of joints etc.,
            </label>
          </div>
          <div class="col-md-6">
            <textarea class="form-control" name="building_mentioning_no_disc"><?=htmlspecialchars($form['building_mentioning_no_disc']) ?></textarea>
          </div>
        </div>
        <div class="row align-items-center mb-3">
          <div class="col-md-6">
            <label class="form-label" for="general_condition">1.3 General condition of the building and signs of weakness of functional interruptions, vibrations, cracks deflections, joints yielding etc., leakages correction, clarify the buildings overall condition as excellent good satisfactory, unsatisfactory
            </label>
          </div>
          <div class="col-md-6">
            <textarea class="form-control" name="general_condition"><?=htmlspecialchars($form['general_condition']) ?></textarea>
          </div>
        </div>
        <div class="row align-items-center mb-3">
          <div class="col-md-6">
            <label class="form-label" for="building_maintainance_history">1.4 History on Maintenance of the buildings covering details on internal and external painting, replastering, grouting, gunniting, strengthening, additions, alternations, water proofing modifications to Air-conditioning piping, false ceiling, partions etc., Any welding to the reinforcement of RCC members by exposing it for the purpose of providing anchorage, mezzanine floors etc.
            </label>
          </div>
          <div class="col-md-6">
            <textarea class="form-control" name="building_maintainance_history"><?=htmlspecialchars($form['building_maintainance_history']) ?></textarea>
          </div>
        </div>
        <div class="col-12">
          <h6>2.0 AGEING AND OVER LOADING : </h6>
        </div>
        <div class="row align-items-center mb-3">
          <div class="col-md-6">
            <label class="form-label" for="loading_usage">2.1 Usage
            </label>
          </div>
          <div class="col-md-6">
            <textarea class="form-control" name="loading_usage"><?=htmlspecialchars($form['loading_usage']) ?></textarea>
          </div>
        </div>
        <div class="row align-items-center mb-3">
          <div class="col-md-6">
            <label class="form-label" for="original_purpose">2.2 Original purpose: Changes if any to be fully checked for adequacy in strength of supporting structural system from the point of stable loading as well as vibration levels if any
            </label>
          </div>
          <div class="col-md-6">
            <textarea class="form-control" name="original_purpose"><?=htmlspecialchars($form['original_purpose']) ?></textarea>
          </div>
        </div>
        <div class="row align-items-center mb-3">
          <div class="col-md-6">
            <label class="form-label" for="phase_wise_details">2.3 Phase wise construction and installation details
            </label>
          </div>
          <div class="col-md-6">
            <textarea class="form-control" name="phase_wise_details" ><?=htmlspecialchars($form['phase_wise_details']) ?></textarea>
          </div>
        </div>
        <div class="col-12">
          <h6>2.4 Logbook of Building Inspection </h6>
        </div>
        <div class="row align-items-center mb-3">
          <div class="col-md-6">
            <label class="form-label" for="structural_member_accidents">a.To show Accidents due to failing of plaster, buckling, bending etc., of structural members, giving away of joints fire accidents.
            </label>
          </div>
          <div class="col-md-6">
            <textarea class="form-control" name="structural_member_accidents"><?=htmlspecialchars($form['structural_member_accidents']) ?></textarea>
          </div>
        </div>
        <div class="row align-items-center mb-3">
          <div class="col-md-6">
            <label class="form-label" for="addition_alteration">2.5 Additions/Alteration Upto date additions/Alterations to be incorporated in the drawings each addition to be fully checked for adequacy in strength after providing the allowances to loss of strength due to corrosion, erosion etc.,

            </label>
          </div>
          <div class="col-md-6">
            <textarea class="form-control" name="addition_alteration"><?=htmlspecialchars($form['addition_alteration']) ?></textarea>
          </div>
        </div>
        <div class="row align-items-center mb-3">
          <div class="col-md-6">
            <label class="form-label" for="env_detriments">2.6 Environmental detriments Corrosion of structural steel members
            </label>
          </div>
          <div class="col-md-6">
            <textarea class="form-control" name="env_detriments"><?=htmlspecialchars($form['env_detriments']) ?></textarea>
          </div>
        </div>
        <div class="col-12">
          <h6> 3.0 SAFETY RECOMMENDATIONS : </h6>
        </div>
        <div class="row align-items-center mb-3">
          <div class="col-md-8">
            <label class="form-label" for="next_inspection">3.1 Date of Next Inspection Recommended



            </label>
          </div>
          <div class="col-md-4">
            <textarea class="form-control" name="next_inspection"><?=htmlspecialchars($form['next_inspection']) ?></textarea>
          </div>
        </div>
        <div class="row align-items-center mb-3">
          <div class="col-md-8">
            <label class="form-label" for="long_term_strength">3.2 Recommendations in Long-term strengthening measures whichshould be incorporated within six months
            </label>
          </div>
          <div class="col-md-4">
            <textarea class="form-control" name="long_term_strength"><?=htmlspecialchars($form['long_term_strength']) ?></textarea>
          </div>
        </div>
        <div class="row align-items-center mb-3">
    <div class="col-md-4"><label class="form-label">Upload Photo 1</label></div>
    <div class="col-md-4">
        <?php if (!empty($form['photo1'])): ?>
            <div class="mb-2">
                <img src="uploads/<?= htmlspecialchars($form['photo1']) ?>" alt="Photo 1" style="max-width:150px; border:1px solid #ccc; padding:2px;">
                <!-- <br><small>Current file: <?= htmlspecialchars($form['photo1']) ?></small> -->
            </div>
        <?php endif; ?>
        <input type="file" class="form-control" name="photo1" accept="image/*">
        <input type="hidden" name="old_photo1" value="<?= htmlspecialchars($form['photo1']) ?>">
    </div>
</div>

<div class="row align-items-center mb-3">
    <div class="col-md-4"><label class="form-label">Upload Photo 2</label></div>
    <div class="col-md-4">
        <?php if (!empty($form['photo2'])): ?>
            <div class="mb-2">
                <img src="uploads/<?= htmlspecialchars($form['photo2']) ?>" alt="Photo 2" style="max-width:150px; border:1px solid #ccc; padding:2px;">
                <!-- <br><small>Current file: <?= htmlspecialchars($form['photo2']) ?></small> -->
            </div>
        <?php endif; ?>
        <input type="file" class="form-control" name="photo2" accept="image/*">
        <input type="hidden" name="old_photo2" value="<?= htmlspecialchars($form['photo2']) ?>">
    </div>
</div>

<div class="row align-items-center mb-3">
    <div class="col-md-4"><label class="form-label">Upload Photo 3</label></div>
    <div class="col-md-4">
        <?php if (!empty($form['photo3'])): ?>
            <div class="mb-2">
                <img src="uploads/<?= htmlspecialchars($form['photo3']) ?>" alt="Photo 3" style="max-width:150px; border:1px solid #ccc; padding:2px;">
                <!-- <br><small>Current file: <?= htmlspecialchars($form['photo3']) ?></small> -->
            </div>
        <?php endif; ?>
        <input type="file" class="form-control" name="photo3" accept="image/*">
        <input type="hidden" name="old_photo3" value="<?= htmlspecialchars($form['photo3']) ?>">
    </div>
</div>

<div class="row align-items-center mb-3">
    <div class="col-md-4"><label class="form-label">Upload Photo 4</label></div>
    <div class="col-md-4">
        <?php if (!empty($form['photo4'])): ?>
            <div class="mb-2">
                <img src="uploads/<?= htmlspecialchars($form['photo4']) ?>" alt="Photo 4" style="max-width:150px; border:1px solid #ccc; padding:2px;">
                <!-- <br><small>Current file: <?= htmlspecialchars($form['photo4']) ?></small> -->
            </div>
        <?php endif; ?>
        <input type="file" class="form-control" name="photo4" accept="image/*">
        <input type="hidden" name="old_photo4" value="<?= htmlspecialchars($form['photo4']) ?>">
    </div>
</div>
        <!-- Submit -->
        <div class="col-12 text-center mt-4">
          <button type="button" class="btn btn-success px-5 prev-step">Previous</button>
          <button type="submit" class="btn btn-success px-5">Submit</button>
        </div>
    </form>
</div>
 <script>
    document.querySelectorAll(".next-step").forEach(btn => {
      btn.addEventListener("click", function() {
        let step = this.closest(".form-step");
        step.classList.remove("active");
        step.nextElementSibling.classList.add("active");
      });
    });

    document.querySelectorAll(".prev-step").forEach(btn => {
      btn.addEventListener("click", function() {
        let step = this.closest(".form-step");
        step.classList.remove("active");
        step.previousElementSibling.classList.add("active");
      });
    });
  </script>
<script src="js/script.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
<?php ob_end_flush(); ?>
