<?php
ob_start();
session_start();
require_once "config/db.php";

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$error_message = '';
$success_message = '';
// Fetch existing record
$sql = "SELECT * FROM shot_blasting_forms WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();

// try get_result first
if (method_exists($stmt, 'get_result')) {
    $result = $stmt->get_result();
    $form = $result->fetch_assoc();
} else {
    // fallback if get_result not available
    $meta = $stmt->result_metadata();
    $params = [];
    $row = [];
    while ($field = $meta->fetch_field()) {
        $params[] = &$row[$field->name];
    }
    call_user_func_array([$stmt, 'bind_result'], $params);
    $stmt->fetch();
    $form = $row;
}

$stmt->close();

if (!$form) {
    die("Record not found.");
}

$success_message = '';
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $company_id = !empty($_POST['company_id']) ? (int)$_POST['company_id'] : null;
    $factory_address = trim($_POST['factory_address'] ?? '');
    $equipment_name = trim($_POST['equipment_name'] ?? '');
    $distinguishing_number = trim($_POST['distinguishing_number'] ?? '');
    $blasting_chamber_condition = trim($_POST['blasting_chamber_condition'] ?? '');
    $dust_escape_chamber = $_POST['dust_escape_chamber'] ?? 'No';

    $separation_apparatus_effective = $_POST['separation_apparatus_effective'] ?? 'No';
    $separation_continuous_operation = $_POST['separation_continuous_operation'] ?? 'No';
    $separation_effective_extraction = $_POST['separation_effective_extraction'] ?? 'No';
    $separation_filtration_device = $_POST['separation_filtration_device'] ?? 'No';
    $separation_dust_in_workroom = $_POST['separation_dust_in_workroom'] ?? 'No';
    $separation_leakage_ducting = $_POST['separation_leakage_ducting'] ?? 'No';

    $remarks = trim($_POST['remarks'] ?? '');

    $sql = "UPDATE shot_blasting_forms 
            SET company_id=?, factory_address=?, equipment_name=?, distinguishing_number=?,
                blasting_chamber_condition=?, dust_escape_chamber=?,
                separation_apparatus_effective=?, separation_continuous_operation=?, separation_effective_extraction=?,
                separation_filtration_device=?, separation_dust_in_workroom=?, separation_leakage_ducting=?,
                remarks=?
            WHERE id=?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param(
        "issssssssssssi",
        $company_id,
        $factory_address,
        $equipment_name,
        $distinguishing_number,
        $blasting_chamber_condition,
        $dust_escape_chamber,
        $separation_apparatus_effective,
        $separation_continuous_operation,
        $separation_effective_extraction,
        $separation_filtration_device,
        $separation_dust_in_workroom,
        $separation_leakage_ducting,
        $remarks,
        $id
    );

    if ($stmt->execute()) {
        $_SESSION['success_message'] = "Shot Blasting form updated successfully!";
        header("Location: shot_blasting_list.php");
        exit;
    } else {
        $error_message = "Error: " . $stmt->error;
    }
    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Axle_Services</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
<link rel="stylesheet" href="css/style.css" />
<link rel="stylesheet" href="css/header.css" />
<link rel="stylesheet" href="css/sidebar.css" />
<style>
  body {
    background: #f9fafb;
    
    color: #333;
    min-height: 100vh;
  }

  .main-content {
    margin-top: 70px;
    margin-left: 250px;
    padding: 30px 40px;
    transition: all 0.3s ease;
    min-height: calc(100vh - 70px);
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 8px 24px rgb(0 0 0 / 0.05);
  }

  @media (max-width: 991.98px) {
    .main-content {
      margin-left: 0;
      padding: 20px;
      border-radius: 0;
      box-shadow: none;
    }
  }

  .page-header {
    background-color: #0d6efd;
    color: #fff;
    padding: 20px 25px;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgb(13 110 253 / 0.3);
    margin-bottom: 30px;
    text-align: center;
    font-weight: 600;
    font-size: 1.8rem;
    letter-spacing: 0.03em;
  }

  form {
    max-width: 900px;
    margin: 0 auto;
  }

  label.form-label {
    font-weight: 600;
    color: #495057;
  }

  input.form-control,
  select.form-select,
  textarea.form-control {
    border-radius: 8px;
    border: 1.5px solid #ced4da;
    padding: 10px 14px;
    font-size: 1rem;
    transition: border-color 0.3s ease, box-shadow 0.3s ease;
  }

  input.form-control:focus,
  select.form-select:focus,
  textarea.form-control:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 8px rgb(13 110 253 / 0.25);
    outline: none;
  }

  textarea.form-control {
    min-height: 80px;
    resize: vertical;
  }

  h6 {
    font-weight: 400;
    color: #0d6efd;
    margin-top: 40px;
    margin-bottom: 20px;
    border-bottom: 2px solid #0d6efd;
    padding-bottom: 6px;
  }

  .btn-success {
    background-color: #198754;
    border-color: #198754;
    font-weight: 600;
    font-size: 1.1rem;
    padding: 12px 40px;
    border-radius: 50px;
    transition: background-color 0.3s ease, box-shadow 0.3s ease;
  }

  .btn-success:hover {
    background-color: #157347;
    box-shadow: 0 6px 15px rgb(21 115 71 / 0.4);
  }

  .alert {
    max-width: 900px;
    margin: 0 auto 30px auto;
    border-radius: 10px;
    font-weight: 600;
    font-size: 1rem;
  }

  @media (max-width: 575.98px) {
    form .col-md-6,
    form .col-md-4,
    form .col-12 {
      flex: 0 0 100% !important;
      max-width: 100% !important;
    }
  }
</style>
</head>
<body>
<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>

<div class="main-content">
  <div class="page-header">Edit Shot Blasting Form</div>

  <?php if ($error_message): ?>
    <div class="alert alert-danger"><?= htmlspecialchars($error_message) ?></div>
  <?php endif; ?>
  <?php if (isset($_SESSION['success_message'])): ?>
    <div class="alert alert-success"><?= htmlspecialchars($_SESSION['success_message']) ?></div>
    <?php unset($_SESSION['success_message']); ?>
  <?php endif; ?>

  <form method="POST" class="row g-4">
    <!-- Company -->
    <div class="row mb-3">
      <div class="col-md-4"><label class="form-label">1. Name of occupier of factory</label></div>
      <div class="col-md-8">
        <?php
          $companyName = $conn->query("SELECT name FROM companies WHERE id=".(int)$form['company_id'])->fetch_assoc();
        ?>
        <input type="text" class="form-control" value="<?= htmlspecialchars($companyName['name'] ?? '') ?>" readonly>
        <input type="hidden" name="company_id" value="<?= htmlspecialchars($form['company_id']) ?>">
      </div>
    </div>

    <!-- Factory Address -->
    <div class="row mb-3">
      <div class="col-md-4"><label class="form-label">2. Address of factory</label></div>
      <div class="col-md-8">
        <input type="text" class="form-control" name="factory_address" value="<?= htmlspecialchars($form['factory_address']) ?>">
      </div>
    </div>

    <!-- Equipment Name -->
    <div class="row mb-3">
      <div class="col-md-4"><label class="form-label">Name of Equipment</label></div>
      <div class="col-md-8">
        <input type="text" class="form-control" name="equipment_name" value="<?= htmlspecialchars($form['equipment_name']) ?>">
      </div>
    </div>

    <!-- Distinguishing Number -->
    <div class="row mb-3">
      <div class="col-md-4"><label class="form-label">3. Distinguishing number</label></div>
      <div class="col-md-8">
        <textarea class="form-control" name="distinguishing_number"><?= htmlspecialchars($form['distinguishing_number']) ?></textarea>
      </div>
    </div>

    <!-- Blasting Chamber Condition -->
    <div class="row mb-3">
      <div class="col-md-4"><label class="form-label">4. Blasting chamber condition</label></div>
      <div class="col-md-8">
        <input type="text" class="form-control" name="blasting_chamber_condition" value="<?= htmlspecialchars($form['blasting_chamber_condition']) ?>">
      </div>
    </div>

    <!-- Dust Escape -->
    <div class="row mb-3">
      <div class="col-md-6"><label class="form-label">5. Is dust escaping through chamber?</label></div>
      <div class="col-md-6">
        <input type="radio" name="dust_escape_chamber" value="Yes" <?= $form['dust_escape_chamber']=='Yes'?'checked':'' ?>> Yes
        <input type="radio" name="dust_escape_chamber" value="No" <?= $form['dust_escape_chamber']=='No'?'checked':'' ?>> No
      </div>
    </div>

    <div class="row mb-3">
      <div class="col-md-6"><label class="form-label">6. Separation of dust from abrasive effective?</label></div>
      <div class="col-md-6">
        <input type="radio" name="separation_apparatus_effective" value="Yes" <?= $form['separation_apparatus_effective']=='Yes'?'checked':'' ?>> Yes
        <input type="radio" name="separation_apparatus_effective" value="No" <?= $form['separation_apparatus_effective']=='No'?'checked':'' ?>> No
      </div>
    </div>

    <div class="col-12"><h6>7. Ventilation Plant</h6></div>

    <!-- a) Continuous operation -->
    <div class="row mb-3">
      <div class="col-md-6"><label class="form-label">a) Kept in operation continuously?</label></div>
      <div class="col-md-6">
        <input type="radio" name="separation_continuous_operation" value="Yes" <?= $form['separation_continuous_operation']=='Yes'?'checked':'' ?>> Yes
        <input type="radio" name="separation_continuous_operation" value="No" <?= $form['separation_continuous_operation']=='No'?'checked':'' ?>> No
      </div>
    </div>

    <!-- b) Effective extraction -->
    <div class="row mb-3">
      <div class="col-md-6"><label class="form-label">b) Effective in extracting?</label></div>
      <div class="col-md-6">
        <input type="radio" name="separation_effective_extraction" value="Yes" <?= $form['separation_effective_extraction']=='Yes'?'checked':'' ?>> Yes
        <input type="radio" name="separation_effective_extraction" value="No" <?= $form['separation_effective_extraction']=='No'?'checked':'' ?>> No
      </div>
    </div>

    <!-- c) Filtration device -->
    <div class="row mb-3">
      <div class="col-md-6"><label class="form-label">c) Filtration/settling device satisfactory?</label></div>
      <div class="col-md-6">
        <input type="radio" name="separation_filtration_device" value="Yes" <?= $form['separation_filtration_device']=='Yes'?'checked':'' ?>> Yes
        <input type="radio" name="separation_filtration_device" value="No" <?= $form['separation_filtration_device']=='No'?'checked':'' ?>> No
      </div>
    </div>

    <!-- d) Dust in workroom -->
    <div class="row mb-3">
      <div class="col-md-6"><label class="form-label">d) Dust escaping in workroom?</label></div>
      <div class="col-md-6">
        <input type="radio" name="separation_dust_in_workroom" value="Yes" <?= $form['separation_dust_in_workroom']=='Yes'?'checked':'' ?>> Yes
        <input type="radio" name="separation_dust_in_workroom" value="No" <?= $form['separation_dust_in_workroom']=='No'?'checked':'' ?>> No
      </div>
    </div>

    <!-- e) Leakage from ducting -->
    <div class="row mb-3">
      <div class="col-md-6"><label class="form-label">e) Leakage of dust from ducting?</label></div>
      <div class="col-md-6">
        <input type="radio" name="separation_leakage_ducting" value="Yes" <?= $form['separation_leakage_ducting']=='Yes'?'checked':'' ?>> Yes
        <input type="radio" name="separation_leakage_ducting" value="No" <?= $form['separation_leakage_ducting']=='No'?'checked':'' ?>> No
      </div>
    </div>

    <!-- Remarks -->
    <div class="row mb-3">
      <div class="col-md-3"><label class="form-label">8. Remarks</label></div>
      <div class="col-md-9">
        <input type="text" class="form-control" name="remarks" value="<?= htmlspecialchars($form['remarks']) ?>">
      </div>
    </div>

    <div class="col-12 text-center">
      <button type="submit" class="btn btn-success">Update Form</button>
      <a href="shot_blasting_list.php" class="btn btn-secondary">Cancel</a>
    </div>
  </form>
</div>

<script src="js/script.js"></script>
</body>
</html>
<?php ob_end_flush(); ?>
