<?php
ob_start();
session_start();
require_once "config/db.php";

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$error_message = '';
$success_message = '';
// Fetch existing record from safety_audit_forms
$sql = "SELECT * FROM safety_audit_forms WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);
$stmt->execute();

if (method_exists($stmt, 'get_result')) {
    $result = $stmt->get_result();
    $form = $result->fetch_assoc();
} else {
    $meta = $stmt->result_metadata();
    $params = [];
    $row = [];
    while ($field = $meta->fetch_field()) {
        $params[] = &$row[$field->name];
    }
    call_user_func_array([$stmt, 'bind_result'], $params);
    $stmt->fetch();
    $form = $row;
}
$stmt->close();

if (!$form) {
    die("Record not found.");
}

$success_message = '';
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $company_id      = !empty($_POST['company_id']) ? (int)$_POST['company_id'] : null;
    $factory_address = trim($_POST['factory_address'] ?? '');
    $psn             = trim($_POST['psn'] ?? '');
    $factory_type    = trim($_POST['factory_type'] ?? '');
    $workers_count   = trim($_POST['workers_count'] ?? '');
    $factory_email   = trim($_POST['factory_email'] ?? '');
    $district        = trim($_POST['district'] ?? '');
    $taluka          = trim($_POST['taluka'] ?? '');
    $pincode         = trim($_POST['pincode'] ?? '');
    $occupier_name   = trim($_POST['occupier_name'] ?? '');
    $occupier_mobile = trim($_POST['occupier_mobile'] ?? '');
    $manager_name    = trim($_POST['manager_name'] ?? '');
    $manager_mobile  = trim($_POST['manager_mobile'] ?? '');

    $sql = "UPDATE safety_audit_forms 
            SET company_id=?, factory_address=?, psn=?, factory_type=?, 
                workers_count=?, factory_email=?, district=?, taluka=?, 
                pincode=?, occupier_name=?, occupier_mobile=?, 
                manager_name=?, manager_mobile=? 
            WHERE id=?";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param(
        "issssssssssssi",
        $company_id,
        $factory_address,
        $psn,
        $factory_type,
        $workers_count,
        $factory_email,
        $district,
        $taluka,
        $pincode,
        $occupier_name,
        $occupier_mobile,
        $manager_name,
        $manager_mobile,
        $id
    );

    if ($stmt->execute()) {
        $_SESSION['success_message'] = "Safety Audit form updated successfully!";
        header("Location: safety_audit_list.php");
        exit;
    } else {
        $error_message = "Error updating record: " . $stmt->error;
    }
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Axle_Services</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
<link rel="stylesheet" href="css/style.css" />
<link rel="stylesheet" href="css/header.css" />
<link rel="stylesheet" href="css/sidebar.css" />
<style>
  body {
    background: #f9fafb;
    
    color: #333;
    min-height: 100vh;
  }

  .main-content {
    margin-top: 70px;
    margin-left: 250px;
    padding: 30px 40px;
    transition: all 0.3s ease;
    min-height: calc(100vh - 70px);
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 8px 24px rgb(0 0 0 / 0.05);
  }

  @media (max-width: 991.98px) {
    .main-content {
      margin-left: 0;
      padding: 20px;
      border-radius: 0;
      box-shadow: none;
    }
  }

  .page-header {
    background-color: #0d6efd;
    color: #fff;
    padding: 20px 25px;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgb(13 110 253 / 0.3);
    margin-bottom: 30px;
    text-align: center;
    font-weight: 600;
    font-size: 1.8rem;
    letter-spacing: 0.03em;
  }

  form {
    max-width: 900px;
    margin: 0 auto;
  }

  label.form-label {
    font-weight: 600;
    color: #495057;
  }

  input.form-control,
  select.form-select,
  textarea.form-control {
    border-radius: 8px;
    border: 1.5px solid #ced4da;
    padding: 10px 14px;
    font-size: 1rem;
    transition: border-color 0.3s ease, box-shadow 0.3s ease;
  }

  input.form-control:focus,
  select.form-select:focus,
  textarea.form-control:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 8px rgb(13 110 253 / 0.25);
    outline: none;
  }

  textarea.form-control {
    min-height: 80px;
    resize: vertical;
  }

  h6 {
    font-weight: 400;
    color: #0d6efd;
    margin-top: 40px;
    margin-bottom: 20px;
    border-bottom: 2px solid #0d6efd;
    padding-bottom: 6px;
  }

  .btn-success {
    background-color: #198754;
    border-color: #198754;
    font-weight: 600;
    font-size: 1.1rem;
    padding: 12px 40px;
    border-radius: 50px;
    transition: background-color 0.3s ease, box-shadow 0.3s ease;
  }

  .btn-success:hover {
    background-color: #157347;
    box-shadow: 0 6px 15px rgb(21 115 71 / 0.4);
  }

  .alert {
    max-width: 900px;
    margin: 0 auto 30px auto;
    border-radius: 10px;
    font-weight: 600;
    font-size: 1rem;
  }

  @media (max-width: 575.98px) {
    form .col-md-6,
    form .col-md-4,
    form .col-12 {
      flex: 0 0 100% !important;
      max-width: 100% !important;
    }
  }
</style>
</head>
<body>
<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>

<div class="main-content">
  <div class="page-header">Edit Shot Blasting Form</div>

  <?php if ($error_message): ?>
    <div class="alert alert-danger"><?= htmlspecialchars($error_message) ?></div>
  <?php endif; ?>
  <?php if (isset($_SESSION['success_message'])): ?>
    <div class="alert alert-success"><?= htmlspecialchars($_SESSION['success_message']) ?></div>
    <?php unset($_SESSION['success_message']); ?>
  <?php endif; ?>

  <form method="POST" class="row g-4">
    <!-- Company -->
    <div class="row mb-3">
      <div class="col-md-4"><label class="form-label">1. Name of factory</label></div>
      <div class="col-md-8">
        <?php
          $companyName = $conn->query("SELECT name FROM companies WHERE id=".(int)$form['company_id'])->fetch_assoc();
        ?>
        <input type="text" class="form-control" value="<?= htmlspecialchars($companyName['name'] ?? '') ?>" readonly>
        <input type="hidden" name="company_id" value="<?= htmlspecialchars($form['company_id']) ?>">
      </div>
    </div>

    <!-- Factory Address -->
    <div class="row mb-3">
      <div class="col-md-4"><label class="form-label">2. Address of factory</label></div>
      <div class="col-md-8">
        <input type="text" class="form-control" name="factory_address" value="<?= htmlspecialchars($form['factory_address']) ?>">
      </div>
    </div>

    <!-- PSN -->
<div class="row mb-3">
  <div class="col-md-4"><label class="form-label">PSN</label></div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="psn" value="<?= htmlspecialchars($form['psn']) ?>">
  </div>
</div>

<!-- Factory Type -->
<div class="row mb-3">
  <div class="col-md-4"><label class="form-label">Factory Type</label></div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="factory_type" value="<?= htmlspecialchars($form['factory_type']) ?>">
  </div>
</div>

<!-- Workers Count -->
<div class="row mb-3">
  <div class="col-md-4"><label class="form-label">Number of Workers</label></div>
  <div class="col-md-8">
    <input type="number" class="form-control" name="workers_count" value="<?= htmlspecialchars($form['workers_count']) ?>">
  </div>
</div>

<!-- Factory Email -->
<div class="row mb-3">
  <div class="col-md-4"><label class="form-label">Factory Email</label></div>
  <div class="col-md-8">
    <input type="email" class="form-control" name="factory_email" value="<?= htmlspecialchars($form['factory_email']) ?>">
  </div>
</div>

<!-- District -->
<div class="row mb-3">
  <div class="col-md-4"><label class="form-label">District</label></div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="district" value="<?= htmlspecialchars($form['district']) ?>">
  </div>
</div>

<!-- Taluka -->
<div class="row mb-3">
  <div class="col-md-4"><label class="form-label">Taluka</label></div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="taluka" value="<?= htmlspecialchars($form['taluka']) ?>">
  </div>
</div>

<!-- Pincode -->
<div class="row mb-3">
  <div class="col-md-4"><label class="form-label">Pincode</label></div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="pincode" value="<?= htmlspecialchars($form['pincode']) ?>">
  </div>
</div>

<!-- Occupier Name -->
<div class="row mb-3">
  <div class="col-md-4"><label class="form-label">Occupier Name</label></div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="occupier_name" value="<?= htmlspecialchars($form['occupier_name']) ?>">
  </div>
</div>

<!-- Occupier Mobile -->
<div class="row mb-3">
  <div class="col-md-4"><label class="form-label">Occupier Mobile</label></div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="occupier_mobile" value="<?= htmlspecialchars($form['occupier_mobile']) ?>">
  </div>
</div>

<!-- Manager Name -->
<div class="row mb-3">
  <div class="col-md-4"><label class="form-label">Manager Name</label></div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="manager_name" value="<?= htmlspecialchars($form['manager_name']) ?>">
  </div>
</div>

<!-- Manager Mobile -->
<div class="row mb-3">
  <div class="col-md-4"><label class="form-label">Manager Mobile</label></div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="manager_mobile" value="<?= htmlspecialchars($form['manager_mobile']) ?>">
  </div>
</div>

    <div class="col-12 text-center">
      <button type="submit" class="btn btn-success">Update</button>
    </div>
  </form>
</div>

<script src="js/script.js"></script>
</body>
</html>
<?php ob_end_flush(); ?>
