<?php
ob_start();
session_start();
require_once "config/db.php";

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

// Get the ID to edit
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: form_13_list.php");
    exit;
}
$id = intval($_GET['id']);
$error_message = '';
$success_message = '';
// Fetch record (without get_result)
$stmt = $conn->prepare("SELECT * FROM form13 WHERE id = ?");
if (!$stmt) {
    die("Prepare failed: " . $conn->error);
}
$stmt->bind_param("i", $id);
$stmt->execute();
$meta = $stmt->result_metadata();
$fields = [];
$row = [];
while ($field = $meta->fetch_field()) {
    $fields[] = &$row[$field->name];
}
call_user_func_array([$stmt, 'bind_result'], $fields);

if ($stmt->fetch()) {
    $form13 = $row;
} else {
    $form13 = null;
}

$stmt->close();

if (!$form13) {
    header("Location: form_13_list.php?msg=notfound");
    exit;
}

// Fetch companies for dropdown
$companies = $conn->query("SELECT id, name FROM companies ORDER BY name ASC");

$success_message = '';
$error_message = '';

// Handle update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $company_id = !empty($_POST['company_id']) ? (int)$_POST['company_id'] : null;
    $factory_address = trim($_POST['factory_address'] ?? '');
    $equipment_name = trim($_POST['equipment_name'] ?? '');
    $pressure_plant_name = trim($_POST['pressure_plant_name'] ?? '');
    $maker_name = trim($_POST['maker_name'] ?? '');
    $nature_of_process = trim($_POST['nature_of_process'] ?? '');
    $date_of_construction = nullIfEmpty($_POST['date_of_construction'] ?? '');
    $thickness_of_wall = trim($_POST['thickness_of_wall'] ?? '');
    $date_first_use = nullIfEmpty($_POST['date_first_use'] ?? '');
    $safe_working_pressure = trim($_POST['safe_working_pressure'] ?? '');
    $part_of_gas_holdes = trim($_POST['part_of_gas_holdes'] ?? '');
    $crown = trim($_POST['crown'] ?? '');
    $side_sheeting = trim($_POST['side_sheeting'] ?? '');
    $guiding_mechanism = trim($_POST['guiding_mechanism'] ?? '');
    $tank = trim($_POST['tank'] ?? '');
    $other_structure = trim($_POST['other_structure'] ?? '');
    $lift_position = trim($_POST['lift_position'] ?? '');
    $tank_lift_perticulars = trim($_POST['tank_lift_perticulars'] ?? '');
    $date_of_external_exam = nullIfEmpty($_POST['date_of_external_exam'] ?? '');
    $date_of_internal_exam = nullIfEmpty($_POST['date_of_internal_exam'] ?? '');
    $date_of_hydraulic_exam = nullIfEmpty($_POST['date_of_hydraulic_exam'] ?? '');
    $ultrasonic_test_date = nullIfEmpty($_POST['ultrasonic_test_date'] ?? '');
    $by_whom = trim($_POST['by_whom'] ?? '');
    $removed_login = trim($_POST['removed_login'] ?? '');
    $external_examination = trim($_POST['external_examination'] ?? '');
    $internal_examination = trim($_POST['internal_examination'] ?? '');
    $hydraulic_test = trim($_POST['hydraulic_test'] ?? '');
    $altrasonic_test = trim($_POST['altrasonic_test'] ?? '');
    $safe_working_pressure1 = trim($_POST['safe_working_pressure1'] ?? '');
    $safe_working_pressure2 = trim($_POST['safe_working_pressure2'] ?? '');
    $safe_working_pressure3 = trim($_POST['safe_working_pressure3'] ?? '');
    $vessel = trim($_POST['vessel'] ?? '');
    $piping = trim($_POST['piping'] ?? '');
    $pressure_gauges = trim($_POST['pressure_gauges'] ?? '');
    $safety_valve = trim($_POST['safety_valve'] ?? '');
    $stop_valve = trim($_POST['stop_valve'] ?? '');
    $reducing_valve = trim($_POST['reducing_valve'] ?? '');
    $additional_safety_valve = trim($_POST['additional_safety_valve'] ?? '');
    $other_devices = trim($_POST['other_devices'] ?? '');
    $maintenance_status = trim($_POST['maintenance_status'] ?? '');
    $working_pressure_after_examination = trim($_POST['working_pressure_after_examination'] ?? '');
    $repairs = trim($_POST['repairs'] ?? '');
    $working_pressure_repairs = trim($_POST['working_pressure_repairs'] ?? '');
    $observation = trim($_POST['observation'] ?? '');

    $sql = "UPDATE form13 SET 
        company_id=?, factory_address=?, equipment_name=?, pressure_plant_name=?, maker_name=?, nature_of_process=?, 
        date_of_construction=?, thickness_of_wall=?, date_first_use=?, safe_working_pressure=?, part_of_gas_holdes=?, 
        crown=?, side_sheeting=?, guiding_mechanism=?, tank=?, other_structure=?, lift_position=?, tank_lift_perticulars=?, 
        date_of_external_exam=?, date_of_internal_exam=?, date_of_hydraulic_exam=?, ultrasonic_test_date=?, 
        by_whom=?, removed_login=?, external_examination=?, internal_examination=?, hydraulic_test=?, altrasonic_test=?, 
        safe_working_pressure1=?, safe_working_pressure2=?, safe_working_pressure3=?, 
        vessel=?, piping=?, pressure_gauges=?, safety_valve=?, stop_valve=?, reducing_valve=?, 
        additional_safety_valve=?, other_devices=?, maintenance_status=?, working_pressure_after_examination=?, 
        repairs=?, working_pressure_repairs=?, observation=? 
        WHERE id=?";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param(
        "issssssssssssssssssssssssssssssssssssssssssss",
        $company_id, $factory_address, $equipment_name, $pressure_plant_name, $maker_name, $nature_of_process,
        $date_of_construction, $thickness_of_wall, $date_first_use, $safe_working_pressure, $part_of_gas_holdes,
        $crown, $side_sheeting, $guiding_mechanism, $tank, $other_structure, $lift_position, $tank_lift_perticulars,
        $date_of_external_exam, $date_of_internal_exam, $date_of_hydraulic_exam, $ultrasonic_test_date,
        $by_whom, $removed_login, $external_examination, $internal_examination, $hydraulic_test, $altrasonic_test,
        $safe_working_pressure1, $safe_working_pressure2, $safe_working_pressure3,
        $vessel, $piping, $pressure_gauges, $safety_valve, $stop_valve, $reducing_valve,
        $additional_safety_valve, $other_devices, $maintenance_status, $working_pressure_after_examination,
        $repairs, $working_pressure_repairs, $observation,
        $id
    );

    if ($stmt->execute()) {
        $_SESSION['success_message'] = "Form 13 updated successfully!";
        header("Location: form_13_list.php");
        exit;
    } else {
        $error_message = "Error: " . $stmt->error;
    }
    $stmt->close();
}

function nullIfEmpty($value) {
    return (!empty($value) && $value !== '') ? $value : null;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Axle_Services</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="css/header.css">
<link rel="stylesheet" href="css/sidebar.css">
<link rel="stylesheet" href="css/style.css">
<style>
  body {
    background: #f9fafb;
    
    color: #333;
    min-height: 100vh;
  }

  .main-content {
    margin-top: 70px;
    margin-left: 250px;
    padding: 30px 40px;
    transition: all 0.3s ease;
    min-height: calc(100vh - 70px);
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 8px 24px rgb(0 0 0 / 0.05);
  }

  @media (max-width: 991.98px) {
    .main-content {
      margin-left: 0;
      padding: 20px;
      border-radius: 0;
      box-shadow: none;
    }
  }

  .page-header {
    background-color: #0d6efd;
    color: #fff;
    padding: 20px 25px;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgb(13 110 253 / 0.3);
    margin-bottom: 30px;
    text-align: center;
    font-weight: 600;
    font-size: 1.8rem;
    letter-spacing: 0.03em;
  }

  form {
    max-width: 900px;
    margin: 0 auto;
  }

  label.form-label {
    font-weight: 600;
    color: #495057;
  }

  input.form-control,
  select.form-select,
  textarea.form-control {
    border-radius: 8px;
    border: 1.5px solid #ced4da;
    padding: 10px 14px;
    font-size: 1rem;
    transition: border-color 0.3s ease, box-shadow 0.3s ease;
  }

  input.form-control:focus,
  select.form-select:focus,
  textarea.form-control:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 8px rgb(13 110 253 / 0.25);
    outline: none;
  }

  textarea.form-control {
    min-height: 80px;
    resize: vertical;
  }

  h6 {
    font-weight: 400;
    color: #0d6efd;
    margin-top: 40px;
    margin-bottom: 20px;
    border-bottom: 2px solid #0d6efd;
    padding-bottom: 6px;
  }

  .btn-success {
    background-color: #198754;
    border-color: #198754;
    font-weight: 600;
    font-size: 1.1rem;
    padding: 12px 40px;
    border-radius: 50px;
    transition: background-color 0.3s ease, box-shadow 0.3s ease;
  }

  .btn-success:hover {
    background-color: #157347;
    box-shadow: 0 6px 15px rgb(21 115 71 / 0.4);
  }

  .alert {
    max-width: 900px;
    margin: 0 auto 30px auto;
    border-radius: 10px;
    font-weight: 600;
    font-size: 1rem;
  }

  @media (max-width: 575.98px) {
    form .col-md-6,
    form .col-md-4,
    form .col-12 {
      flex: 0 0 100% !important;
      max-width: 100% !important;
    }
  }
</style>
</head>
<body>
<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>

<div class="main-content">
    <div class="page-header">Edit Form 13</div>

    <?php if ($error_message): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error_message) ?></div>
    <?php endif; ?>
    <?php if (isset($_SESSION['success_message'])): ?>
        <div class="alert alert-success"><?= htmlspecialchars($_SESSION['success_message']) ?></div>
        <?php unset($_SESSION['success_message']); ?>
    <?php endif; ?>

    <form method="POST" class="row g-4">


        <!-- Company -->
       <div class="row mb-3 mt-3">
    <div class="col-md-4">
        <label class="form-label">1. Name of the Occupier</label>
    </div>
    <div class="col-md-8">
        <input type="text" class="form-control" 
               value="<?php 
                   $companyName = $conn->query(
                       "SELECT name FROM companies WHERE id=".(int)$form13['company_id']
                   )->fetch_assoc();
                   echo htmlspecialchars($companyName['name'] ?? '');
               ?>" 
               readonly>
        <!-- hidden field to actually submit the ID -->
        <input type="hidden" name="company_id" value="<?= htmlspecialchars($form13['company_id']) ?>">
    </div>
</div>


<!-- Factory Address -->
<div class="row mb-3">
    <div class="col-md-4"><label class="form-label">2. Name & Address of the Factory</label></div>
    <div class="col-md-8">
        <input type="text" class="form-control" 
               value="<?= htmlspecialchars($form13['factory_address']) ?>" 
               readonly>
    </div>
</div>

        <!-- Equipment Name -->
        <div class="row mb-3">
            <div class="col-md-4"><label class="form-label">3. Name of Equipment</label></div>
            <div class="col-md-8">
                <input type="text" class="form-control" name="equipment_name" value="<?= htmlspecialchars($form13['equipment_name']) ?>">
            </div>
        </div>

        <div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="pressurePlantName">
      2. Name, description and distinctive number of the pressure plant/vessel
    </label>
  </div>
  <div class="col-md-6">
    <textarea class="form-control" name="pressure_plant_name" id="pressurePlantName"><?= htmlspecialchars($form13['pressure_plant_name']) ?></textarea>
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="makerName">3. Name and address of maker</label>
  </div>
  <div class="col-md-8">
    <textarea class="form-control" name="maker_name" id="makerName"><?= htmlspecialchars($form13['maker_name']) ?></textarea>
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-5">
    <label class="form-label" for="natureOfProcess">4. Nature of process in which it is used</label>
  </div>
  <div class="col-md-7">
    <input type="text" class="form-control" name="nature_of_process" id="natureOfProcess" 
           value="<?= htmlspecialchars($form13['nature_of_process']) ?>" />
  </div>
</div>

<div class="col-12"><h6>5. Particulars of plant/Vessel</h6></div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="dateOfConstruction">a) Date of Construction</label>
  </div>
  <div class="col-md-4">
    <input type="date" class="form-control" name="date_of_construction" id="dateOfConstruction"
           value="<?= htmlspecialchars($form13['date_of_construction']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="thicknessOfWall">b) Thickness of Walls</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="thickness_of_wall" id="thicknessOfWall"
           value="<?= htmlspecialchars($form13['thickness_of_wall']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="dateFirstUse">c) Date on which it was first taken into use</label>
  </div>
  <div class="col-md-4">
    <input type="date" class="form-control" name="date_first_use" id="dateFirstUse"
           value="<?= htmlspecialchars($form13['date_first_use']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="safeworking">d) Safe working pressure recommended by maker</label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="safe_working_pressure" id="safeworking"
           value="<?= htmlspecialchars($form13['safe_working_pressure']) ?>" />
  </div>
</div>
<div class="col-12"><h6>5. (A) Particulars of Plant/Vessel/Gas holder</h6></div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="partOfGasHolders">
      a) Parts of the gas-holders examined by electronics or other accurate devices 
      or by cutting sample discs and results thereof
    </label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="part_of_gas_holdes" id="partOfGasHolders"
           value="<?= htmlspecialchars($form13['part_of_gas_holdes']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-12">
    <label class="form-label">b) Particulars as to the condition of</label>
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="crown">i) Crown</label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="crown" id="crown"
           value="<?= htmlspecialchars($form13['crown']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="sideSheeting">ii) Side sheeting including grips and cups</label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="side_sheeting" id="sideSheeting"
           value="<?= htmlspecialchars($form13['side_sheeting']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="guidingMechanism">
      iii) Guiding mechanism (roller carriages, rollers, pins, guide ropes, etc.)
    </label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="guiding_mechanism" id="guidingMechanism"
           value="<?= htmlspecialchars($form13['guiding_mechanism']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="tank">iv) Tank</label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="tank" id="tank"
           value="<?= htmlspecialchars($form13['tank']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="otherStructure">
      v) Other structure, if any, columns (framing and bracing)
    </label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="other_structure" id="otherStructure"
           value="<?= htmlspecialchars($form13['other_structure']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="liftPosition">
      c) Particulars as to the position of the lift at the time of examination
    </label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="lift_position" id="liftPosition"
           value="<?= htmlspecialchars($form13['lift_position']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="tankLiftParticulars">
      d) Particulars as to whether the tank and lifts were found sufficiently level for safe working
    </label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="tank_lift_perticulars" id="tankLiftParticulars"
           value="<?= htmlspecialchars($form13['tank_lift_perticulars']) ?>" />
  </div>
</div>
<div class="col-12"><h6>6. Date of</h6></div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="dateOfExternalExam">i) Last external examination</label>
  </div>
  <div class="col-md-4">
    <input type="date" class="form-control" name="date_of_external_exam" id="dateOfExternalExam"
           value="<?= htmlspecialchars($form13['date_of_external_exam']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="dateOfInternalExam">ii) Last internal examination</label>
  </div>
  <div class="col-md-4">
    <input type="date" class="form-control" name="date_of_internal_exam" id="dateOfInternalExam"
           value="<?= htmlspecialchars($form13['date_of_internal_exam']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="dateOfHydraulicExam">iii) Last hydraulic examination</label>
  </div>
  <div class="col-md-4">
    <input type="date" class="form-control" name="date_of_hydraulic_exam" id="dateOfHydraulicExam"
           value="<?= htmlspecialchars($form13['date_of_hydraulic_exam']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="ultrasonicTestDate">iv) Last ultrasonic test</label>
  </div>
  <div class="col-md-4">
    <input type="date" class="form-control" name="ultrasonic_test_date" id="ultrasonicTestDate"
           value="<?= htmlspecialchars($form13['ultrasonic_test_date']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="byWhom">6. (A) By whom it is carried out?</label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="by_whom" id="byWhom"
           value="<?= htmlspecialchars($form13['by_whom']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="removedLogin">
      7. Whether lagging was removed for purposes of examination
    </label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="removed_login" id="removedLogin"
           value="<?= htmlspecialchars($form13['removed_login']) ?>" />
  </div>
</div>

<div class="col-12"><h6>8. Description of examinations carried out and findings</h6></div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="externalExamination">
      i) External examination (give reasons if it is not carried out six monthly)
    </label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="external_examination" id="externalExamination"
           value="<?= htmlspecialchars($form13['external_examination']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="internalExamination">
      ii) Internal examination (give reason if it is not carried out annually)
    </label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="internal_examination" id="internalExamination"
           value="<?= htmlspecialchars($form13['internal_examination']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="hydraulicTest">
      iii) Hydraulic test (Give reason if this is not carried out at interval of 2 years or 4 years)
    </label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="hydraulic_test" id="hydraulicTest"
           value="<?= htmlspecialchars($form13['hydraulic_test']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="altrasonicTest">
      iv) Ultrasonic test (please quote number and date of the certificate issued by Chief Inspector
      permitting ultrasonic test in lieu of internal examination and hydraulic test)
    </label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="altrasonic_test" id="altrasonicTest"
           value="<?= htmlspecialchars($form13['altrasonic_test']) ?>" />
  </div>
</div>
<div class="col-12">
  <h6>9. Safe working pressure calculated as per methods given in the rule 5 (c)(ii) for sizing Cylinder.</h6>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="safeWorkingPressure1">1)</label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="safe_working_pressure1" id="safeWorkingPressure1"
           value="<?= htmlspecialchars($form13['safe_working_pressure1']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="safeWorkingPressure2">2)</label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="safe_working_pressure2" id="safeWorkingPressure2"
           value="<?= htmlspecialchars($form13['safe_working_pressure2']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="safeWorkingPressure3">3)</label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="safe_working_pressure3" id="safeWorkingPressure3"
           value="<?= htmlspecialchars($form13['safe_working_pressure3']) ?>" />
  </div>
</div>

<div class="col-12"><h6>10. Conditions of pressure plant</h6></div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="vessel">a) Vessel</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="vessel" id="vessel"
           value="<?= htmlspecialchars($form13['vessel']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="piping">b) Piping</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="piping" id="piping"
           value="<?= htmlspecialchars($form13['piping']) ?>" />
  </div>
</div>

<div class="col-12"><h6>11. Condition of fitting and appliances</h6></div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="pressureGauges">i) Pressure gauges</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="pressure_gauges" id="pressureGauges"
           value="<?= htmlspecialchars($form13['pressure_gauges']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="safetyValve">ii) Safety valve</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="safety_valve" id="safetyValve"
           value="<?= htmlspecialchars($form13['safety_valve']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-4">
    <label class="form-label" for="stopValve">iii) Stop valve</label>
  </div>
  <div class="col-md-8">
    <input type="text" class="form-control" name="stop_valve" id="stopValve"
           value="<?= htmlspecialchars($form13['stop_valve']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-6">
    <label class="form-label" for="reducingValve">iv) Reducing valve (give reason if not necessary)</label>
  </div>
  <div class="col-md-6">
    <input type="text" class="form-control" name="reducing_valve" id="reducingValve"
           value="<?= htmlspecialchars($form13['reducing_valve']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="additionalSafetyValve">
      v) Additional safety valve (required in case reducing valve is necessary)
    </label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="additional_safety_valve" id="additionalSafetyValve"
           value="<?= htmlspecialchars($form13['additional_safety_valve']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="otherDevices">
      vi) Other devices (please specify particularly in case of jacketed vessels)
    </label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="other_devices" id="otherDevices"
           value="<?= htmlspecialchars($form13['other_devices']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="maintenanceStatus">
      vii) Are all fittings and appliances properly maintained and in good condition, 
      repairs if any required and period within which they should be executed
    </label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="maintenance_status" id="maintenanceStatus"
           value="<?= htmlspecialchars($form13['maintenance_status']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="workingPressureAfterExamination">
      12. Safe working pressure recommended after examination (specify the allowances made for 
      conditions of working such as heat, corrosion etc.)
    </label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="working_pressure_after_examination" id="workingPressureAfterExamination"
           value="<?= htmlspecialchars($form13['working_pressure_after_examination']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="repairs">
      13. Specify repairs if any and period within which they should be executed
    </label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="repairs" id="repairs"
           value="<?= htmlspecialchars($form13['repairs']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="workingPressureRepairs">
      14. Specify reduced working pressure pending repairs
    </label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="working_pressure_repairs" id="workingPressureRepairs"
           value="<?= htmlspecialchars($form13['working_pressure_repairs']) ?>" />
  </div>
</div>

<div class="row align-items-center mb-3">
  <div class="col-md-8">
    <label class="form-label" for="observation">
      15. Other observation/conditions subject to which the plant is to be operated
    </label>
  </div>
  <div class="col-md-4">
    <input type="text" class="form-control" name="observation" id="observation"
           value="<?= htmlspecialchars($form13['observation']) ?>" />
  </div>
</div>


        <div class="col-12 text-center">
            <button type="submit" class="btn btn-success px-5">Update Form</button>
        </div>
    </form>
</div>

<script>
  document.getElementById('companySelect').addEventListener('change', function(){
    var address = this.options[this.selectedIndex].getAttribute('data-address');
    document.getElementById('factoryAddress').value = address || '';
  });
</script>
<script src="/js/script.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php ob_end_flush(); ?>
