<?php
ob_start();
session_start();
require_once "config/db.php";

if(!isset($_SESSION['admin'])){
    header("Location: login.php");
    exit;
}

$error = '';
$success = '';

// Get company ID from URL
if(!isset($_GET['id']) || !is_numeric($_GET['id'])){
    header("Location: company_list.php");
    exit;
}
$id = intval($_GET['id']);

// Fetch existing company
$stmt = $conn->prepare("SELECT * FROM companies WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();

// ---- safe fetch without get_result() ----
$meta = $stmt->result_metadata();
$fields = [];
$row = [];
while ($field = $meta->fetch_field()) {
    $fields[] = &$row[$field->name];
}
call_user_func_array([$stmt, 'bind_result'], $fields);

$company = null;
if ($stmt->fetch()) {
    foreach ($row as $key => $val) {
        $company[$key] = $val;
    }
}
$stmt->close();

if(!$company){
    header("Location: company_list.php");
    exit;
}

// Handle update
if($_SERVER['REQUEST_METHOD'] == 'POST'){
    $name = trim($_POST['name']);
    $contact_person = trim($_POST['contact_person']);
    $email= trim($_POST['email']);
    $address = trim($_POST['address']);
    $company_cert = trim($_POST['company_cert']);
    $other = trim($_POST['other']);
    $phone_number = trim($_POST['phone_number']);

    if($name && $contact_person && $email && $address && $company_cert && $other && $phone_number){
        $stmt = $conn->prepare("UPDATE companies SET 
            name=?, contact_person=?, email=?, address=?, company_cert=?, other=?, phone_number=? 
            WHERE id=?");
        $stmt->bind_param("sssssssi", 
            $name,$contact_person, $email, $address, $company_cert, $other, $phone_number, $id
        );
        
        if($stmt->execute()){
            $success = "Company updated successfully!";
            // Refresh data locally
            $company = [
                "name" => $name,
                 "contact_person" => $contact_person,
                 "email"=> $email,
                "address" => $address,
                "company_cert" => $company_cert,
                "other" => $other,
                "phone_number" => $phone_number
            ];
        } else {
            $error = "Error: ".$conn->error;
        }
    } else {
        $error = "Please fill all required fields (*)";
    }
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Axle_Services</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="css/style.css">
<link rel="stylesheet" href="css/header.css">
<link rel="stylesheet" href="css/sidebar.css">
<style>
  body {
    background: #f9fafb;
    
    color: #333;
    min-height: 100vh;
  }

  .main-content {
    margin-top: 70px;
    margin-left: 250px;
    padding: 30px 40px;
    transition: all 0.3s ease;
    min-height: calc(100vh - 70px);
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 8px 24px rgb(0 0 0 / 0.05);
  }

  @media (max-width: 991.98px) {
    .main-content {
      margin-left: 0;
      padding: 20px;
      border-radius: 0;
      box-shadow: none;
    }
  }

  .page-header {
    background-color: #0d6efd;
    color: #fff;
    padding: 20px 25px;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgb(13 110 253 / 0.3);
    margin-bottom: 30px;
    text-align: center;
    font-weight: 600;
    font-size: 1.8rem;
    letter-spacing: 0.03em;
  }

  label.form-label {
    font-weight: 600;
    color: #495057;
  }

  input.form-control,
  textarea.form-control {
    border-radius: 8px;
    border: 1.5px solid #4a5568;
    padding: 10px 14px;
    font-size: 1rem;
    transition: border-color 0.3s ease, box-shadow 0.3s ease;
  }

  input.form-control:focus,
  textarea.form-control:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 8px rgba(56,178,172,0.4);
    outline: none;
  }

  textarea.form-control {
    min-height: 80px;
    resize: vertical;
  }

  .btn-success {
    background-color: #198754;
    border-color: #198754;
    font-weight: 600;
    font-size: 1.1rem;
    padding: 12px 40px;
    border-radius: 50px;
    transition: background-color 0.3s ease, box-shadow 0.3s ease;
  }

  .btn-success:hover {
    background-color: #157347;
    box-shadow: 0 6px 15px rgba(21,115,71,0.4);
  }

  .alert {
    max-width: 900px;
    margin: 0 auto 30px auto;
    border-radius: 10px;
    font-weight: 600;
    font-size: 1rem;
  }
</style>
</head>
<body>

<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>

<div class="main-content">
  <div class="page-header">Edit Company Details</div>

  <?php if ($error): ?>
    <div class="alert alert-danger shadow-sm"><?= htmlspecialchars($error) ?></div>
  <?php endif; ?>
  <?php if ($success): ?>
    <div class="alert alert-success shadow-sm"><?= htmlspecialchars($success) ?></div>
  <?php endif; ?>

  <form method="POST" class="row g-4" novalidate>
    <div class="col-md-6">
      <label class="form-label">Company Name *</label>
      <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($company['name']); ?>" required>
    </div>
    <div class="col-md-6">
      <label class="form-label">Contact Person *</label>
      <input type="text" name="contact_person" class="form-control" value="<?= htmlspecialchars($company['contact_person']); ?>" required>
    </div>
     <div class="col-md-6">
      <label class="form-label">Email</label>
      <input type="text" name="email" class="form-control" value="<?= htmlspecialchars($company['email']); ?>" required>
    </div>
    <div class="col-md-6">
      <label class="form-label">Phone Number *</label>
      <input type="text" name="phone_number" class="form-control" value="<?= htmlspecialchars($company['phone_number']); ?>" required>
    </div>

    <div class="col-6">
      <label class="form-label">Address *</label>
      <textarea name="address" class="form-control" required><?= htmlspecialchars($company['address']); ?></textarea>
    </div>
    
    <div class="col-md-4">
      <label class="form-label">GST Cert. No.</label>
      <input type="text" name="company_cert" class="form-control" value="<?= htmlspecialchars($company['company_cert']); ?>">
    </div>
   <div class="col-md-4">
      <label class="form-label">Other</label>
      <input type="text" name="other" class="form-control" value="<?= htmlspecialchars($company['other']); ?>">
    </div>
    <div class="col-12 text-center mt-4">
      <button type="submit" class="btn btn-success px-5">Update Company</button>
    </div>
  </form>
</div>

<script src="/js/script.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php ob_end_flush(); ?>