<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

ob_start();
session_start();
if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

require_once "config/db.php";

// --- Dashboard counts ---
$forms = [
    'Form 11' => 'form11',
    'Form 13' => 'form13',
    'Shot Blasting' => 'shot_blasting_forms',
    'Safety Audit' => 'safety_audit_forms',
    'Stability Date' => 'stability_date_forms'
];
$counts = [];

foreach ($forms as $label => $table) {
    $result = $conn->query("SELECT COUNT(*) AS cnt FROM $table");
    if (!$result) {
        die("Query failed for $table: " . $conn->error);
    }
    $row = $result->fetch_assoc();
    $counts[$label] = $row['cnt'];
}

// --- Reminder popup ---
// Today date
$today = date('Y-m-d');

// MPCB: reminder before 4 days
$fourDaysLater = date('Y-m-d', strtotime('+4 days'));

// Other categories: reminder within 2 months
$twoMonthsLater = date('Y-m-d', strtotime('+2 months'));

// Updated SQL:
// If category_name = 'MPCB' → expiry between today and +4 days
// ELSE → expiry between today and +2 months
$sql = "SELECT r.id, c.name AS company_name, r.reminder_date, r.expiry_date, 
               r.snooze_until, r.subcategory_name, r.category_name
        FROM company_reminders r
        JOIN companies c ON r.company_id = c.id
        WHERE r.status = 'pending'
          AND r.expiry_date IS NOT NULL
          AND (
                (r.category_name = 'MPCB' AND r.expiry_date BETWEEN ? AND ?)
                OR
                (r.category_name != 'MPCB' AND r.expiry_date BETWEEN ? AND ?)
              )
          AND (r.snooze_until IS NULL OR r.snooze_until <= CURDATE())
        ORDER BY r.expiry_date ASC";

$stmt = $conn->prepare($sql);
if (!$stmt) {
    die("Prepare failed: (" . $conn->errno . ") " . $conn->error);
}

// Bind dates: (today, +4 days) + (today, +2 months)
if (!$stmt->bind_param("ssss", $today, $fourDaysLater, $today, $twoMonthsLater)) {
    die("Bind failed: (" . $stmt->errno . ") " . $stmt->error);
}

if (!$stmt->execute()) {
    die("Execute failed: (" . $stmt->errno . ") " . $stmt->error);
}

$stmt->store_result();
$showPopup = $stmt->num_rows > 0;

$reminders = [];

if ($showPopup) {
    $stmt->bind_result(
        $id,
        $companyName,
        $reminderDate,
        $expiryDate,
        $snoozeUntil,
        $subcategoryName,
        $categoryName
    );

    while ($stmt->fetch()) {
        $reminders[] = [
            'id' => $id,
            'company_name' => $companyName,
            'reminder_date' => $reminderDate,
            'expiry_date' => $expiryDate,
            'snooze_until' => $snoozeUntil,
            'subcategory_name' => $subcategoryName,
            'category_name' => $categoryName
        ];
    }
}

$stmt->close();

?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Axle_Services</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="css/header.css">
<link rel="stylesheet" href="css/sidebar.css">
<link rel="stylesheet" href="css/style.css">
<style>
/* Main content styling */
.main-content {
    margin-top: 70px;
    margin-left: 250px;
    padding: 30px 40px;  
    transition: 0.3s ease;
}
@media (max-width: 768px) {
    .main-content { margin-left: 0; }
}


</style>
</head>
<body>

<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>

<div class="main-content">
    <h1 class="mb-4 fw-bold text-dark"> Admin Dashboard</h1>

    <div class="row g-3">
        <?php
       $dashboardItems = [
    'Form 11'                => ['bg' => 'bg-primary',   'link' => 'form_11_list.php'],
    'Form 13'                => ['bg' => 'bg-success',   'link' => 'form_13_list.php'],
    'Shot Blasting'          => ['bg' => 'bg-danger',    'link' => 'shot_blasting_list.php'],
    'Form 9A 9B'             => ['bg' => 'bg-info',      'link' => 'form_9a_9b_list.php'],
    'Work Zone Monitoring'   => ['bg' => 'bg-secondary', 'link' => 'work_zone_monitoring_list.php'],
    'Plan Approval Date'     => ['bg' => 'bg-warning text-dark', 'link' => 'plan_approval_date_list.php'],
    'Factory License'        => ['bg' => 'bg-dark',      'link' => 'factory_license_list.php'],
    'Stability Date'         => ['bg' => 'bg-primary',   'link' => 'stability_date_list.php'],
    'OEP'                    => ['bg' => 'bg-success',   'link' => 'oep_list.php'],
    'Safety Audit'           => ['bg' => 'bg-danger',    'link' => 'safety_audit_list.php'],
    'Testing - Hydraulic'    => ['bg' => 'bg-info',      'link' => 'testing_hydraulic_list.php'],
    'Monitoring'             => ['bg' => 'bg-secondary', 'link' => 'monitoring_list.php'],
    'Bank Guarantee Validity'=> ['bg' => 'bg-warning text-dark', 'link' => 'bank_guarantee_validity_list.php'],
    'Consent Validity'       => ['bg' => 'bg-dark',      'link' => 'consent_validity_list.php'],
];

        ?>

        <?php foreach ($counts as $label => $count): ?>
        <div class="col-6 col-sm-6 col-md-4 d-flex">
            <a href="<?= $dashboardItems[$label]['link'] ?>" class="w-100 text-decoration-none">
                <div class="card <?= $dashboardItems[$label]['bg'] ?> text-white shadow-sm border-0 compact-card h-100 w-100">
                    <div class="card-body text-center py-3 px-3">
                        <!-- Form Name -->
                        <div class="fw-bold mb-2" style="font-size: 1rem;"><?= htmlspecialchars($label) ?></div>
                        <!-- Count in circle -->
                        <div class="count-circle"><?= $count ?></div>
                    </div>
                </div>
            </a>
        </div>
        <?php endforeach; ?>
    </div>
</div>



<!-- Bootstrap Icons -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">



<!-- Reminder Notification Box -->
<?php if ($showPopup): ?>
<div id="reminderBox" class="reminder-box shadow-lg">
    <div class="reminder-header">
        <span>🔔 Reminders</span>
        <button type="button" class="btn-close" id="closeReminder"></button>
    </div>
    <div class="reminder-body">

        <?php foreach ($reminders as $row): ?>
        <div class="reminder-item">
            <div>
                <h6><?= htmlspecialchars($row['company_name'] ?? '') ?></h6>

                <small class="d-block text-secondary">
                    Service: <?= htmlspecialchars($row['subcategory_name'] ?? 'N/A') ?>
                </small>

                <small class="text-danger fw-bold d-block">
                    Valid Up to : <?= htmlspecialchars($row['expiry_date'] ?? '') ?>
                </small>
            </div>

            <div class="btn-group ms-2">
                <a href="reminder_action.php?id=<?= $row['id'] ?>&action=done" class="btn btn-success btn-sm">Ok</a>
                <a href="reminder_action.php?id=<?= $row['id'] ?>&action=snooze&days=5" class="btn btn-warning btn-sm">+5d</a>
                <a href="reminder_action.php?id=<?= $row['id'] ?>&action=snooze&days=10" class="btn btn-warning btn-sm">+10d</a>
            </div>
        </div>
        <?php endforeach; ?>

    </div>
</div>
<?php endif; ?>


<script src="/js/script.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
<?php if ($showPopup): ?>
window.addEventListener('load', function() {
    const box = document.getElementById('reminderBox');
    box.classList.add('show');

    document.getElementById('closeReminder').addEventListener('click', function() {
        box.classList.remove('show');
        setTimeout(() => box.remove(), 400);
    });
});
<?php endif; ?>
</script>

</body>
</html>
<?php ob_end_flush(); ?>
