<?php
ob_start();
session_start();
require_once "config/db.php";

if(!isset($_SESSION['admin'])){
    header("Location: login.php");
    exit;
}

// Handle delete request
if(isset($_GET['delete'])){
    $id = intval($_GET['delete']);
    $conn->query("DELETE FROM companies WHERE id = $id");

    // Reorder sr_no
    $result = $conn->query("SELECT id FROM companies ORDER BY id ASC");
    $sr = 1;
    while($row = $result->fetch_assoc()){
        $conn->query("UPDATE companies SET sr_no = $sr WHERE id = ".$row['id']);
        $sr++;
    }

    header("Location: company_list.php?msg=deleted");
    exit;
}

// Fetch companies Alphabetically by Name
$result = $conn->query("SELECT * FROM companies ORDER BY name ASC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Axle_Services</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap">
<link rel="stylesheet" href="css/header.css">
<link rel="stylesheet" href="css/sidebar.css">

<style>
body {
    background: #f8f9fa;
    font-family: 'Poppins', sans-serif;
}

/* Page header */
.page-header {
    background-color: #3182ce;
    color: #fff;
    padding: 15px;
    text-align: center;
    margin-bottom: 20px;
    border-radius: 8px;
    text-transform: uppercase;
}

/* Sticky Search Bar */
.search-container {
    position: sticky;
    top: 0;
    z-index: 100;
    background: #fff;
    padding: 10px 0;
}

#searchBox {
    width: 100%;
    padding: 8px 10px;
    border: 2px solid #4a5568;
    border-radius: 6px;
}

/* Table container */
.table-container {
    background: #fff;
    padding: 15px;
    border-radius: 10px;
    box-shadow: 0 6px 15px rgba(0,0,0,0.1);
    overflow-x: auto;
}

.main-content {
    margin-top: 70px;
    margin-left: 250px;
    padding: 20px;
    transition: all 0.3s ease;
}

.table td,
.table th {
    white-space: nowrap;
    vertical-align: middle;
}

@media (max-width: 768px) {
    .main-content {
        margin-left: 0;
    }
}
</style>
</head>

<body>

<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>

<div class="main-content">

    <div class="page-header">
        <h1>Company List</h1>
    </div>

    <!--  Sticky Search Bar -->
    <div class="search-container">
        <input type="text" id="searchBox" placeholder="Search company...">
    </div>

    <div class="table-container">
        <?php if(isset($_GET['msg']) && $_GET['msg']=='deleted'): ?>
            <div class="alert alert-success">Company deleted successfully!</div>
        <?php endif; ?>

        <table class="table table-bordered table-striped table-hover align-middle">
            <thead class="table-primary">
                <tr>
                    <th>Sr. No</th>
                    <th>Name</th>
                    <th>Contact Person</th>
                    <th>Email</th>
                    <th>Address</th>
                    <th>GST Cert. No.</th>
                    <th>Other</th>
                    <th>Actions</th>
                </tr>
            </thead>

            <tbody id="companyTable">
            <?php 
            if($result->num_rows > 0): 
                $sr = 1;
                while($row = $result->fetch_assoc()): 
            ?>
                <tr>
                    <td><?= $sr++; ?></td>
                    <td><?= htmlspecialchars($row['name']); ?></td>
                    <td><?= htmlspecialchars($row['contact_person']); ?></td>
                    <td><?= htmlspecialchars($row['email']); ?></td>
                    <td><?= htmlspecialchars($row['address']); ?></td>
                    <td><?= htmlspecialchars($row['company_cert']); ?></td>
                    <td><?= htmlspecialchars($row['other']); ?></td>
                    <td>
                        <a href="edit_company.php?id=<?= $row['id']; ?>" class="btn btn-sm btn-warning">Edit</a>
                        <a href="company_list.php?delete=<?= $row['id']; ?>" 
                           class="btn btn-sm btn-danger" 
                           onclick="return confirm('Delete this company?');">
                           Delete
                        </a>
                    </td>
                </tr>
            <?php 
                endwhile;
            else: 
            ?>
                <tr><td colspan="14" class="text-center">No companies found</td></tr>
            <?php endif; ?>
            </tbody>

        </table>
    </div>
</div>

<script src="/js/script.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<!-- 🔍 LIVE FILTER SCRIPT (prefix match) -->
<script>
document.getElementById('searchBox').addEventListener('keyup', function () {
    let value = this.value.toLowerCase();
    let rows = document.querySelectorAll("#companyTable tr");

    rows.forEach(row => {
        let name = row.cells[1].innerText.toLowerCase();  
        row.style.display = name.startsWith(value) ? "" : "none";
    });
});
</script>

</body>
</html>

<?php ob_end_flush(); ?>
