<?php
ob_start();
session_start();
require_once "config/db.php";

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

$success_message = '';
$error_message = '';

$category_name = 'Sustanibility';
$subcategory_name = 'CBAM';
$validity_months = 12;



if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $company_id = (int)$_POST['company_id'];
    $reminder_date = $_POST['reminder_date'];

    if ($company_id <= 0) {
        $error_message = "Please select a valid company.";
    } else {
        $expiry_date = date('Y-m-d', strtotime("+$validity_months months", strtotime($reminder_date)));

        $stmt = $conn->prepare("INSERT INTO company_reminders (company_id, category_name, subcategory_name, reminder_date, expiry_date) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("issss", $company_id, $category_name, $subcategory_name, $reminder_date, $expiry_date);

        if ($stmt->execute()) {
            $_SESSION['success_message'] = "CBAM validity added successfully!";
            header("Location: " . $_SERVER['PHP_SELF']);
            exit;
        } else {
            $error_message = "Error: " . $stmt->error;
        }
        $stmt->close();
    }
}

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Axle_Services</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="css/style.css" />
    <link rel="stylesheet" href="css/header.css" />
    <link rel="stylesheet" href="css/sidebar.css" />
    <style>
        body {
            background: #f9fafb;
            
            color: #333;
            min-height: 100vh;
        }

        .main-content {
            margin-top: 70px;
            margin-left: 250px;
            padding: 30px 40px;
            transition: all 0.3s ease;
            min-height: calc(100vh - 70px);
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 8px 24px rgb(0 0 0 / 0.05);
        }

        @media (max-width: 991.98px) {
            .main-content {
                margin-left: 0;
                padding: 20px;
                border-radius: 0;
                box-shadow: none;
            }
        }

        .page-header {
            background-color: #0d6efd;
            color: #fff;
            padding: 20px 25px;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgb(13 110 253 / 0.3);
            margin-bottom: 30px;
            text-align: center;
            font-weight: 600;
            font-size: 1.8rem;
            letter-spacing: 0.03em;
        }

        form {
            max-width: 800px;
            margin: 0 auto;
        }

        label.form-label {
            font-weight: 600;
            color: #495057;
        }

        input.form-control,
        select.form-select {
            border-radius: 8px;
            border: 1.5px solid #ced4da;
            padding: 10px 14px;
            font-size: 1rem;
            transition: border-color 0.3s ease, box-shadow 0.3s ease;
        }

        input.form-control:focus,
        select.form-select:focus {
            border-color: #0d6efd;
            box-shadow: 0 0 8px rgb(13 110 253 / 0.25);
            outline: none;
        }

        .btn-success {
            background-color: #198754;
            border-color: #198754;
            font-weight: 600;
            font-size: 1.1rem;
            padding: 12px 40px;
            border-radius: 50px;
            transition: background-color 0.3s ease, box-shadow 0.3s ease;
        }

        .btn-success:hover {
            background-color: #157347;
            box-shadow: 0 6px 15px rgb(21 115 71 / 0.4);
        }

        .alert {
            max-width: 800px;
            margin: 0 auto 30px auto;
            border-radius: 10px;
            font-weight: 600;
            font-size: 1rem;
        }

        #companyList {
            z-index: 1000;
            width: 100%;
        }
    </style>
</head>

<body>
    <?php include 'header.php'; ?>
    <?php include 'sidebar.php'; ?>

    <div class="main-content">
        <div class="page-header">Add CBAM Validity</div>

        <?php if ($error_message): ?>
            <div class="alert alert-danger shadow-sm"><?= htmlspecialchars($error_message) ?></div>
        <?php endif; ?>
        <?php if (isset($_SESSION['success_message'])): ?>
            <div class="alert alert-success shadow-sm"><?= htmlspecialchars($_SESSION['success_message']) ?></div>
            <?php unset($_SESSION['success_message']); ?>
        <?php endif; ?>

        <form method="POST" class="row g-4" novalidate>
            <!-- Company Search -->
            <div class="row align-items-center mb-3 mt-3">
                <div class="col-md-4">
                    <label class="form-label">Select Company</label>
                </div>
                <div class="col-md-8 position-relative">
                    <input type="text" id="companySearch" class="form-control" placeholder="Type company name..." autocomplete="off" required>
                    <input type="hidden" name="company_id" id="companyId">
                    <div id="companyList" class="list-group position-absolute bg-light"></div>
                </div>
            </div>

            <!-- Reminder Date -->
            <div class="row align-items-center mb-3">
                <div class="col-md-4"><label class="form-label">Consent Renewal Date</label></div>
                <div class="col-md-4"><input type="date" name="reminder_date" class="form-control" value="<?= date('Y-m-d'); ?>" required></div>
            </div>

            <!-- Submit Button -->
            <div class="col-12 text-center mt-4">
                <button type="submit" class="btn btn-success px-5">Submit</button>
            </div>
        </form>
    </div>

    <script>
        const companySearch = document.getElementById("companySearch");
        const companyIdInput = document.getElementById("companyId");
        const companyList = document.getElementById("companyList");

        companySearch.addEventListener("keyup", function() {
            let query = this.value.trim();
            if (query.length < 1) {
                companyList.innerHTML = "";
                companyList.style.display = "none";
                return;
            }

            fetch("get_companies.php?query=" + encodeURIComponent(query))
                .then(res => res.json())
                .then(data => {
                    if (data.length > 0) {
                        companyList.innerHTML = data.map(c =>
                            `<button type="button" class="list-group-item list-group-item-action" data-id="${c.id}" data-name="${c.name}">${c.name}</button>`
                        ).join('');
                        companyList.style.display = "block";

                        document.querySelectorAll("#companyList .list-group-item-action").forEach(btn => {
                            btn.addEventListener("click", function() {
                                companySearch.value = this.dataset.name;
                                companyIdInput.value = this.dataset.id;
                                companyList.innerHTML = "";
                                companyList.style.display = "none";
                            });
                        });
                    } else {
                        companyList.innerHTML = "<div class='list-group-item'>No companies found</div>";
                        companyList.style.display = "block";
                    }
                });
        });

        document.addEventListener("click", function(e) {
            if (!companyList.contains(e.target) && e.target !== companySearch) {
                companyList.innerHTML = "";
                companyList.style.display = "none";
            }
        });
    </script>
    <script src="/js/script.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
<?php ob_end_flush(); ?>