<?php
ob_start();
session_start();
require_once "config/db.php";

if(!isset($_SESSION['admin'])){
    header("Location: login.php");
    exit;
}

$error = '';
$success = '';

// Fetch categories for dropdown
$categories_result = $conn->query("SELECT id, name FROM categories ORDER BY name ASC");

// Handle Add/Edit Subcategory form
if($_SERVER['REQUEST_METHOD'] == 'POST'){
    $name = trim($_POST['name']);
    $category_id = $_POST['category_id'];
    $validity = $_POST['validity_months'];
    
    if(isset($_POST['subcategory_id']) && !empty($_POST['subcategory_id'])){
        // Edit subcategory
        $id = intval($_POST['subcategory_id']);
        $stmt = $conn->prepare("UPDATE subcategories SET name=?, category_id=?, validity_months=? WHERE id=?");
        $stmt->bind_param("siii", $name, $category_id, $validity, $id);
        if($stmt->execute()){
            $_SESSION['success'] = "Subcategory updated successfully!";
            header("Location: add_subcategory.php"); // Redirect after POST
            exit;
        } else {
            $error = "Error: ".$conn->error;
        }
    } else {
        // Add new subcategory
        if(!empty($name) && !empty($category_id) && !empty($validity)){
            $stmt = $conn->prepare("INSERT INTO subcategories (category_id, name, validity_months, created_at) VALUES (?, ?, ?, NOW())");
            $stmt->bind_param("isi", $category_id, $name, $validity);
            if($stmt->execute()){
                $_SESSION['success'] = "Subcategory added successfully!";
                header("Location: add_subcategory.php"); // Redirect after POST
                exit;
            } else {
                $error = "Error: ".$conn->error;
            }
        } else {
            $error = "All fields are required.";
        }
    }
}

// Fetch subcategories with parent category name
$subcategories = $conn->query("
    SELECT s.id, s.name AS sub_name, c.name AS cat_name, s.validity_months, s.created_at 
    FROM subcategories s 
    JOIN categories c ON s.category_id = c.id 
    ORDER BY s.id DESC
");

// Handle delete
if(isset($_GET['delete']) && is_numeric($_GET['delete'])){
    $id = intval($_GET['delete']);
    $stmt = $conn->prepare("DELETE FROM subcategories WHERE id = ?");
    $stmt->bind_param("i", $id);
    if($stmt->execute()){
        $_SESSION['success'] = "Subcategory deleted successfully!";
        header("Location: add_subcategory.php"); // Redirect after delete
        exit;
    } else {
        $error = "Error deleting category: " . $conn->error;
    }
    $stmt->close();
}

// Handle edit
$edit_subcategory = null;
if(isset($_GET['edit']) && is_numeric($_GET['edit'])){
    $id = intval($_GET['edit']);
    $stmt = $conn->prepare("SELECT * FROM subcategories WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $edit_subcategory = $stmt->get_result()->fetch_assoc();
    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Axle_Services</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
<link rel="stylesheet" href="css/style.css">
<link rel="stylesheet" href="css/header.css">
<link rel="stylesheet" href="css/sidebar.css">
<style>
body { background: #f9fafb;  color: #333; min-height: 100vh; }
.page-header { background-color: #38b2ac; color: #fff; padding: 15px 20px; border-bottom: 4px solid #319795; text-transform: uppercase; border-radius: 8px 8px 0 0; font-weight: 600; box-shadow: 0 2px 6px rgba(0,0,0,0.1); margin-bottom: 20px; text-align: center; }
.page-header h1 { font-size: 28px; font-weight: 600; color:#fff; }
.add-subcategory-row { display: flex; gap: 10px; flex-wrap: wrap; margin-bottom: 20px; }
.add-subcategory-row input,
.add-subcategory-row select {
    flex: 1;
    border: 1.5px solid #ced4da;
    border-radius: 8px;
    height: 45px;
    padding: 0 12px;
    font-size: 1rem;
}
.add-subcategory-row button { height: 45px; }
.btn i { margin-right: 5px; }
.alert { border-radius: 10px; }
.table th { background-color: #667eea; color: #fff; position: sticky; top: 0; z-index: 1; }
.main-content { margin-top: 70px; margin-left: 250px; padding: 30px 40px; transition: all 0.3s ease; background: #fff; border-radius: 12px; box-shadow: 0 8px 24px rgb(0 0 0 / 0.05); }
@media(max-width: 991.98px){ 
    .main-content { margin-left: 0; padding: 15px 10px; border-radius: 0; }
    .add-subcategory-row input, .add-subcategory-row select, .add-subcategory-row button { flex: 100%; }
}
</style>
</head>
<body>

<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>

<div class="main-content">
    <div class="page-header"><h1><?= $edit_subcategory ? 'Edit Subcategory' : 'Add Subcategory'; ?></h1></div>

    <!-- Success/Error Messages -->
    <?php if(isset($_SESSION['success'])) { echo "<div class='alert alert-success'>".$_SESSION['success']."</div>"; unset($_SESSION['success']); } ?>
    <?php if($error) echo "<div class='alert alert-danger'>$error</div>"; ?>

    <!-- Add/Edit Subcategory Form -->
    <form method="POST" class="add-subcategory-row mb-3">
        <input type="text" class="form-control" name="name" placeholder="Enter subcategory name" required value="<?= $edit_subcategory ? htmlspecialchars($edit_subcategory['name']) : '' ?>">
        <select class="form-select" name="category_id" required>
            <option value="">Select Category</option>
            <?php 
            $categories_result = $conn->query("SELECT id, name FROM categories ORDER BY name ASC");
            while($cat = $categories_result->fetch_assoc()): ?>
                <option value="<?= $cat['id']; ?>" <?= $edit_subcategory && $edit_subcategory['category_id']==$cat['id'] ? 'selected' : '' ?>><?= htmlspecialchars($cat['name']); ?></option>
            <?php endwhile; ?>
        </select>
        <input type="number" name="validity_months" class="form-control" placeholder="Validity (months)" min="1" required value="<?= $edit_subcategory ? $edit_subcategory['validity_months'] : '' ?>">
        <?php if($edit_subcategory): ?>
            <input type="hidden" name="subcategory_id" value="<?= $edit_subcategory['id']; ?>">
            <button type="submit" class="btn btn-warning"><i class="bi bi-pencil-square"></i> Update Subcategory</button>
        <?php else: ?>
            <button type="submit" class="btn btn-primary"><i class="bi bi-plus-circle"></i> Add Subcategory</button>
        <?php endif; ?>
    </form>

    <!-- Subcategory Table -->
    <div class="table-responsive">
    <table class="table table-bordered table-striped table-hover align-middle">
        <thead>
            <tr>
                <th>#</th>
                <th>Subcategory</th>
                <th>Category</th>
                <th class="d-none d-md-table-cell">Validity (Months)</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php if($subcategories->num_rows > 0): $i=1; ?>
                <?php while($row = $subcategories->fetch_assoc()): ?>
                    <tr>
                        <td><?= $i++; ?></td>
                        <td><?= htmlspecialchars($row['sub_name']); ?></td>
                        <td><?= htmlspecialchars($row['cat_name']); ?></td>
                        <td class="d-none d-md-table-cell"><?= $row['validity_months']; ?></td>
                        <td>
                            <a href="?edit=<?= $row['id']; ?>" class="btn btn-warning btn-sm"><i class="bi bi-pencil-square"></i></a>
                            <a href="?delete=<?= $row['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')"><i class="bi bi-trash"></i></a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr><td colspan="5" class="text-center">No subcategories found.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
    </div>
</div>

<script src="/js/script.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php ob_end_flush(); ?>
