<?php
ob_start();
session_start();
require_once "config/db.php";

if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

$success_message = '';
$error_message = '';

// get category and subcategory from URL
$category_id = isset($_GET['cat']) ? (int)$_GET['cat'] : 0;
$subcategory_id = isset($_GET['sub']) ? (int)$_GET['sub'] : 0;

// block access if not provided
if ($category_id === 0 || $subcategory_id === 0) {
    die("<div style='margin:50px auto;max-width:600px;text-align:center;font-family:sans-serif;'>
            <h2 style='color:red;'>Error</h2>
            <p>Please select a category and subcategory from the menu first.</p>
            <a href='dashboard.php'>Back to Dashboard</a>
        </div>");
}

// fetch category and subcategory names
$catName = $subName = '';
if ($category_id) {
    $res = $conn->query("SELECT name FROM categories WHERE id=$category_id");
    if ($res && $row = $res->fetch_assoc()) {
        $catName = $row['name'];
    }
}
if ($subcategory_id) {
    $res = $conn->query("SELECT name FROM subcategories WHERE id=$subcategory_id");
    if ($res && $row = $res->fetch_assoc()) {
        $subName = $row['name'];
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $company_id = (int)$_POST['company_id'];
    $category_id = (int)$_POST['category_id'];
    $subcategory_id = (int)$_POST['subcategory_id'];
    $reminder_date = $_POST['reminder_date'];

    // 1. Get subcategory name & validity months
    $stmt = $conn->prepare("SELECT name, validity_months FROM subcategories WHERE id = ?");
    $stmt->bind_param("i", $subcategory_id);
    $stmt->execute();
    $stmt->bind_result($subName, $validity_months);
    $stmt->fetch();
    $stmt->close();

    // 2. Calculate expiry date
    if ($subName === 'Form 11') {
        // Hardcoded expiry to December 31 of the reminder year
        $year = date('Y', strtotime($reminder_date));
        $expiry_date = "$year-12-31";
    } elseif (!empty($validity_months) && $validity_months > 0) {
        $expiry_date = date('Y-m-d', strtotime("+$validity_months months", strtotime($reminder_date)));
    } else {
        $expiry_date = null; // no validity
    }

    // 3. Insert reminder
    $sql = "INSERT INTO company_reminders (company_id, category_id, subcategory_id, reminder_date, expiry_date) 
            VALUES (?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("iiiss", $company_id, $category_id, $subcategory_id, $reminder_date, $expiry_date);

    if ($stmt->execute()) {
        $_SESSION['success_message'] = "Reminder added successfully!";
        header("Location: " . $_SERVER['PHP_SELF'] . "?cat=$category_id&sub=$subcategory_id");
        exit;
    } else {
        $error_message = "Error: " . $stmt->error;
    }
    $stmt->close();
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Axle_Services</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
<link rel="stylesheet" href="css/style.css" />
<link rel="stylesheet" href="css/header.css" />
<link rel="stylesheet" href="css/sidebar.css" />
<style>
body { background: #f9fafb;  color: #333; min-height: 100vh; }
.main-content {
    margin-top: 70px;
    margin-left: 250px;
    padding: 30px 40px;
    transition: all 0.3s ease;
    min-height: calc(100vh - 70px);
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 8px 24px rgb(0 0 0 / 0.05);
}
@media (max-width: 991.98px) {
    .main-content { margin-left: 0; padding: 20px; border-radius: 0; box-shadow: none; }
}
.page-header {
    background-color: #0d6efd;
    color: #fff;
    padding: 20px 25px;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgb(13 110 253 / 0.3);
    margin-bottom: 30px;
    text-align: center;
    font-weight: 600;
    font-size: 1.8rem;
    letter-spacing: 0.03em;
}
form { max-width: 800px; margin: 0 auto; }
label.form-label { font-weight: 600; color: #495057; }
input.form-control, select.form-select {
    border-radius: 8px;
    border: 1.5px solid #ced4da;
    padding: 10px 14px;
    font-size: 1rem;
    transition: border-color 0.3s ease, box-shadow 0.3s ease;
}
input.form-control:focus, select.form-select:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 8px rgb(13 110 253 / 0.25);
    outline: none;
}
.btn-success {
    background-color: #198754;
    border-color: #198754;
    font-weight: 600;
    font-size: 1.1rem;
    padding: 12px 40px;
    border-radius: 50px;
    transition: background-color 0.3s ease, box-shadow 0.3s ease;
}
.btn-success:hover { background-color: #157347; box-shadow: 0 6px 15px rgb(21 115 71 / 0.4); }
.alert { max-width: 800px; margin: 0 auto 30px auto; border-radius: 10px; font-weight: 600; font-size: 1rem; }
#companyList { z-index: 1000; width: 100%; }
</style>
</head>
<body>
<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>

<div class="main-content">
  <div class="page-header">Add Company Reminder</div>

  <?php if ($error_message): ?>
    <div class="alert alert-danger shadow-sm"><?= htmlspecialchars($error_message) ?></div>
  <?php endif; ?>
  <?php if (isset($_SESSION['success_message'])): ?>
    <div class="alert alert-success shadow-sm"><?= htmlspecialchars($_SESSION['success_message']) ?></div>
    <?php unset($_SESSION['success_message']); ?>
  <?php endif; ?>

  <form method="POST" class="row g-4" novalidate>

    <!-- Company Search -->
    <div class="row align-items-center mb-3 mt-3">
      <div class="col-md-4">
        <label class="form-label">Select Company</label>
      </div>
      <div class="col-md-8 position-relative">
        <input type="text" id="companySearch" class="form-control" placeholder="Type company name..." autocomplete="off" required>
        <input type="hidden" name="company_id" id="companyId">
        <div id="companyList" class="list-group position-absolute bg-light"></div>
      </div>
    </div>

    <!-- Show chosen category & subcategory -->
    <input type="hidden" name="category_id" value="<?= $category_id ?>">
    <input type="hidden" name="subcategory_id" value="<?= $subcategory_id ?>">

    <div class="row align-items-center mb-3">
      <div class="col-md-4">
        <label class="form-label">Selected Category</label>
      </div>
      <div class="col-md-8">
        <input type="text" class="form-control" value="<?= htmlspecialchars($catName) ?>" readonly>
      </div>
    </div>

    <div class="row align-items-center mb-3">
      <div class="col-md-4">
        <label class="form-label">Selected Subcategory</label>
      </div>
      <div class="col-md-8">
        <input type="text" class="form-control" value="<?= htmlspecialchars($subName) ?>" readonly>
      </div>
    </div>

    <!-- Reminder Date -->
    <div class="row align-items-center mb-3">
      <div class="col-md-4">
        <label class="form-label">Reminder Date</label>
      </div>
      <div class="col-md-4">
        <input type="date" name="reminder_date" class="form-control" value="<?= date('Y-m-d'); ?>" required>
      </div>
    </div>

    <!-- Submit Button -->
    <div class="col-12 text-center mt-4">
      <button type="submit" class="btn btn-success px-5">Save Reminder</button>
    </div>
  </form>
</div>

<script>
// Company search autocomplete
const companySearch = document.getElementById("companySearch");
const companyIdInput = document.getElementById("companyId");
const companyList = document.getElementById("companyList");

companySearch.addEventListener("keyup", function() {
    let query = this.value.trim();
    if (query.length < 1) {
        companyList.innerHTML = "";
        companyList.style.display = "none";
        return;
    }

    fetch("get_companies.php?query=" + encodeURIComponent(query))
        .then(res => res.json())
        .then(data => {
            if (data.length > 0) {
                let list = "";
                data.forEach(c => {
                    list += `<button type="button" class="list-group-item list-group-item-action company-option"
                                 data-id="${c.id}" data-name="${c.name}">${c.name}</button>`;
                });
                companyList.innerHTML = list;
                companyList.style.display = "block";

                document.querySelectorAll(".company-option").forEach(btn => {
                    btn.addEventListener("click", function() {
                        companySearch.value = this.dataset.name;
                        companyIdInput.value = this.dataset.id;
                        companyList.innerHTML = "";
                        companyList.style.display = "none";
                    });
                });
            } else {
                companyList.innerHTML = "<div class='list-group-item'>No companies found</div>";
                companyList.style.display = "block";
            }
        });
});

// Hide the company list if user clicks outside
document.addEventListener("click", function(e) {
    if (!companyList.contains(e.target) && e.target !== companySearch) {
        companyList.innerHTML = "";
        companyList.style.display = "none";
    }
});
</script>

<script src="/js/script.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php ob_end_flush(); ?>
