<?php
ob_start();
session_start();
require_once "config/db.php";

if(!isset($_SESSION['admin'])){
    header("Location: login.php");
    exit;
}

$error = '';
$success = '';

//  Handle Delete request
if(isset($_GET['delete']) && is_numeric($_GET['delete'])){
    $id = intval($_GET['delete']);

    $stmt = $conn->prepare("DELETE FROM categories WHERE id = ?");
    $stmt->bind_param("i", $id);

    if($stmt->execute()){
        $success = "Category deleted successfully!";
    } else {
        $error = "Error deleting category: " . $conn->error;
    }
    $stmt->close();
}

// ✅ Handle Add Category form submission
if($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['name'])){
    $name = trim($_POST['name']);
    if(!empty($name)){
        $stmt = $conn->prepare("INSERT INTO categories (name, created_at) VALUES (?, NOW())");
        $stmt->bind_param("s", $name);
        if($stmt->execute()){
            $success = "Category added successfully!";
        } else {
            $error = "Error: ".$conn->error;
        }
    } else {
        $error = "Category name cannot be empty.";
    }
}

// ✅ Fetch all categories
$categories = $conn->query("SELECT * FROM categories ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Axle_Services</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
<link rel="stylesheet" href="css/style.css">
<link rel="stylesheet" href="css/header.css">
<link rel="stylesheet" href="css/sidebar.css">
<style>
body {
    font-family: 'Inter', sans-serif;
    background-color: #f4f6f9;
}
.main-content {
    margin-top: 70px; 
    margin-left: 250px; 
    padding: 20px;
    transition: all 0.3s ease;
}

/* Page header */
.page-header {
    background-color: #38b2ac;
    color: #fff;
    padding: 15px 20px;
    border-bottom: 4px solid #319795;
    border-radius: 8px 8px 0 0;
    font-weight: 600;
    margin-bottom: 20px;
    text-align: center;
    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
}
.page-header h1 {
    font-size: 24px;
    margin: 0;
}

/* Add category form */
.add-category-row {
    display: flex;
    gap: 10px;
    flex-wrap: wrap;
    margin-bottom: 20px;
}
.add-category-row input {
    flex: 1;
}

/* Card + Table */
.card-table {
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 8px 20px rgba(0,0,0,0.08);
    padding: 20px;
}
.table th {
    background: #5a67d8;
    color: #fff;
    text-align: center;
    white-space: nowrap;
}
.table td {
    text-align: center;
    vertical-align: middle;
    white-space: nowrap;
}
.table-hover tbody tr:hover {
    background-color: #f1f3f6;
}
.table-responsive {
    overflow-x: auto;
}

/* Alerts */
.alert {
    border-radius: 8px;
}

/* Mobile adjustments */
@media(max-width: 768px){
    .main-content { margin-left: 0; }
    .page-header h1 { font-size: 20px; }
    .table td, .table th { font-size: 13px; padding: 6px; }
    .btn-sm { font-size: 12px; padding: 4px 8px; }
}
</style>
</head>
<body>

<?php include 'header.php'; ?>
<?php include 'sidebar.php'; ?>

<div class="main-content">
    <!-- Page header -->
    <div class="page-header">
        <h1>Manage Categories</h1>
    </div>

    <!-- Add Category Form -->
    <form method="POST" action="" class="add-category-row mb-3">
        <input type="text" class="form-control" name="name" placeholder="Enter category name" required>
        <button type="submit" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Add
        </button>
    </form>

    <!-- Success/Error Messages -->
    <?php if($error): ?>
        <div class="alert alert-danger"><?php echo $error; ?></div>
    <?php endif; ?>
    <?php if($success): ?>
        <div class="alert alert-success"><?php echo $success; ?></div>
    <?php endif; ?>

    <!-- Category List -->
    <div class="card-table">
        <h4 class="mb-3">Category List</h4>
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Category Name</th>
                        <th>Created At</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($categories->num_rows > 0): ?>
                        <?php while($row = $categories->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo $row['id']; ?></td>
                                <td><?php echo $row['name']; ?></td>
                                <td><?php echo $row['created_at']; ?></td>
                                <td>
                                    <a href="?delete=<?php echo $row['id']; ?>" 
                                       class="btn btn-sm btn-danger" 
                                       onclick="return confirm('Delete this category?');">
                                       <i class="bi bi-trash"></i> Delete
                                    </a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr><td colspan="4" class="text-center">No categories found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<script src="/js/script.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php ob_end_flush(); ?>